/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.jnlplauncher;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class InstalledFileLocatorImpl
extends InstalledFileLocator {
    public File locate(String relativePath, String codeNameBase, boolean localized) {
        if (localized) {
            String ext;
            String baseName;
            int i = relativePath.lastIndexOf(46);
            if (i == -1 || i < relativePath.lastIndexOf(47)) {
                baseName = relativePath;
                ext = "";
            } else {
                baseName = relativePath.substring(0, i);
                ext = relativePath.substring(i);
            }
            Iterator it = NbBundle.getLocalizingSuffixes();
            while (it.hasNext()) {
                String locName = baseName + (String)it.next() + ext;
                File f = this.locate(locName, codeNameBase, false);
                if (f == null) continue;
                return f;
            }
        } else {
            File f;
            String userdir = System.getProperty("netbeans.user");
            if (userdir != null && (f = new File(userdir, relativePath.replace('/', File.separatorChar))).exists()) {
                return f;
            }
            String resource = "META-INF/clusterpath/" + relativePath;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL found = loader.getResource(resource);
            if (found != null) {
                String infix;
                String foundS = found.toExternalForm();
                String prefix = "jar:";
                String suffix = "!/" + resource;
                if (foundS.startsWith(prefix) && foundS.endsWith(suffix) && (infix = foundS.substring(prefix.length(), foundS.length() - suffix.length())).startsWith("file:")) {
                    File jar = new File(URI.create(infix));
                    assert (jar.isFile());
                    return jar;
                }
            }
        }
        return null;
    }
}

