/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.schema;

import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.xml.xpath.ext.XPathCoreFunction;
import org.netbeans.modules.xml.xpath.ext.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathExtensionFunction;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathOperationOrFuntion;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.XPathSchemaContext;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitorAdapter;

public class ToRelativePathConverter
extends XPathVisitorAdapter {
    private XPathExpression mRootExpr;
    private XPathSchemaContext mContext;

    public ToRelativePathConverter(XPathExpression xPathExpression, XPathSchemaContext xPathSchemaContext) {
        assert (xPathExpression != null && xPathSchemaContext != null);
        this.mRootExpr = xPathExpression;
        this.mContext = xPathSchemaContext;
    }

    public XPathExpression convert() {
        this.mRootExpr.accept(this);
        return this.mRootExpr;
    }

    public void visit(XPathCoreFunction xPathCoreFunction) {
        this.visitChildren(xPathCoreFunction);
    }

    public void visit(XPathCoreOperation xPathCoreOperation) {
        this.visitChildren(xPathCoreOperation);
    }

    public void visit(XPathExtensionFunction xPathExtensionFunction) {
        this.visitChildren(xPathExtensionFunction);
    }

    public void visit(XPathExpressionPath xPathExpressionPath) {
        XPathLocationPath xPathLocationPath = XPathSchemaContext.Utilities.generateRelativePath(xPathExpressionPath, this.mContext);
        if (xPathLocationPath != null && xPathExpressionPath == this.mRootExpr) {
            this.mRootExpr = xPathLocationPath;
        }
    }

    protected void visitChildren(XPathOperationOrFuntion xPathOperationOrFuntion) {
        List<XPathExpression> list = xPathOperationOrFuntion.getChildren();
        if (list != null) {
            ListIterator<XPathExpression> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                XPathExpression xPathExpression = listIterator.next();
                if (xPathExpression instanceof XPathExpressionPath) {
                    XPathLocationPath xPathLocationPath = XPathSchemaContext.Utilities.generateRelativePath((XPathExpressionPath)xPathExpression, this.mContext);
                    if (xPathLocationPath == null) continue;
                    listIterator.set(xPathLocationPath);
                    continue;
                }
                xPathExpression.accept(this);
            }
        }
    }
}

