/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.metadata;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.xml.xpath.ext.metadata.AbstractArgument;
import org.netbeans.modules.xml.xpath.ext.metadata.XPathType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArgumentDescriptor
implements AbstractArgument {
    private XPathType mType;
    private int mMinOccurs;
    private int mMaxOccurs;
    private String mDescription;
    private List<XPathType> mCanBeAssignedFrom;
    public static final List<XPathType> NOT_ASSIGNABLE = Collections.emptyList();
    public static final List<XPathType> NODE_SET_ASSIGNABLE = Collections.singletonList(XPathType.NODE_SET_TYPE);

    public ArgumentDescriptor(XPathType xPathType, boolean bl, boolean bl2, List<XPathType> list) {
        this.mType = xPathType;
        this.mMinOccurs = bl ? 1 : 0;
        this.mMaxOccurs = bl2 ? Integer.MAX_VALUE : 1;
        this.mCanBeAssignedFrom = list;
    }

    public ArgumentDescriptor(XPathType xPathType, int n, int n2, String string, List<XPathType> list) {
        this.mType = xPathType;
        this.mMinOccurs = n;
        this.mMaxOccurs = n2;
        this.mDescription = string;
        this.mCanBeAssignedFrom = list;
    }

    public XPathType getArgumentType() {
        return this.mType;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public boolean isMandatory() {
        return this.mMinOccurs > 0;
    }

    @Override
    public boolean isRepeated() {
        return this.mMaxOccurs > 1;
    }

    @Override
    public int getMinOccurs() {
        return this.mMinOccurs;
    }

    @Override
    public int getMaxOccurs() {
        return this.mMaxOccurs;
    }

    public List<XPathType> canBeAssignedFromTypes() {
        return this.mCanBeAssignedFrom;
    }

    public static interface Predefined {
        public static final List<XPathType> NOT_ASSIGNABLE = Collections.emptyList();
        public static final List<XPathType> NODE_SET_ASSIGNABLE = Collections.singletonList(XPathType.NODE_SET_TYPE);
        public static final ArgumentDescriptor ANY_TYPE = new ArgumentDescriptor(XPathType.ANY_TYPE, true, false, null);
        public static final ArgumentDescriptor OPTIONAL_ANY_TYPE = new ArgumentDescriptor(XPathType.ANY_TYPE, false, false, null);
        public static final ArgumentDescriptor SIMPLE_BOOLEAN = new ArgumentDescriptor(XPathType.BOOLEAN_TYPE, true, false, null);
        public static final ArgumentDescriptor SIMPLE_STRING = new ArgumentDescriptor(XPathType.STRING_TYPE, true, false, null);
        public static final ArgumentDescriptor OPTIONAL_STRING = new ArgumentDescriptor(XPathType.STRING_TYPE, false, false, null);
        public static final ArgumentDescriptor REPEATED_STRING_2MIN = new ArgumentDescriptor(XPathType.STRING_TYPE, 2, Integer.MAX_VALUE, null, null);
        public static final ArgumentDescriptor SIMPLE_NUMBER = new ArgumentDescriptor(XPathType.NUMBER_TYPE, true, false, null);
        public static final ArgumentDescriptor OPTIONAL_NUMBER = new ArgumentDescriptor(XPathType.NUMBER_TYPE, false, false, null);
        public static final ArgumentDescriptor REPEATED_NUMBER_2MIN = new ArgumentDescriptor(XPathType.NUMBER_TYPE, 2, Integer.MAX_VALUE, null, null);
        public static final ArgumentDescriptor SIMPLE_NODE = new ArgumentDescriptor(XPathType.NODE_TYPE, true, false, NODE_SET_ASSIGNABLE);
        public static final ArgumentDescriptor OPTIONAL_NODE = new ArgumentDescriptor(XPathType.NODE_TYPE, false, false, NODE_SET_ASSIGNABLE);
        public static final ArgumentDescriptor SIMPLE_NODE_SET = new ArgumentDescriptor(XPathType.NODE_SET_TYPE, true, false, NOT_ASSIGNABLE);
        public static final ArgumentDescriptor REPEATED_NODE_SET_2MIN = new ArgumentDescriptor(XPathType.NODE_SET_TYPE, 2, Integer.MAX_VALUE, null, NOT_ASSIGNABLE);
    }
}

