/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.impl;

import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.StepNodeNameTest;
import org.netbeans.modules.xml.xpath.ext.StepNodeTest;
import org.netbeans.modules.xml.xpath.ext.StepNodeTypeTest;
import org.netbeans.modules.xml.xpath.ext.XPathAxis;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.ext.XPathUtils;
import org.netbeans.modules.xml.xpath.ext.impl.XPathExpressionImpl;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.XPathSchemaContext;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitor;

public class LocationStepImpl
extends XPathExpressionImpl
implements LocationStep {
    private static XPathAxis[] int2Axis = new XPathAxis[]{XPathAxis.SELF, XPathAxis.CHILD, XPathAxis.PARENT, XPathAxis.ANCESTOR, XPathAxis.ATTRIBUTE, XPathAxis.NAMESPACE, XPathAxis.PRECEDING, XPathAxis.FOLLOWING, XPathAxis.DESCENDANT, XPathAxis.ANCESTOR_OR_SELF, XPathAxis.DESCENDANT_OR_SELF, XPathAxis.FOLLOWING_SIBLING, XPathAxis.PRECEDING_SIBLING};
    private XPathAxis mAxis;
    private StepNodeTest mNodeTest;
    private XPathPredicateExpression[] mPredicates = null;
    private XPathSchemaContext mSchemaContext;

    public LocationStepImpl(XPathModel xPathModel) {
        this(xPathModel, 0, null, null);
    }

    public LocationStepImpl(XPathModel xPathModel, int n, StepNodeTest stepNodeTest, XPathPredicateExpression[] xPathPredicateExpressionArray) {
        super(xPathModel);
        assert (n <= int2Axis.length) : "The index of axis " + n + " is out of possible values";
        this.setAxis(int2Axis[n - 1]);
        this.setNodeTest(stepNodeTest);
        this.setPredicates(xPathPredicateExpressionArray);
    }

    public LocationStepImpl(XPathModel xPathModel, XPathAxis xPathAxis, StepNodeTest stepNodeTest, XPathPredicateExpression[] xPathPredicateExpressionArray) {
        super(xPathModel);
        if (xPathAxis == null) {
            xPathAxis = XPathAxis.CHILD;
        }
        this.setAxis(xPathAxis);
        this.setNodeTest(stepNodeTest);
        this.setPredicates(xPathPredicateExpressionArray);
    }

    public XPathAxis getAxis() {
        return this.mAxis;
    }

    public void setAxis(XPathAxis xPathAxis) {
        this.mAxis = xPathAxis;
    }

    public StepNodeTest getNodeTest() {
        return this.mNodeTest;
    }

    public void setNodeTest(StepNodeTest stepNodeTest) {
        this.mNodeTest = stepNodeTest;
    }

    public XPathPredicateExpression[] getPredicates() {
        return this.mPredicates;
    }

    public void setPredicates(XPathPredicateExpression[] xPathPredicateExpressionArray) {
        this.mPredicates = xPathPredicateExpressionArray;
    }

    public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        StepNodeTest stepNodeTest = this.getNodeTest();
        if (stepNodeTest instanceof StepNodeNameTest) {
            stringBuilder.append(this.getAxis().getShortForm());
            StepNodeNameTest stepNodeNameTest = (StepNodeNameTest)stepNodeTest;
            if (stepNodeNameTest.isWildcard()) {
                stringBuilder.append("*");
            } else {
                QName qName = ((StepNodeNameTest)stepNodeTest).getNodeName();
                stringBuilder.append(XPathUtils.qNameObjectToString(qName));
            }
        } else if (stepNodeTest instanceof StepNodeTypeTest) {
            StepNodeTypeTest stepNodeTypeTest = (StepNodeTypeTest)stepNodeTest;
            block0 : switch (stepNodeTypeTest.getNodeType()) {
                case NODETYPE_NODE: {
                    switch (this.getAxis()) {
                        case CHILD: {
                            stringBuilder.append(stepNodeTypeTest.getXPathText());
                            break block0;
                        }
                        case SELF: {
                            stringBuilder.append(".");
                            break block0;
                        }
                        case PARENT: {
                            stringBuilder.append("..");
                            break block0;
                        }
                        case DESCENDANT_OR_SELF: {
                            break block0;
                        }
                    }
                    break;
                }
                case NODETYPE_COMMENT: 
                case NODETYPE_PI: 
                case NODETYPE_TEXT: {
                    stringBuilder.append(stepNodeTypeTest.getXPathText());
                }
            }
        }
        return stringBuilder.toString();
    }

    public void accept(XPathVisitor xPathVisitor) {
        xPathVisitor.visit(this);
    }

    public XPathSchemaContext getSchemaContext() {
        if (this.mSchemaContext == null) {
            if (this.myModel.getRootExpression() != null) {
                this.myModel.resolveExtReferences(false);
            } else {
                this.myModel.resolveExpressionExtReferences(this);
            }
        }
        return this.mSchemaContext;
    }

    public void setSchemaContext(XPathSchemaContext xPathSchemaContext) {
        this.mSchemaContext = xPathSchemaContext;
    }

    public String toString() {
        return this.getString();
    }

    public boolean equals(Object object) {
        if (object instanceof LocationStep) {
            LocationStep locationStep = (LocationStep)object;
            StepNodeTest stepNodeTest = locationStep.getNodeTest();
            if (!stepNodeTest.equals(this.mNodeTest)) {
                return false;
            }
            if (locationStep.getAxis() != this.mAxis) {
                return false;
            }
            XPathPredicateExpression[] xPathPredicateExpressionArray = locationStep.getPredicates();
            return XPathUtils.samePredicatesArr(this.mPredicates, xPathPredicateExpressionArray);
        }
        return false;
    }
}

