/*
 * Decompiled with CFR 0.152.
 */
package net.java.bd.tools.security;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import net.java.bd.tools.security.CertificateVerifier;
import net.java.bd.tools.security.X509BDJEntryConverter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x509.X509NameEntryConverter;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import sun.misc.BASE64Decoder;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.tools.JarSigner;
import sun.security.tools.KeyTool;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.tools.jar.Main;

public class SecurityUtil {
    static final String DEF_KEYSTORE_FILE = "keystore.store";
    static final String DEF_KEYSTORE_PASSWORD = "keystorepassword";
    static final String DEF_APPKEY_PASSWORD = "appcertpassword";
    static final String DEF_APPCERT_ALIAS = "appcert";
    static final String DEF_ROOTKEY_PASSWORD = "rootcertpassword";
    static final String DEF_ROOTCERT_ALIAS = "rootcert";
    static final String DEF_APP_ALT_NAME = "app@producer.com";
    static final String DEF_ROOT_ALT_NAME = "root@studio.com";
    static final String DEF_APP_CERT_DN = "CN=Producer, OU=Codesigning Department, O=BDJCompany, C=US";
    static final String DEF_ROOT_CERT_DN = "CN=Studio, OU=Codesigning Department, O=BDJCompany, C=US";
    static final String SIG_ALG = "SHA1WithRSA";
    static final String APPCSRFILE = "appcert.csr";
    static final String APPCERTFILE = "appcert.cer";
    String keystoreFile;
    String keystorePassword;
    String appKeyPassword;
    String jarSignerAlias;
    String certSignerAlias;
    String newCertAlias;
    List<String> jarfiles;
    String orgId;
    String dn;
    String altName;
    String BUMFile;
    boolean isRootCert = false;
    boolean isAppCert = false;
    boolean isBindingUnitCert = false;
    boolean debug = false;
    String rootKeyPassword = "rootcertpassword";
    private KeyStore store;
    private BigInteger appCertSerNo;
    private boolean ksInitialized = false;

    private SecurityUtil(Builder b) throws Exception {
        this.orgId = b.orgId;
        this.keystoreFile = b.keystoreFile;
        this.keystorePassword = b.keystorePassword;
        this.appKeyPassword = b.appKeyPassword;
        this.newCertAlias = b.newCertAlias;
        this.jarSignerAlias = b.jarSignerAlias;
        this.certSignerAlias = b.certSignerAlias;
        this.dn = b.dn;
        this.altName = b.altName;
        this.debug = b.debug;
        this.isAppCert = b.isAppCert;
        this.isRootCert = b.isRootCert;
        this.isBindingUnitCert = b.isBindingUnitCert;
        this.BUMFile = b.BUMFile;
        this.jarfiles = b.jarfiles;
        this.dn = this.appendOrgId(this.dn);
    }

    private String appendOrgId(String dn) throws InvalidNameException {
        if (dn == null) {
            return null;
        }
        LdapName name = new LdapName(dn);
        List<Rdn> rdns = name.getRdns();
        ArrayList<Rdn> newRdns = new ArrayList<Rdn>();
        for (Rdn rdn : rdns) {
            String type = rdn.getType();
            if (type.equalsIgnoreCase("O")) {
                String value = (String)rdn.getValue();
                String newValue = value + "." + this.orgId;
                newRdns.add(new Rdn(type, newValue));
                continue;
            }
            newRdns.add(rdn);
        }
        return new LdapName(newRdns).toString();
    }

    public void signJars() {
        try {
            this.initKeyStore();
            this.signJarFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void createCerts() throws Exception {
        if (this.isAppCert) {
            this.createAppCert();
        } else {
            this.createRootCert();
        }
    }

    public void createRootCert() throws Exception {
        boolean failed = false;
        this.cleanup();
        try {
            this.initKeyStore();
            this.generateSelfSignedCertificate(this.dn, this.newCertAlias, this.rootKeyPassword, true);
            this.exportRootCertificate();
        }
        catch (Exception e) {
            e.printStackTrace();
            failed = true;
        }
        if (failed) {
            System.exit(1);
        }
    }

    public void createAppCert() throws Exception {
        boolean failed = false;
        try {
            this.initKeyStore();
            this.generateSelfSignedCertificate(this.dn, this.newCertAlias, this.appKeyPassword, false);
            this.generateCSR();
            this.generateCSRResponse();
            this.importCSRResponse();
            if (this.debug) {
                this.verifyCertificates();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            failed = true;
        }
        if (!this.debug) {
            new File(APPCSRFILE).delete();
            new File(APPCERTFILE).delete();
        }
        if (failed) {
            System.exit(1);
        }
    }

    private void initKeyStore() throws Exception {
        if (this.ksInitialized) {
            return;
        }
        this.ksInitialized = true;
        Security.addProvider((Provider)new BouncyCastleProvider());
        char[] password = this.keystorePassword.toCharArray();
        this.store = KeyStore.getInstance(KeyStore.getDefaultType());
        File kfile = new File(this.keystoreFile);
        if (!kfile.exists()) {
            this.store.load(null, password);
            FileOutputStream fout = new FileOutputStream(kfile);
            this.store.store(fout, password);
            fout.close();
        }
        URL url = new URL("file:" + kfile.getCanonicalPath());
        InputStream is = url.openStream();
        this.store.load(is, password);
        is.close();
    }

    private void generateCSR() throws Exception {
        String[] appCSRRequestArgs = new String[]{"-certreq", "-alias", this.newCertAlias, "-keypass", this.appKeyPassword, "-keystore", this.keystoreFile, "-storepass", this.keystorePassword, "-v", "-file", APPCSRFILE};
        KeyTool.main((String[])appCSRRequestArgs);
    }

    private void generateCSRResponse() throws Exception {
        this.issueCert(APPCSRFILE, APPCERTFILE, this.certSignerAlias, this.rootKeyPassword);
    }

    private void importCSRResponse() throws Exception {
        String[] responseImportArgs = new String[]{"-import", "-v", "-alias", this.newCertAlias, "-keypass", this.appKeyPassword, "-keystore", this.keystoreFile, "-storepass", this.keystorePassword, "-v", "-file", APPCERTFILE};
        KeyTool.main((String[])responseImportArgs);
    }

    private void signJarFile() throws Exception {
        for (String jfile : this.jarfiles) {
            String[] jarSigningArgs = new String[]{"-sigFile", "SIG-BD00", "-keypass", this.appKeyPassword, "-keystore", this.keystoreFile, "-storepass", this.keystorePassword, "-verbose", jfile, this.jarSignerAlias};
            JarSigner.main((String[])jarSigningArgs);
            this.signWithBDJHeader(jfile);
        }
    }

    public void signBUMF() throws Exception {
        try {
            this.initKeyStore();
            Signature signer = Signature.getInstance(SIG_ALG);
            if (this.debug) {
                System.out.println("Signer of bumf.xml file is:" + this.jarSignerAlias);
            }
            PrivateKey key = (PrivateKey)this.store.getKey(this.jarSignerAlias, this.rootKeyPassword.toCharArray());
            signer.initSign(key);
            byte[] data = this.readIntoBuffer(this.BUMFile);
            signer.update(data);
            byte[] signedData = signer.sign();
            DerOutputStream dos = new DerOutputStream();
            dos.putBitString(signedData);
            String prefix = "tmp";
            int extIndex = this.BUMFile.lastIndexOf(".");
            if (extIndex != -1) {
                prefix = this.BUMFile.substring(0, extIndex);
            }
            String sigFile = prefix + ".sf";
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(sigFile));
            dos.derEncode(bos);
            bos.close();
            dos.close();
            if (this.debug) {
                this.verifySignatureFile(sigFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void verifySignatureFile(String sigFile) throws Exception {
        Signature verifier = Signature.getInstance(SIG_ALG);
        if (this.debug) {
            System.out.println("Verifier of bumf.xml file is:" + this.jarSignerAlias);
        }
        Certificate cert = this.store.getCertificate(this.jarSignerAlias);
        verifier.initVerify(cert);
        byte[] derData = this.readIntoBuffer(sigFile);
        DerInputStream din = new DerInputStream(derData);
        byte[] signature = din.getBitString();
        byte[] data = this.readIntoBuffer(this.BUMFile);
        verifier.update(data);
        if (verifier.verify(signature)) {
            System.out.println("BUSF Verification PASSED..");
            System.out.println("The signed file is written into:" + sigFile);
        } else {
            System.out.println("BUSF Verification FAILED..");
        }
    }

    private byte[] readIntoBuffer(String filename) throws Exception {
        int read;
        FileInputStream fis = new FileInputStream(filename);
        int INITIAL_BUF_SIZE = 3000;
        byte[] buf = new byte[INITIAL_BUF_SIZE];
        int off = 0;
        int len = buf.length;
        int size = buf.length;
        while ((read = fis.read(buf, off, len)) != -1) {
            if ((off += read) >= size) {
                buf = Arrays.copyOf(buf, size *= 2);
            }
            len = size - off;
        }
        fis.close();
        return Arrays.copyOfRange(buf, 0, off);
    }

    private void signWithBDJHeader(String jarFile) throws Exception {
        File mif;
        String line;
        JarEntry sigBFile;
        JarFile jf;
        JarEntry sigFile;
        String SIG_FILE = "META-INF/SIG-BD00.SF";
        String SIG_BLOCK_FILE = "META-INF/SIG-BD00.RSA";
        if (this.debug) {
            System.out.println("Adding BD header to:" + jarFile);
        }
        if ((sigFile = (jf = new JarFile(jarFile)).getJarEntry(SIG_FILE)) == null) {
            System.out.println("No entry found:" + SIG_FILE);
        }
        if ((sigBFile = jf.getJarEntry(SIG_BLOCK_FILE)) == null) {
            System.out.println("No entry found:" + SIG_BLOCK_FILE);
        }
        InputStream pkcs7Is = jf.getInputStream(sigBFile);
        PKCS7 signBlock = new PKCS7(pkcs7Is);
        pkcs7Is.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(jf.getInputStream(sigFile)));
        StringWriter sw = new StringWriter();
        boolean addBDLine = false;
        while ((line = br.readLine()) != null) {
            if (addBDLine) {
                if (line.startsWith("BDJ-Signature_Version")) {
                    br.close();
                    jf.close();
                    return;
                }
                sw.write("BDJ-Signature-Version: 1.0\n");
                addBDLine = false;
            }
            if (!line.startsWith("SHA1-Digest-Manifest-Main-Attributes:")) {
                sw.write(line);
                sw.write("\n");
            }
            if (!line.startsWith("Created-By:")) continue;
            addBDLine = true;
        }
        br.close();
        jf.close();
        Signature signer = Signature.getInstance(SIG_ALG);
        PrivateKey key = (PrivateKey)this.store.getKey(this.jarSignerAlias, this.appKeyPassword.toCharArray());
        signer.initSign(key);
        byte[] newContent = sw.toString().getBytes();
        signer.update(newContent);
        byte[] signedContent = signer.sign();
        ContentInfo newContentInfo = new ContentInfo(ContentInfo.DATA_OID, null);
        SignerInfo[] signerInfos = signBlock.getSignerInfos();
        Certificate signerCert = this.store.getCertificate(this.jarSignerAlias);
        SignerInfo newSignerInfo = null;
        for (int i = 0; i < signerInfos.length; ++i) {
            SignerInfo si = signerInfos[i];
            if (!signerCert.equals(si.getCertificate(signBlock))) continue;
            signerInfos[i] = newSignerInfo = new SignerInfo(si.getIssuerName(), si.getCertificateSerialNumber(), si.getDigestAlgorithmId(), si.getDigestEncryptionAlgorithmId(), signedContent);
        }
        PKCS7 newSignBlock = new PKCS7(signBlock.getDigestAlgorithmIds(), newContentInfo, signBlock.getCertificates(), signerInfos);
        if (this.debug) {
            System.out.println("Signer Info Verified:" + newSignBlock.verify(newSignerInfo, newContent).toString());
        }
        if (!(mif = new File("META-INF")).isDirectory() && !mif.mkdir()) {
            System.err.println("Could not create a META-INF directory");
            return;
        }
        File sf = new File(SIG_FILE);
        FileOutputStream fout = new FileOutputStream(sf);
        fout.write(newContent);
        fout.close();
        File sbf = new File(SIG_BLOCK_FILE);
        FileOutputStream fos = new FileOutputStream(sbf);
        newSignBlock.encodeSignedData(fos);
        fos.close();
        String[] jarArgs = new String[]{"-uvf", jarFile, SIG_FILE, SIG_BLOCK_FILE};
        Main jar = new Main(System.out, System.err, "jar");
        jar.run(jarArgs);
    }

    private void exportRootCertificate() throws Exception {
        String exportFileName = "app.discroot.crt";
        if (this.isBindingUnitCert) {
            exportFileName = "bu.discroot.crt";
        }
        String[] exportRootCertificateArgs = new String[]{"-export", "-alias", this.newCertAlias, "-keypass", this.rootKeyPassword, "-keystore", this.keystoreFile, "-storepass", this.keystorePassword, "-v", "-file", exportFileName};
        KeyTool.main((String[])exportRootCertificateArgs);
    }

    private void verifyCertificates() {
        File appCert = new File(APPCERTFILE);
        File rootCert = new File("app.discroot.crt");
        boolean check = new CertificateVerifier().runTest(appCert, rootCert);
        if (!check) {
            throw new RuntimeException("Problem with the certification generation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() throws IOException {
        File keystore = new File(this.keystoreFile);
        if (keystore.exists()) {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                fis = new FileInputStream(keystore);
                ks.load(fis, this.keystorePassword.toCharArray());
                fos = new FileOutputStream(keystore);
                if (ks.containsAlias(this.newCertAlias)) {
                    ks.deleteEntry(this.newCertAlias);
                }
                ks.store(fos, this.keystorePassword.toCharArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
        new File(APPCSRFILE).delete();
        new File(APPCERTFILE).delete();
    }

    private void generateSelfSignedCertificate(String issuer, String alias, String keyPassword, boolean isRootCert) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1949, 1, 1);
        Date validFrom = calendar.getTime();
        calendar.clear();
        calendar.set(2055, 1, 1);
        Date validTo = calendar.getTime();
        KeyPair keyPair = this.generateKeyPair();
        X509V3CertificateGenerator cg = new X509V3CertificateGenerator();
        cg.reset();
        X509Name name = new X509Name(issuer, (X509NameEntryConverter)new X509BDJEntryConverter());
        SecureRandom prng = SecureRandom.getInstance("SHA1PRNG");
        BigInteger serNo = new BigInteger(32, prng);
        cg.setSerialNumber(serNo);
        if (!isRootCert) {
            this.appCertSerNo = serNo;
        }
        cg.setIssuerDN(name);
        cg.setNotBefore(validFrom);
        cg.setNotAfter(validTo);
        cg.setSubjectDN(name);
        cg.setPublicKey(keyPair.getPublic());
        cg.setSignatureAlgorithm("SHA1WITHRSA");
        if (isRootCert) {
            if (this.isBindingUnitCert) {
                cg.addExtension(X509Extensions.KeyUsage.getId(), true, (DEREncodable)new X509KeyUsage(128));
            } else {
                cg.addExtension(X509Extensions.KeyUsage.getId(), true, (DEREncodable)new X509KeyUsage(4));
            }
            cg.addExtension(X509Extensions.IssuerAlternativeName.getId(), false, (DEREncodable)this.getRfc822Name(this.altName));
            cg.addExtension(X509Extensions.BasicConstraints.getId(), true, (DEREncodable)new BasicConstraints(true));
        }
        cg.addExtension(X509Extensions.SubjectAlternativeName.getId(), false, (DEREncodable)this.getRfc822Name(this.altName));
        X509Certificate cert = cg.generate(keyPair.getPrivate());
        this.store.setKeyEntry(alias, keyPair.getPrivate(), keyPassword.toCharArray(), new Certificate[]{cert});
        FileOutputStream fos = new FileOutputStream(this.keystoreFile);
        this.store.store(fos, this.keystorePassword.toCharArray());
        fos.close();
    }

    private KeyPair generateKeyPair() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        keyGen.initialize(1024, random);
        KeyPair keyPair = keyGen.generateKeyPair();
        return keyPair;
    }

    void issueCert(String csrfile, String certfile, String alias, String keypass) throws Exception {
        PKCS10CertificationRequest csr = new PKCS10CertificationRequest(SecurityUtil.convertFromBASE64(csrfile));
        String subject = csr.getCertificationRequestInfo().getSubject().toString();
        X509V3CertificateGenerator cg = new X509V3CertificateGenerator();
        cg.reset();
        X509Certificate rootCert = (X509Certificate)this.store.getCertificate(alias);
        cg.setIssuerDN(new X509Name(true, rootCert.getSubjectDN().getName(), (X509NameEntryConverter)new X509BDJEntryConverter()));
        cg.setSubjectDN(new X509Name(subject, (X509NameEntryConverter)new X509BDJEntryConverter()));
        cg.setNotBefore(rootCert.getNotBefore());
        cg.setNotAfter(rootCert.getNotAfter());
        cg.setPublicKey(csr.getPublicKey());
        cg.setSerialNumber(this.appCertSerNo);
        cg.setSignatureAlgorithm("SHA1WITHRSA");
        cg.addExtension(X509Extensions.KeyUsage.getId(), true, (DEREncodable)new X509KeyUsage(128));
        cg.addExtension(X509Extensions.SubjectAlternativeName.getId(), false, (DEREncodable)this.getRfc822Name(this.altName));
        List<?> issuerName = rootCert.getIssuerAlternativeNames().iterator().next();
        cg.addExtension(X509Extensions.IssuerAlternativeName.getId(), false, (DEREncodable)this.getRfc822Name((String)issuerName.get(1)));
        PrivateKey privateKey = (PrivateKey)this.store.getKey(alias, keypass.toCharArray());
        X509Certificate cert = cg.generate(privateKey);
        System.out.println("Writing cert to " + certfile + ".");
        FileOutputStream str = new FileOutputStream(certfile);
        str.write(cert.getEncoded());
        str.close();
    }

    GeneralNames getRfc822Name(String name) {
        GeneralName gn = new GeneralName(1, (ASN1Encodable)new DERIA5String(name));
        DERConstructedSequence seq = new DERConstructedSequence();
        seq.addObject((DEREncodable)gn);
        return new GeneralNames((ASN1Sequence)seq);
    }

    static byte[] convertFromBASE64(String file) throws IOException {
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        line = reader.readLine();
        if (!line.equals("-----BEGIN NEW CERTIFICATE REQUEST-----")) {
            throw new IOException("not a valid CSR file");
        }
        boolean seenLastLine = false;
        while ((line = reader.readLine()) != null) {
            if (line.equals("-----END NEW CERTIFICATE REQUEST-----")) {
                seenLastLine = true;
                break;
            }
            buf.append(line);
            buf.append('\n');
        }
        if (!seenLastLine) {
            throw new IOException("not a valid CSR file");
        }
        BASE64Decoder decoder = new BASE64Decoder();
        return decoder.decodeBuffer(buf.toString());
    }

    public static class Builder {
        String keystoreFile = "keystore.store";
        String keystorePassword = "keystorepassword";
        String appKeyPassword = "appcertpassword";
        String jarSignerAlias;
        String certSignerAlias = "rootcert";
        String newCertAlias;
        String dn;
        String altName;
        List<String> jarfiles;
        String orgId;
        boolean debug = false;
        boolean isRootCert = false;
        boolean isAppCert = false;
        boolean isBindingUnitCert = false;
        String BUMFile;

        public Builder orgId(String id) {
            this.orgId = id;
            return this;
        }

        public Builder keystoreFile(String file) {
            this.keystoreFile = file;
            return this;
        }

        public Builder storepass(String password) {
            this.keystorePassword = password;
            return this;
        }

        public Builder setRootCert() {
            this.isRootCert = true;
            this.setRootDefaults();
            return this;
        }

        private void setRootDefaults() {
            if (this.dn == null) {
                this.dn = SecurityUtil.DEF_ROOT_CERT_DN;
            }
            if (this.altName == null) {
                this.altName = SecurityUtil.DEF_ROOT_ALT_NAME;
            }
            if (this.newCertAlias == null) {
                this.newCertAlias = SecurityUtil.DEF_ROOTCERT_ALIAS;
            }
        }

        public Builder setAppCert() {
            this.isAppCert = true;
            if (this.dn == null) {
                this.dn = SecurityUtil.DEF_APP_CERT_DN;
            }
            if (this.altName == null) {
                this.altName = SecurityUtil.DEF_APP_ALT_NAME;
            }
            if (this.newCertAlias == null) {
                this.newCertAlias = SecurityUtil.DEF_APPCERT_ALIAS;
            }
            return this;
        }

        public Builder setBindingUnitCert() {
            this.isBindingUnitCert = true;
            this.setRootDefaults();
            return this;
        }

        public Builder newCertAlias(String alias) {
            this.newCertAlias = alias;
            return this;
        }

        public Builder certSignerAlias(String alias) {
            this.certSignerAlias = alias;
            return this;
        }

        public Builder jarSignerAlias(String alias) {
            this.jarSignerAlias = alias;
            return this;
        }

        public Builder appPassword(String password) {
            this.appKeyPassword = password;
            return this;
        }

        public Builder dn(String name) {
            this.dn = name;
            return this;
        }

        public Builder altName(String name) {
            this.altName = name;
            return this;
        }

        public Builder debug() {
            this.debug = true;
            return this;
        }

        public Builder bumf(String file) {
            this.BUMFile = file;
            if (this.jarSignerAlias == null) {
                this.jarSignerAlias = SecurityUtil.DEF_ROOTCERT_ALIAS;
            }
            return this;
        }

        public Builder jarfiles(List<String> files) {
            this.jarfiles = files;
            if (this.jarSignerAlias == null) {
                this.jarSignerAlias = SecurityUtil.DEF_APPCERT_ALIAS;
            }
            return this;
        }

        public SecurityUtil build() throws Exception {
            return new SecurityUtil(this);
        }
    }
}

