/*
 * Decompiled with CFR 0.152.
 */
package net.java.bd.tools.security;

import java.io.File;
import java.util.ArrayList;
import net.java.bd.tools.security.SecurityUtil;

public class BDSigner {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            BDSigner.printUsageAndExit("No arguments specified");
        }
        ArrayList<String> jarfiles = new ArrayList<String>();
        boolean isBUMF = false;
        SecurityUtil.Builder builder = new SecurityUtil.Builder();
        for (int i = 0; i < args.length; ++i) {
            String opt = args[i];
            if (opt.equals("-keystore")) {
                if (++i == args.length) {
                    BDSigner.errorNeedArgument(opt);
                }
                builder = builder.keystoreFile(args[i]);
                continue;
            }
            if (opt.equals("-storepass")) {
                if (++i == args.length) {
                    BDSigner.errorNeedArgument(opt);
                }
                builder = builder.storepass(args[i]);
                continue;
            }
            if (opt.equals("-alias")) {
                if (++i == args.length) {
                    BDSigner.errorNeedArgument(opt);
                }
                builder = builder.jarSignerAlias(args[i]);
                continue;
            }
            if (opt.equals("-keypass")) {
                if (++i == args.length) {
                    BDSigner.errorNeedArgument(opt);
                }
                builder = builder.appPassword(args[i]);
                continue;
            }
            if (opt.equals("-help")) {
                BDSigner.printUsageAndExit("");
                continue;
            }
            if (opt.equals("-debug")) {
                builder = builder.debug();
                continue;
            }
            if (args[i].endsWith("bumf.xml")) {
                builder = builder.bumf(args[i]);
                isBUMF = true;
            } else {
                jarfiles.add(args[i]);
            }
            if (new File(args[i]).exists()) continue;
            BDSigner.printUsageAndExit("File " + args[i] + " not found.");
        }
        if (!isBUMF && jarfiles.isEmpty()) {
            BDSigner.printUsageAndExit("No BUMF or jar files to sign..");
        } else if (!isBUMF) {
            builder = builder.jarfiles(jarfiles);
        }
        SecurityUtil util = builder.build();
        if (isBUMF) {
            util.signBUMF();
        } else {
            util.signJars();
        }
    }

    private static void tinyHelp() {
        System.err.println("Try BDSigner -help");
        System.exit(1);
    }

    private static void errorNeedArgument(String flag) {
        System.err.println("Command option <flag> needs an argument.");
        BDSigner.tinyHelp();
    }

    private static void printUsageAndExit(String reason) {
        if (!reason.isEmpty()) {
            System.err.println("\nFailed: " + reason);
        }
        System.err.println("\n***This is a tool for signing jar files or the Binding Unit Manifest File(BUMF) according to the bd-j specification***\n");
        System.err.println("usage: BDSigner [options] BUMF or jarfiles..\n");
        System.err.println("Valid Options:");
        System.err.println(" -keystore filename  \t:Keystore containing the key used in signing");
        System.err.println("                     \tIn the absense of this option, a default store:\"keystore.store\"");
        System.out.println("                     \tis used from the current working directory.");
        System.err.println(" -storepass password \t:Keystore password");
        System.err.println(" -alias alias        \t:Alias for the signing key");
        System.err.println(" -keypass password   \t:Password for accessing the signing key");
        System.err.println(" -debug              \t:Prints debug messages");
        System.err.println(" -help               \t:Prints this message");
        System.err.println("\nExample: java -cp security.jar:tools.jar:bcprov-jdk15-137.jar net.java.bd.tools.security.BDSigner 00000.jar\n");
        System.exit(1);
    }
}

