/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modeldiscovery.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSource
implements SourceFileProperties {
    private static final boolean TRACE_AMBIGUOUS = Boolean.getBoolean("cnd.modeldiscovery.trace.ambiguous");
    private Item item;
    private CsmFile file;
    private Map<String, List<String>> searchBase;
    private String itemPath;
    private List<String> userIncludePaths;
    private Set<String> includedFiles = new HashSet<String>();
    private static final String PATTERN = "/../";

    public ModelSource(Item item, CsmFile csmFile, Map<String, List<String>> map) {
        this.item = item;
        this.file = csmFile;
        this.searchBase = map;
    }

    public Set<String> getIncludedFiles() {
        if (this.userIncludePaths == null) {
            this.getUserInludePaths();
        }
        return this.includedFiles;
    }

    public String getCompilePath() {
        return new File(this.getItemPath()).getParentFile().getAbsolutePath();
    }

    public String getItemPath() {
        if (this.itemPath == null) {
            this.itemPath = this.item.getAbsPath();
            this.itemPath = this.itemPath.replace('\\', '/');
            this.itemPath = ModelSource.cutLocalRelative(this.itemPath);
            if (Utilities.isWindows()) {
                this.itemPath = this.itemPath.replace('/', File.separatorChar);
            }
        }
        return this.itemPath;
    }

    public static String cutLocalRelative(String string) {
        int n;
        String string2 = PATTERN;
        while ((n = string.indexOf(string2)) >= 0) {
            int n2 = -1;
            for (int i = n - 1; i >= 0; --i) {
                if (string.charAt(i) != '/') continue;
                n2 = i;
                break;
            }
            if (n2 < 0) break;
            string = string.substring(0, n2 + 1) + string.substring(n + string2.length());
        }
        return string;
    }

    public String getItemName() {
        return this.item.getFile().getName();
    }

    public List<String> getUserInludePaths() {
        if (this.userIncludePaths == null) {
            List list = this.item.getUserIncludePaths();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (Object e : list) {
                String string = (String)e;
                string = this.getRelativepath(string);
                linkedHashSet.add(string);
            }
            this.analyzeUnresolved(linkedHashSet, this.file, 0);
            this.userIncludePaths = new ArrayList<String>(linkedHashSet);
        }
        return this.userIncludePaths;
    }

    private String getRelativepath(String string) {
        if (Utilities.isWindows()) {
            string = string.replace('/', File.separatorChar);
        }
        string = IpeUtils.toRelativePath((String)this.getCompilePath(), (String)string);
        string = FilePathAdaptor.mapToRemote((String)string);
        string = FilePathAdaptor.normalize((String)string);
        return string;
    }

    private void analyzeUnresolved(Set<String> set, CsmFile csmFile, int n) {
        if (csmFile == null) {
            return;
        }
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            CsmFile csmFile2 = csmInclude.getIncludeFile();
            if (csmFile2 == null) {
                String string = this.guessPath(csmInclude);
                if (string == null) continue;
                csmFile2 = this.file.getProject().findFile((Object)(string + File.separatorChar + csmInclude.getIncludeName()));
                string = this.getRelativepath(string);
                set.add(string);
                if (n >= 5 || csmFile2 == null) continue;
                this.analyzeUnresolved(set, csmFile2, n + 1);
                continue;
            }
            this.includedFiles.add(((Object)csmFile2.getAbsolutePath()).toString());
            if (n >= 5) continue;
            this.analyzeUnresolved(set, csmFile2, n + 1);
        }
    }

    private String guessPath(CsmInclude csmInclude) {
        int n;
        List<String> list;
        String string = ((Object)csmInclude.getIncludeName()).toString();
        String string2 = string.replace('\\', '/');
        String string3 = null;
        String string4 = null;
        int n2 = string2.lastIndexOf(47);
        if (n2 >= 0) {
            string3 = string2.substring(0, n2 + 1);
            string2 = string2.substring(n2 + 1);
            n2 = string3.lastIndexOf("./");
            if (n2 >= 0) {
                string4 = string3.substring(0, n2 + 2);
                if ((string3 = string3.substring(n2 + 2)).length() == 0) {
                    string3 = null;
                    string = string2;
                } else {
                    string = string3 + '/' + string2;
                }
            }
        }
        if ((list = this.searchBase.get(string2)) != null && list.size() > 0) {
            n = -1;
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).endsWith(string)) continue;
                if (n >= 0) {
                    if (!TRACE_AMBIGUOUS) continue;
                    System.out.println("Ambiguous name for item: " + this.getItemPath());
                    System.out.println("  name1: " + list.get(n));
                    System.out.println("  name2: " + list.get(i));
                    continue;
                }
                n = i;
            }
            if (n >= 0) {
                String string5 = list.get(n);
                string5 = string5.substring(0, string5.length() - string.length() - 1);
                return string5;
            }
        }
        if (TRACE_AMBIGUOUS) {
            System.out.println("Unresolved name for item: " + this.getItemPath());
            System.out.println("  from: " + csmInclude.getContainingFile().getAbsolutePath());
            System.out.println("  name: " + csmInclude.getIncludeName());
            if (list != null && list.size() > 0) {
                for (n = 0; n < list.size(); ++n) {
                    System.out.println("  candidate: " + list.get(n));
                }
            }
        }
        return null;
    }

    public List<String> getSystemInludePaths() {
        List list = this.item.getSystemIncludePaths();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : list) {
            String string = (String)e;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Map<String, String> getUserMacros() {
        List list = this.item.getUserMacroDefinitions();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object e : list) {
            String string = (String)e;
            int n = string.indexOf(61);
            if (n > 0) {
                hashMap.put(string.substring(0, n).trim(), string.substring(n + 1).trim());
                continue;
            }
            hashMap.put(string, null);
        }
        return hashMap;
    }

    public Map<String, String> getSystemMacros() {
        return null;
    }

    public ItemProperties.LanguageKind getLanguageKind() {
        if (this.item.getLanguage() == NativeFileItem.Language.C) {
            return ItemProperties.LanguageKind.C;
        }
        if (this.item.getLanguage() == NativeFileItem.Language.CPP) {
            return ItemProperties.LanguageKind.CPP;
        }
        return ItemProperties.LanguageKind.Unknown;
    }
}

