/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.watch;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.variables.NamedValueHost;
import org.netbeans.modules.bpel.debugger.api.variables.Value;
import org.netbeans.modules.bpel.debugger.api.variables.XmlElementValue;
import org.netbeans.modules.bpel.debugger.ui.watch.BpelWatch;
import org.netbeans.modules.bpel.debugger.ui.watch.Util;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Node;

public class WatchesTreeModel
implements TreeModel,
Constants {
    private ContextProvider myContextProvider;
    private BpelDebugger myDebugger;
    private Util myHelper;
    private Listener myListener;
    private Vector myListeners = new Vector();
    private Map<Watch, BpelWatch> myWatchToValue = new WeakHashMap<Watch, BpelWatch>();

    public WatchesTreeModel(ContextProvider contextProvider) {
        this.myContextProvider = contextProvider;
        this.myDebugger = (BpelDebugger)contextProvider.lookupFirst(null, BpelDebugger.class);
        this.myHelper = new Util(this.myDebugger);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object.equals("Root")) {
            return this.getWatches(n, n2);
        }
        if (object instanceof BpelWatch) {
            BpelWatch bpelWatch = (BpelWatch)object;
            Value value = bpelWatch.getValue();
            if (bpelWatch.getValue() != null) {
                if (value instanceof XmlElementValue) {
                    return this.myHelper.getChildren((XmlElementValue)value);
                }
                return new Object[0];
            }
            String string = bpelWatch.getExpression();
            if (!string.startsWith("$")) {
                string = "$" + string;
            }
            return this.myHelper.getChildren(string);
        }
        if (object instanceof NamedValueHost) {
            return this.myHelper.getVariablesUtil().getChildren(object);
        }
        if (object instanceof Node) {
            return this.myHelper.getVariablesUtil().getChildren(object);
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            if (this.myListener == null) {
                this.myListener = new Listener(this, this.myDebugger);
            }
            return this.getWatchCount();
        }
        if (object instanceof BpelWatch) {
            BpelWatch bpelWatch = (BpelWatch)object;
            Value value = bpelWatch.getValue();
            if (bpelWatch.getValue() != null) {
                if (value instanceof XmlElementValue) {
                    return this.myHelper.getChildren((XmlElementValue)value).length;
                }
                return 0;
            }
            String string = bpelWatch.getExpression();
            if (!string.startsWith("$")) {
                string = "$" + string;
            }
            return this.myHelper.getChildren(string).length;
        }
        if (object instanceof NamedValueHost) {
            return this.myHelper.getVariablesUtil().getChildren(object).length;
        }
        if (object instanceof Node) {
            return this.myHelper.getVariablesUtil().getChildren(object).length;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        return this.getChildrenCount(object) == 0;
    }

    public void addModelListener(ModelListener modelListener) {
        this.myListeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.myListeners.remove(modelListener);
    }

    private Object[] getWatches(int n, int n2) {
        Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
        Object[] objectArray = new BpelWatch[n2 - n];
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            BpelWatch bpelWatch = this.myWatchToValue.get(watchArray[i]);
            if (bpelWatch == null) {
                bpelWatch = new BpelWatch(this.myDebugger, watchArray[i]);
                this.myWatchToValue.put(watchArray[i], bpelWatch);
            }
            objectArray[n3++] = bpelWatch;
        }
        if (this.myListener == null) {
            this.myListener = new Listener(this, this.myDebugger);
        }
        return objectArray;
    }

    private int getWatchCount() {
        return DebuggerManager.getDebuggerManager().getWatches().length;
    }

    private void fireWatchesChanged() {
        Vector vector = (Vector)this.myListeners.clone();
        ModelEvent.NodeChanged nodeChanged = new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8);
        for (int i = 0; i < vector.size(); ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)nodeChanged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeChanged() {
        Object object = this.myWatchToValue;
        synchronized (object) {
            this.myWatchToValue.clear();
        }
        object = (Vector)this.myListeners.clone();
        ModelEvent.TreeChanged treeChanged = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            ((ModelListener)((Vector)object).get(i)).modelChanged((ModelEvent)treeChanged);
        }
    }

    void fireTableValueChangedChanged(Object object, String string) {
        this.fireTreeChanged();
    }

    void fireTableValueChangedComputed(Object object, String string) {
        Vector vector = (Vector)this.myListeners.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, object, string));
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference myDebugger;
        private WeakReference myModel;
        private RequestProcessor.Task task;

        private Listener(WatchesTreeModel watchesTreeModel, BpelDebugger bpelDebugger) {
            this.myModel = new WeakReference<WatchesTreeModel>(watchesTreeModel);
            this.myDebugger = new WeakReference<BpelDebugger>(bpelDebugger);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            bpelDebugger.addPropertyChangeListener((PropertyChangeListener)this);
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            for (int i = 0; i < watchArray.length; ++i) {
                watchArray[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private WatchesTreeModel getModel() {
            WatchesTreeModel watchesTreeModel = (WatchesTreeModel)this.myModel.get();
            if (watchesTreeModel == null) {
                this.destroy();
            }
            return watchesTreeModel;
        }

        public void watchAdded(Watch watch) {
            WatchesTreeModel watchesTreeModel = this.getModel();
            if (watchesTreeModel == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            watchesTreeModel.fireWatchesChanged();
        }

        public void watchRemoved(Watch watch) {
            WatchesTreeModel watchesTreeModel = this.getModel();
            if (watchesTreeModel == null) {
                return;
            }
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            watchesTreeModel.fireWatchesChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            WatchesTreeModel watchesTreeModel;
            String string = propertyChangeEvent.getPropertyName();
            if ("watches".equals(string)) {
                return;
            }
            WatchesTreeModel watchesTreeModel2 = this.getModel();
            if (watchesTreeModel2 == null) {
                return;
            }
            if (watchesTreeModel2.myDebugger.getState() == 4) {
                this.destroy();
                return;
            }
            if (propertyChangeEvent.getSource() instanceof Watch) {
                Map map = watchesTreeModel2.myWatchToValue;
                synchronized (map) {
                    watchesTreeModel = watchesTreeModel2.myWatchToValue.get(propertyChangeEvent.getSource());
                }
                if (watchesTreeModel != null) {
                    watchesTreeModel2.fireTableValueChangedChanged(watchesTreeModel, null);
                    return;
                }
            }
            if ("currentPosition".equals(string)) {
                watchesTreeModel = this.getModel();
                if (watchesTreeModel == null) {
                    return;
                }
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
                this.task = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        watchesTreeModel.fireTreeChanged();
                    }
                }, 500);
            }
        }

        void destroy() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
            BpelDebugger bpelDebugger = (BpelDebugger)this.myDebugger.get();
            if (bpelDebugger != null) {
                bpelDebugger.removePropertyChangeListener((PropertyChangeListener)this);
            }
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            for (int i = 0; i < watchArray.length; ++i) {
                watchArray[i].removePropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }
}

