/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.threads;

import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.Position;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.pem.ProcessExecutionModel;
import org.netbeans.modules.bpel.debugger.ui.threads.ThreadsTreeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class ThreadsNodeModel
implements NodeModel,
Constants {
    private BpelDebugger myDebugger;
    public static final String ICONS_ROOT = "org/netbeans/modules/bpel/debugger/ui/resources/image/threads/";
    public static final String ACTIVE_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/threads/active";
    public static final String CURRENT_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/threads/current";
    public static final String COMPLETED_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/threads/completed";

    public ThreadsNodeModel(ContextProvider contextProvider) {
        this.myDebugger = (BpelDebugger)contextProvider.lookupFirst(null, BpelDebugger.class);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getMessage(ThreadsNodeModel.class, (String)"CTL_Column_Name");
        }
        if (object instanceof ThreadsTreeModel.Dummy) {
            return NbBundle.getMessage(ThreadsNodeModel.class, (String)"CTL_Empty_Model");
        }
        if (object instanceof ProcessExecutionModel.Branch) {
            return ((ProcessExecutionModel.Branch)object).getId();
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getMessage(ThreadsNodeModel.class, (String)"CTL_Column_Name_Tooltip");
        }
        return this.getDisplayName(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return "";
        }
        if (object instanceof ThreadsTreeModel.Dummy) {
            return null;
        }
        if (object instanceof ProcessExecutionModel.Branch) {
            ProcessExecutionModel.Branch branch;
            ProcessInstance processInstance = this.myDebugger.getCurrentProcessInstance();
            Position position = this.myDebugger.getCurrentPosition();
            if (processInstance != null && position != null && ((ProcessExecutionModel.Branch)object).equals(branch = processInstance.getProcessExecutionModel().getCurrentBranch())) {
                return CURRENT_ICON;
            }
            if (((ProcessExecutionModel.Branch)object).getState() == ProcessExecutionModel.Branch.State.ACTIVE) {
                return ACTIVE_ICON;
            }
            if (((ProcessExecutionModel.Branch)object).getState() == ProcessExecutionModel.Branch.State.COMPLETED) {
                return COMPLETED_ICON;
            }
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }
}

