/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.threads;

import javax.swing.Action;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.Position;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.pem.ProcessExecutionModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class ThreadsActionProvider
implements NodeActionsProvider {
    private BpelDebugger myDebugger;
    private final Action MAKE_CURRENT_ACTION = Models.createAction((String)MAKE_CURRENT_ACTION_NAME, (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            if (object instanceof ProcessExecutionModel.Branch) {
                return ThreadsActionProvider.this.canMakeCurrentBranch((ProcessExecutionModel.Branch)object);
            }
            return false;
        }

        public void perform(Object[] objectArray) {
            if (objectArray[0] instanceof ProcessExecutionModel.Branch) {
                ThreadsActionProvider.this.makeCurrentBranch((ProcessExecutionModel.Branch)objectArray[0]);
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final String MAKE_CURRENT_ACTION_NAME = NbBundle.getMessage(ThreadsActionProvider.class, (String)"CTL_Threads_Action_Make_Current");

    public ThreadsActionProvider(ContextProvider contextProvider) {
        this.myDebugger = (BpelDebugger)contextProvider.lookupFirst(null, BpelDebugger.class);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return;
        }
        if (object instanceof ProcessExecutionModel.Branch) {
            this.makeCurrentBranch((ProcessExecutionModel.Branch)object);
        }
        throw new UnknownTypeException(object);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return new Action[0];
        }
        if (object instanceof ProcessExecutionModel.Branch) {
            return new Action[]{this.MAKE_CURRENT_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    private void makeCurrentBranch(ProcessExecutionModel.Branch branch) {
        ProcessInstance processInstance = this.myDebugger.getCurrentProcessInstance();
        processInstance.getProcessExecutionModel().setCurrentBranch(branch.getId());
    }

    private boolean canMakeCurrentBranch(ProcessExecutionModel.Branch branch) {
        ProcessInstance processInstance = this.myDebugger.getCurrentProcessInstance();
        Position position = this.myDebugger.getCurrentPosition();
        if (branch.getState() == ProcessExecutionModel.Branch.State.COMPLETED) {
            return false;
        }
        if (processInstance == null || position == null) {
            return false;
        }
        ProcessExecutionModel.Branch branch2 = processInstance.getProcessExecutionModel().getCurrentBranch();
        return branch2 == null || !branch2.equals(branch);
    }
}

