/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.source;

import java.awt.Dialog;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.BpelSourcesRegistry;
import org.netbeans.modules.bpel.debugger.api.SessionCookie;
import org.netbeans.modules.bpel.debugger.api.SourcePath;
import org.netbeans.modules.bpel.debugger.spi.SourcePathSelectionProvider;
import org.netbeans.modules.bpel.debugger.ui.source.SeveralSourceFilesWarning;
import org.netbeans.modules.bpel.debugger.ui.util.EditorUtil;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcePathImpl
implements SourcePath {
    private final ContextProvider myLookupProvider;
    private final BpelDebugger myDebugger;
    private final Object myProcessingLock = new Object();
    private final RequestProcessor myRequestProcessor = new RequestProcessor("BpelSourcesLocator");
    private final BpelSourcesRegistry mySourcesRegistry;
    private final PropertyChangeSupport myPcs = new PropertyChangeSupport(this);
    private RequestProcessor.Task myCurrentTask;
    private Set<String> myUpdatedSources = new HashSet<String>();
    private Set<String> myAvailableSources = new TreeSet<String>();
    private Set<String> mySelectedSources = new HashSet<String>();
    private Map<QName, Set<String>> myAvailableSourcesByQName = new HashMap<QName, Set<String>>();
    private Map<String, QName> myQNames = new HashMap<String, QName>();
    private Map<QName, String> mySourceMap = new HashMap<QName, String>();
    private SessionCookie mySessionCookie;
    private SourcePathSelectionProvider mySelectionProvider;

    public SourcePathImpl(ContextProvider contextProvider) {
        this.myLookupProvider = contextProvider;
        this.myDebugger = (BpelDebugger)contextProvider.lookupFirst(null, BpelDebugger.class);
        this.mySourcesRegistry = (BpelSourcesRegistry)Lookup.getDefault().lookup(BpelSourcesRegistry.class);
        this.updateAvailableSources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QName getProcessQName(String string) {
        while (true) {
            RequestProcessor.Task task;
            Object object = this.myProcessingLock;
            synchronized (object) {
                if (this.myCurrentTask == null) {
                    return this.myQNames.get(string);
                }
                task = this.myCurrentTask;
            }
            task.waitFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourcePath(QName qName) {
        while (true) {
            RequestProcessor.Task task;
            Object object = this.myProcessingLock;
            synchronized (object) {
                if (this.myCurrentTask == null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.addAll((Collection)this.myAvailableSourcesByQName.get(qName));
                    hashSet.retainAll(this.mySelectedSources);
                    if (hashSet.isEmpty()) {
                        return null;
                    }
                    if (hashSet.size() == 1) {
                        return (String)hashSet.iterator().next();
                    }
                    return this.selectSource(qName, hashSet);
                }
                task = this.myCurrentTask;
            }
            task.waitFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAvailableSources() {
        while (true) {
            RequestProcessor.Task task;
            Object object = this.myProcessingLock;
            synchronized (object) {
                if (this.myCurrentTask == null) {
                    return this.myAvailableSources.toArray(new String[this.myAvailableSources.size()]);
                }
                task = this.myCurrentTask;
            }
            task.waitFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSelectedSources() {
        while (true) {
            RequestProcessor.Task task;
            Object object = this.myProcessingLock;
            synchronized (object) {
                if (this.myCurrentTask == null) {
                    return this.mySelectedSources.toArray(new String[this.mySelectedSources.size()]);
                }
                task = this.myCurrentTask;
            }
            task.waitFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedSources(String[] stringArray) {
        while (true) {
            RequestProcessor.Task task;
            Object object = this.myProcessingLock;
            synchronized (object) {
                if (this.myCurrentTask == null) {
                    this.mySelectedSources.clear();
                    for (String string : stringArray) {
                        this.mySelectedSources.add(string);
                    }
                    return;
                }
                task = this.myCurrentTask;
            }
            task.waitFinished();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myPcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myPcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAvailableSource(String string) {
        Object object = this.myProcessingLock;
        synchronized (object) {
            this.myUpdatedSources.add(string);
            if (this.myCurrentTask == null) {
                this.myCurrentTask = this.myRequestProcessor.post((Runnable)new MyProcessingRunnable());
            }
        }
    }

    private void updateAvailableSources() {
        String[] stringArray;
        for (String string : stringArray = this.mySourcesRegistry.getSourceRoots()) {
            this.addAvailableSource(string);
        }
    }

    private String selectSource(QName qName, Set<String> set) {
        SeveralSourceFilesWarning severalSourceFilesWarning = new SeveralSourceFilesWarning(qName, set.toArray(new String[set.size()]));
        Object[] objectArray = new Object[]{DialogDescriptor.OK_OPTION};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)severalSourceFilesWarning, NbBundle.getMessage(SeveralSourceFilesWarning.class, (String)"CTL_MORE_THAN_ONE_SOURCE_WARNING_TITLE"), true, objectArray, objectArray[0], 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        JDialog jDialog = (JDialog)dialog;
        jDialog.setDefaultCloseOperation(0);
        jDialog.getRootPane().getInputMap(1).remove(KeyStroke.getKeyStroke(27, 0));
        jDialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcePathImpl.class, (String)"ACS_Select_Source_File_Dialog"));
        dialog.setVisible(true);
        String string = severalSourceFilesWarning.getSelectedInstance();
        set.remove(string);
        this.mySelectedSources.removeAll(set);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                SourcePathImpl.this.myPcs.firePropertyChange(null, null, null);
            }
        });
        dialog.dispose();
        return string;
    }

    private synchronized SessionCookie getSessionCookie() {
        if (this.mySessionCookie == null) {
            this.mySessionCookie = (SessionCookie)this.myLookupProvider.lookupFirst(null, SessionCookie.class);
        }
        return this.mySessionCookie;
    }

    private synchronized SourcePathSelectionProvider getSelectionProvider() {
        if (this.mySelectionProvider == null) {
            this.mySelectionProvider = (SourcePathSelectionProvider)this.myLookupProvider.lookupFirst(null, SourcePathSelectionProvider.class);
        }
        return this.mySelectionProvider;
    }

    private class MyProcessingRunnable
    implements Runnable {
        private MyProcessingRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    String string;
                    Object object = SourcePathImpl.this.myProcessingLock;
                    synchronized (object) {
                        if (SourcePathImpl.this.myUpdatedSources.isEmpty()) {
                            SourcePathImpl.this.myCurrentTask = null;
                            break;
                        }
                        Iterator iterator = SourcePathImpl.this.myUpdatedSources.iterator();
                        string = (String)iterator.next();
                        iterator.remove();
                    }
                    this.processSingleSource(string);
                }
            }
            finally {
                SourcePathImpl.this.myCurrentTask = null;
            }
        }

        private void processSingleSource(String string) {
            FileObject fileObject = FileUtil.toFileObject((File)new File(string));
            if (fileObject == null) {
                return;
            }
            this.registerFileObject(fileObject);
        }

        private void registerFileObject(FileObject fileObject) {
            if (fileObject.isFolder()) {
                for (FileObject fileObject2 : fileObject.getChildren()) {
                    this.registerFileObject(fileObject2);
                }
            } else {
                DataObject dataObject;
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    return;
                }
                BpelModel bpelModel = EditorUtil.getBpelModel(dataObject);
                if (bpelModel == null) {
                    return;
                }
                Process process = bpelModel.getProcess();
                if (process == null) {
                    return;
                }
                String string = process.getName();
                if (string == null || string.trim().equals("")) {
                    return;
                }
                File file = FileUtil.toFile((FileObject)fileObject);
                if (fileObject == null) {
                    return;
                }
                QName qName = new QName(process.getTargetNamespace(), string);
                this.register(file.getPath(), qName);
            }
        }

        private void register(String string, QName qName) {
            HashSet<String> hashSet;
            SourcePathImpl.this.myQNames.put(string, qName);
            SourcePathImpl.this.myAvailableSources.add(string);
            if (SourcePathImpl.this.getSelectionProvider() != null) {
                if (SourcePathImpl.this.getSelectionProvider().isSelected(string)) {
                    SourcePathImpl.this.mySelectedSources.add(string);
                }
            } else {
                SourcePathImpl.this.mySelectedSources.add(string);
            }
            if ((hashSet = (HashSet<String>)SourcePathImpl.this.myAvailableSourcesByQName.get(qName)) == null) {
                hashSet = new HashSet<String>();
                SourcePathImpl.this.myAvailableSourcesByQName.put(qName, hashSet);
            }
            hashSet.add(string);
        }
    }
}

