/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.process;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.BpelProcess;
import org.netbeans.modules.bpel.debugger.api.CorrelationSet;
import org.netbeans.modules.bpel.debugger.api.Fault;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.ProcessInstancesModel;
import org.netbeans.modules.bpel.debugger.api.WaitingCorrelatedMessage;
import org.netbeans.modules.bpel.debugger.api.variables.Variable;
import org.netbeans.modules.bpel.debugger.ui.util.VariablesUtil;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class ProcessesTreeModel
implements TreeModel {
    private BpelDebugger myDebugger;
    private Listener myListener;
    private Vector<ModelListener> myListeners = new Vector();
    private VariablesUtil myVariablesUtil;

    public ProcessesTreeModel() {
    }

    public ProcessesTreeModel(ContextProvider contextProvider) {
        this.myDebugger = (BpelDebugger)contextProvider.lookupFirst(null, BpelDebugger.class);
        this.myVariablesUtil = new VariablesUtil(this.myDebugger);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object.equals("Root")) {
            return this.filter(this.getProcesses(), n, n2);
        }
        if (object instanceof BpelProcess) {
            ProcessInstance[] processInstanceArray = this.getProcessInstances((BpelProcess)object);
            Object[] objectArray = new Object[processInstanceArray.length];
            System.arraycopy(processInstanceArray, 0, objectArray, 0, processInstanceArray.length);
            return this.filter(objectArray, n, n2);
        }
        if (object instanceof ProcessInstance) {
            return new Object[]{new CorrelationSetsWrapper((ProcessInstance)object), new FaultsWrapper((ProcessInstance)object)};
        }
        if (object instanceof CorrelationSetsWrapper) {
            return this.filter(((CorrelationSetsWrapper)object).getProcessInstance().getCorrelationSets(), n, n2);
        }
        if (object instanceof CorrelationSet) {
            Object[] objectArray = ((CorrelationSet)object).getProperties();
            if (objectArray.length == 0) {
                return this.filter(new Object[]{new NoPropertiesDataMarker()}, n, n2);
            }
            return this.filter(objectArray, n, n2);
        }
        if (object instanceof CorrelationSet.Property) {
            return new Object[0];
        }
        if (object instanceof WaitingMessagesWrapper) {
            BpelProcess bpelProcess = ((WaitingMessagesWrapper)object).getProcess();
            return this.filter(bpelProcess.getWaitingCorrelatedEvents(), n, n2);
        }
        if (object instanceof WaitingCorrelatedMessage) {
            return this.filter(((WaitingCorrelatedMessage)object).getCorrelationSets(), n, n2);
        }
        if (object instanceof FaultsWrapper) {
            return this.filter(((FaultsWrapper)object).getProcessInstance().getFaults(), n, n2);
        }
        if (object instanceof Fault) {
            Variable variable = ((Fault)object).getVariable();
            if (variable != null) {
                return this.filter(this.myVariablesUtil.getChildren(variable), n, n2);
            }
            return new Object[0];
        }
        return this.filter(this.myVariablesUtil.getChildren(object), n, n2);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return this.getProcesses().length;
        }
        if (object instanceof BpelProcess) {
            return this.getProcessInstances((BpelProcess)object).length;
        }
        if (object instanceof ProcessInstance) {
            return 1;
        }
        if (object instanceof CorrelationSetsWrapper) {
            return ((CorrelationSetsWrapper)object).getCorrelationSets().length;
        }
        if (object instanceof CorrelationSet) {
            int n = ((CorrelationSet)object).getProperties().length;
            return n == 0 ? 1 : n;
        }
        if (object instanceof CorrelationSet.Property) {
            return 0;
        }
        if (object instanceof WaitingMessagesWrapper) {
            BpelProcess bpelProcess = ((WaitingMessagesWrapper)object).getProcess();
            return bpelProcess.getWaitingCorrelatedEvents().length;
        }
        if (object instanceof WaitingCorrelatedMessage) {
            return ((WaitingCorrelatedMessage)object).getCorrelationSets().length;
        }
        if (object instanceof FaultsWrapper) {
            return ((FaultsWrapper)object).getProcessInstance().getFaults().length;
        }
        if (object instanceof Fault) {
            Variable variable = ((Fault)object).getVariable();
            if (variable != null) {
                return this.myVariablesUtil.getChildren(variable).length;
            }
            return 0;
        }
        return this.myVariablesUtil.getChildren(object).length;
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        return this.getChildrenCount(object) == 0;
    }

    public void addModelListener(ModelListener modelListener) {
        this.myListeners.add(modelListener);
        if (this.myListener == null && this.myDebugger != null) {
            this.myListener = new Listener(this, this.myDebugger);
        }
    }

    public void removeModelListener(ModelListener modelListener) {
        this.myListeners.remove(modelListener);
        if (this.myListeners.size() == 0 && this.myListener != null) {
            this.myListener.destroy();
            this.myListener = null;
        }
    }

    private void runInDispatch(Runnable runnable) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    private void fireTreeChanged() {
        Runnable runnable = new Runnable(){

            public void run() {
                Vector vector = (Vector)ProcessesTreeModel.this.myListeners.clone();
                for (int i = 0; i < vector.size(); ++i) {
                    ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
                }
            }
        };
        this.runInDispatch(runnable);
    }

    private BpelProcess[] getProcesses() {
        if (this.myDebugger != null) {
            return this.myDebugger.getProcessInstancesModel().getProcesses();
        }
        return new BpelProcess[0];
    }

    private ProcessInstance[] getProcessInstances(BpelProcess bpelProcess) {
        if (this.myDebugger != null) {
            return this.myDebugger.getProcessInstancesModel().getProcessInstances(bpelProcess);
        }
        return new ProcessInstance[0];
    }

    private Object[] filter(Object[] objectArray, int n, int n2) {
        Object[] objectArray2 = new Object[n2 - n];
        System.arraycopy(objectArray, n, objectArray2, 0, n2 - n);
        return objectArray2;
    }

    static class NoPropertiesDataMarker {
        NoPropertiesDataMarker() {
        }
    }

    static class WaitingMessagesWrapper
    extends ProcessWrapper {
        public WaitingMessagesWrapper(BpelProcess bpelProcess) {
            super(bpelProcess);
        }
    }

    static class FaultsWrapper
    extends ProcessInstanceWrapper {
        public FaultsWrapper(ProcessInstance processInstance) {
            super(processInstance);
        }
    }

    static class CorrelationSetsWrapper
    extends ProcessInstanceWrapper {
        public CorrelationSetsWrapper(ProcessInstance processInstance) {
            super(processInstance);
        }

        public CorrelationSet[] getCorrelationSets() {
            return this.getProcessInstance().getCorrelationSets();
        }
    }

    private static class ProcessWrapper {
        private BpelProcess myProcess;

        public ProcessWrapper(BpelProcess bpelProcess) {
            this.myProcess = bpelProcess;
        }

        public BpelProcess getProcess() {
            return this.myProcess;
        }
    }

    private static class ProcessInstanceWrapper {
        private ProcessInstance myProcessInstance;

        public ProcessInstanceWrapper(ProcessInstance processInstance) {
            this.myProcessInstance = processInstance;
        }

        public ProcessInstance getProcessInstance() {
            return this.myProcessInstance;
        }
    }

    private static class Listener
    implements ProcessInstancesModel.Listener,
    PropertyChangeListener {
        private BpelDebugger myDebugger;
        private WeakReference<ProcessesTreeModel> myModel;
        private RequestProcessor.Task task;

        private Listener(ProcessesTreeModel processesTreeModel, BpelDebugger bpelDebugger) {
            this.myDebugger = bpelDebugger;
            this.myModel = new WeakReference<ProcessesTreeModel>(processesTreeModel);
            bpelDebugger.addPropertyChangeListener((PropertyChangeListener)this);
            bpelDebugger.getProcessInstancesModel().addListener((ProcessInstancesModel.Listener)this);
        }

        void destroy() {
            this.myDebugger.getProcessInstancesModel().removeListener((ProcessInstancesModel.Listener)this);
            this.myDebugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        private ProcessesTreeModel getModel() {
            ProcessesTreeModel processesTreeModel = (ProcessesTreeModel)this.myModel.get();
            if (processesTreeModel == null) {
                this.destroy();
            }
            return processesTreeModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("currentProcessInstance".equals(propertyChangeEvent.getPropertyName())) {
                this.asyncFireTreeChanged();
            } else if ("state".equals(propertyChangeEvent.getPropertyName())) {
                if (this.myDebugger.getState() == 4) {
                    this.destroy();
                    this.asyncFireTreeChanged();
                } else if (this.myDebugger.getState() == 2) {
                    this.asyncFireTreeChanged();
                }
            }
        }

        public void processInstanceRemoved(ProcessInstance processInstance) {
            this.asyncFireTreeChanged();
        }

        public void processInstanceAdded(ProcessInstance processInstance) {
            this.asyncFireTreeChanged();
        }

        public void processInstanceStateChanged(ProcessInstance processInstance, int n, int n2) {
            this.asyncFireTreeChanged();
        }

        private void asyncFireTreeChanged() {
            final ProcessesTreeModel processesTreeModel = this.getModel();
            if (processesTreeModel == null) {
                return;
            }
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
            this.task = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    processesTreeModel.fireTreeChanged();
                }
            }, 500);
        }
    }
}

