/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.openide.cookies.EditorCookie;
import org.openide.util.RequestProcessor;

public class EditorObserver {
    private PropertyChangeListener myOuterListener;
    private EditorListener myEditorListener;
    private EditorDocumentListener myDocumentListener;
    private Document myDocument;
    private final EditorCookie.Observable myEditor;

    public EditorObserver(EditorCookie.Observable observable) {
        this.myEditor = observable;
    }

    public void subscribe(PropertyChangeListener propertyChangeListener) {
        if (this.myOuterListener != null) {
            this.unsubscribe();
        }
        this.myOuterListener = propertyChangeListener;
        this.myEditorListener = new EditorListener();
        this.myEditor.addPropertyChangeListener((PropertyChangeListener)this.myEditorListener);
        this.smartDocSubscribe();
    }

    public void unsubscribe() {
        if (this.myOuterListener == null) {
            return;
        }
        this.myEditor.removePropertyChangeListener((PropertyChangeListener)this.myEditorListener);
        this.myEditorListener = null;
        this.docUnsubscribe();
        this.myOuterListener = null;
    }

    private void docUnsubscribe() {
        if (this.myDocumentListener == null) {
            return;
        }
        assert (this.myDocument != null);
        this.myDocument.removeDocumentListener(this.myDocumentListener);
        this.myDocument = null;
        this.myDocumentListener = null;
    }

    private void smartDocSubscribe() {
        if (this.myEditorListener == null) {
            return;
        }
        StyledDocument styledDocument = this.myEditor.getDocument();
        if (styledDocument == null && this.myDocumentListener != null) {
            assert (this.myDocument != null);
            this.myDocument.removeDocumentListener(this.myDocumentListener);
            this.myDocument = null;
            this.myDocumentListener = null;
        } else if (styledDocument != null && this.myDocumentListener == null) {
            assert (this.myDocument == null);
            this.myDocument = styledDocument;
            this.myDocumentListener = new EditorDocumentListener();
            this.myDocument.addDocumentListener(this.myDocumentListener);
        }
    }

    private class EditorDocumentListener
    implements DocumentListener {
        private RequestProcessor.Task task;

        private EditorDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.fireChangeEvent();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.fireChangeEvent();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.fireChangeEvent();
        }

        private void fireChangeEvent() {
            PropertyChangeListener propertyChangeListener;
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
            if ((propertyChangeListener = EditorObserver.this.myOuterListener) == null) {
                return;
            }
            this.task = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    propertyChangeListener.propertyChange(new PropertyChangeEvent(EditorObserver.this.myEditor, null, null, null));
                }
            }, 1000);
        }
    }

    private class EditorListener
    implements PropertyChangeListener {
        private EditorListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("document".equals(propertyChangeEvent.getPropertyName())) {
                EditorObserver.this.smartDocSubscribe();
            } else if ("openedPanes".equals(propertyChangeEvent.getPropertyName())) {
                EditorObserver.this.smartDocSubscribe();
            }
        }
    }
}

