/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import org.netbeans.modules.bpel.debugger.ui.editor.BpelAnnotation;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListenerAdapter;
import org.openide.util.RequestProcessor;

public class BpelAnnotationsObserver {
    private static HashMap<BpelModel, LinkedList<BpelAnnotation>> myModelAnnotations = new HashMap();
    private static HashMap<BpelModel, Listener> myModelListeners = new HashMap();

    private BpelAnnotationsObserver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void subscribe(BpelAnnotation bpelAnnotation) {
        BpelModel bpelModel = bpelAnnotation.getBpelModel();
        if (bpelModel == null) {
            return;
        }
        HashMap<BpelModel, LinkedList<BpelAnnotation>> hashMap = myModelAnnotations;
        synchronized (hashMap) {
            LinkedList<BpelAnnotation> linkedList = myModelAnnotations.get(bpelModel);
            if (linkedList == null) {
                linkedList = new LinkedList();
                myModelAnnotations.put(bpelModel, linkedList);
                BpelAnnotationsObserver.subscribeToModel(bpelModel);
            }
            linkedList.add(bpelAnnotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsubscribe(BpelAnnotation bpelAnnotation) {
        BpelModel bpelModel = bpelAnnotation.getBpelModel();
        if (bpelModel == null) {
            return;
        }
        HashMap<BpelModel, LinkedList<BpelAnnotation>> hashMap = myModelAnnotations;
        synchronized (hashMap) {
            LinkedList<BpelAnnotation> linkedList = myModelAnnotations.get(bpelModel);
            if (linkedList != null) {
                linkedList.remove(bpelAnnotation);
                if (linkedList.size() == 0) {
                    BpelAnnotationsObserver.unsubscribeFromModel(bpelModel);
                    myModelAnnotations.remove(bpelModel);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BpelAnnotation[] getAnnotations(BpelModel bpelModel) {
        BpelAnnotation[] bpelAnnotationArray = null;
        HashMap<BpelModel, LinkedList<BpelAnnotation>> hashMap = myModelAnnotations;
        synchronized (hashMap) {
            LinkedList<BpelAnnotation> linkedList = myModelAnnotations.get(bpelModel);
            if (linkedList != null) {
                bpelAnnotationArray = linkedList.toArray(new BpelAnnotation[linkedList.size()]);
            }
        }
        if (bpelAnnotationArray != null) {
            return bpelAnnotationArray;
        }
        return new BpelAnnotation[0];
    }

    private static void subscribeToModel(BpelModel bpelModel) {
        Listener listener = new Listener(bpelModel);
        myModelListeners.put(bpelModel, listener);
        listener.subscribe();
    }

    private static void unsubscribeFromModel(BpelModel bpelModel) {
        Listener listener = myModelListeners.get(bpelModel);
        listener.unsubscribe();
        myModelListeners.remove(bpelModel);
    }

    private static class Listener
    extends ChangeEventListenerAdapter
    implements PropertyChangeListener {
        private BpelModel myModel;
        private RequestProcessor.Task myTask;

        public Listener(BpelModel bpelModel) {
            this.myModel = bpelModel;
        }

        public void subscribe() {
            this.myModel.addEntityChangeListener((ChangeEventListener)this);
            this.myModel.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void unsubscribe() {
            this.myModel.removeEntityChangeListener((ChangeEventListener)this);
            this.myModel.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.myTask != null) {
                this.myTask.cancel();
                this.myTask = null;
            }
        }

        protected void notifyEvent(ChangeEvent changeEvent) {
            if (changeEvent.isLastInAtomic()) {
                this.notifyModelChanged();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.notifyModelChanged();
        }

        private void notifyModelChanged() {
            if (this.myTask != null) {
                this.myTask.cancel();
                this.myTask = null;
            }
            this.myTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    BpelAnnotation[] bpelAnnotationArray;
                    for (BpelAnnotation bpelAnnotation : bpelAnnotationArray = BpelAnnotationsObserver.getAnnotations(Listener.this.myModel)) {
                        bpelAnnotation.update();
                    }
                }
            }, 1000);
        }
    }
}

