/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.breakpoint;

import java.io.StringReader;
import org.netbeans.modules.bpel.debugger.ui.breakpoint.BPELActivityFinderSaxHandler;
import org.netbeans.modules.bpel.debugger.ui.breakpoint.BPELNode;
import org.netbeans.modules.bpel.debugger.ui.util.EditorUtil;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class BreakpointTranslator {
    static BreakpointTranslator mInstance = new BreakpointTranslator();

    public int translateBreakpointLine(String string, int n) {
        try {
            BPELActivityFinderSaxHandler bPELActivityFinderSaxHandler = this.parse(EditorUtil.getText(string), n);
            BPELNode bPELNode = BreakpointTranslator.getValidNode(bPELActivityFinderSaxHandler.getFoundNode());
            if (bPELNode != null) {
                return bPELNode.getLineNumber();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private BPELActivityFinderSaxHandler parse(String string, int n) throws Exception {
        BPELActivityFinderSaxHandler bPELActivityFinderSaxHandler = new BPELActivityFinderSaxHandler(n);
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xMLReader.setContentHandler(bPELActivityFinderSaxHandler);
        xMLReader.setErrorHandler(bPELActivityFinderSaxHandler);
        xMLReader.parse(new InputSource(new StringReader(string)));
        return bPELActivityFinderSaxHandler;
    }

    private static BPELNode getValidNode(BPELNode bPELNode) {
        if (bPELNode == null) {
            return null;
        }
        if (bPELNode.isActivity() || bPELNode.getName().equals("copy") || bPELNode.getName().equals("elseif") || bPELNode.getName().equals("else") || bPELNode.getName().equals("condition") || bPELNode.getName().equals("onAlarm") || bPELNode.getName().equals("onEvent")) {
            return bPELNode;
        }
        return BreakpointTranslator.getValidNode(bPELNode.getParent());
    }
}

