/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.action;

import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.bpel.debugger.api.breakpoints.LineBreakpoint;
import org.netbeans.modules.bpel.debugger.ui.breakpoint.BpelBreakpointListener;
import org.netbeans.modules.bpel.debugger.ui.util.EditorUtil;
import org.netbeans.modules.bpel.debugger.ui.util.ModelUtil;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.BooleanStateAction;
import org.openide.windows.WindowManager;

public class BreakpointEnableAction
extends BooleanStateAction {
    private BpelBreakpointListener myBreakpointAnnotationListener;
    private static final long serialVersionUID = 1L;

    public boolean isEnabled() {
        LineBreakpoint lineBreakpoint = this.findCurrentBreakpoint();
        if (lineBreakpoint != null) {
            boolean bl = lineBreakpoint.isEnabled();
            super.setBooleanState(bl);
            return true;
        }
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(BreakpointEnableAction.class, (String)"CTL_enabled");
    }

    public void setBooleanState(boolean bl) {
        LineBreakpoint lineBreakpoint = this.findCurrentBreakpoint();
        if (bl) {
            lineBreakpoint.enable();
        } else {
            lineBreakpoint.disable();
        }
        super.setBooleanState(bl);
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    private LineBreakpoint findCurrentBreakpoint() {
        Node node = this.getCurrentNode();
        if (node == null) {
            return null;
        }
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        String string = this.getFileExt(dataObject);
        if (!"bpel".equals(string)) {
            return null;
        }
        int n = EditorUtil.getLineNumber(node);
        if (n < 1) {
            return null;
        }
        StyledDocument styledDocument = EditorUtil.getDocument(dataObject);
        if (styledDocument == null) {
            return null;
        }
        int n2 = EditorUtil.findOffset(styledDocument, n);
        BpelModel bpelModel = EditorUtil.getBpelModel(dataObject);
        if (bpelModel == null) {
            return null;
        }
        UniqueId uniqueId = ModelUtil.getBpelEntityId(bpelModel, n2);
        String string2 = FileUtil.toFile((FileObject)dataObject.getPrimaryFile()).getPath();
        string2 = string2.replace("\\", "/");
        if (uniqueId == null) {
            return null;
        }
        String string3 = ModelUtil.getXpath(uniqueId);
        if (string3 == null) {
            return null;
        }
        return this.getBreakpointAnnotationListener().findBreakpoint(string2, string3, n);
    }

    private Node getCurrentNode() {
        Node[] nodeArray = WindowManager.getDefault().getRegistry().getCurrentNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        return nodeArray[0];
    }

    private String getFileExt(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (fileObject == null) {
            return null;
        }
        return fileObject.getExt();
    }

    private BpelBreakpointListener getBreakpointAnnotationListener() {
        if (this.myBreakpointAnnotationListener == null) {
            this.myBreakpointAnnotationListener = (BpelBreakpointListener)((Object)DebuggerManager.getDebuggerManager().lookupFirst(null, BpelBreakpointListener.class));
        }
        return this.myBreakpointAnnotationListener;
    }
}

