/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard.i18n;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.ui.wizard.i18n.LocalizationSupportPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class LocalizationSupportPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private LocalizationSupportPanelGUI gui;
    private TemplateWizard templateWizard = null;

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new LocalizationSupportPanelGUI();
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(LocalizationSupportPanel.class);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void readSettings(Object object) {
        this.templateWizard = (TemplateWizard)object;
        if (this.getComponent() != null) {
            Project project = Templates.getProject((WizardDescriptor)this.templateWizard);
            FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.templateWizard);
            this.gui.initValues(project, Templates.getTemplate((WizardDescriptor)this.templateWizard), fileObject);
        }
    }

    private static String getPackage(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null) {
            return classPath.getResourceName(fileObject, '.', false);
        }
        return "";
    }

    private static String getFullMessageResourceName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("/");
        if (string2 != null && !string2.equals("")) {
            stringBuffer.append(string2.replace('.', '/'));
            stringBuffer.append('/');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void storeSettings(Object object) {
        if (this.isValid()) {
            String string;
            FileObject fileObject = this.gui.getRootFolder();
            FileObject fileObject2 = fileObject.getFileObject(string = this.gui.getPackageFileName());
            if (fileObject2 == null) {
                try {
                    fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)string);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    return;
                }
            }
            Templates.setTargetFolder((WizardDescriptor)this.templateWizard, (FileObject)fileObject2);
            Templates.setTargetName((WizardDescriptor)this.templateWizard, (String)this.gui.getTargetClassName());
            String string2 = LocalizationSupportPanel.getFullMessageResourceName(this.gui.getTargetMessageFileNameExt(), LocalizationSupportPanel.getPackage(fileObject2));
            ((WizardDescriptor)object).putProperty("MESSAGE_BUNDLE_FILENAME", (Object)this.gui.getTargetMessageFileName());
            ((WizardDescriptor)object).putProperty("__MESSAGE_BUNDLE_RESOURCE_NAME__", (Object)string2);
            ((WizardDescriptor)object).putProperty("__DEFAULT_STRING__", (Object)this.gui.getTargetDefaultStringValue());
            ((WizardDescriptor)object).putProperty("__DEFAULT_ERROR__", (Object)this.gui.getTargetDefaultErrorMessageValue());
        }
    }

    private void appendMessage(StringBuffer stringBuffer, String string) {
        String string2 = NbBundle.getMessage(this.getClass(), (String)string);
        if (string2 != null && string2.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string2);
        }
    }

    private static boolean isValidJavaFolderName(String string) {
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.gui == null) {
            this.appendMessage(stringBuffer, "ERR_File_NoGUI");
        } else {
            if (this.gui.getTargetClassName() == null || "".equals(this.gui.getTargetClassName())) {
                this.appendMessage(stringBuffer, "ERR_File_NoTargetClassName");
            } else if (!LocalizationSupportPanel.isValidJavaFolderName(this.gui.getPackageFileName())) {
                this.appendMessage(stringBuffer, "ERR_File_NoTargetFolder");
            } else if (this.gui.getCreatedClass() != null && new File(this.gui.getCreatedClass()).exists()) {
                this.appendMessage(stringBuffer, "ERR_File_ClassAlreadyExists");
            } else if (!Utilities.isJavaIdentifier((String)this.gui.getTargetClassName())) {
                this.appendMessage(stringBuffer, "ERR_File_InvalidClassName");
            }
            if (this.gui.getTargetMessageFileName() == null || "".equals(this.gui.getTargetMessageFileName())) {
                this.appendMessage(stringBuffer, "ERR_File_NoTargetMessageFileName");
            } else if (this.gui.getCreatedMessageFile() != null && new File(this.gui.getCreatedMessageFile()).exists()) {
                this.appendMessage(stringBuffer, "ERR_File_MessageResourceAlreadyExists");
            }
        }
        if (this.templateWizard != null) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)stringBuffer.toString());
        }
        return stringBuffer.length() == 0;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.templateWizard != null) {
            this.templateWizard.setValid(this.isValid());
        }
        this.fireChange();
    }

    public boolean isFinishPanel() {
        return true;
    }
}

