/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.FaultNameReference;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.MessageExchange;
import org.netbeans.modules.bpel.model.api.MessageExchangeReference;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OperationReference;
import org.netbeans.modules.bpel.model.api.PartReference;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PortTypeReference;
import org.netbeans.modules.bpel.model.api.PropertyReference;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Throw;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.model.api.references.ReferenceCollection;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.refactoring.Element;
import org.netbeans.modules.bpel.refactoring.Plugin;
import org.netbeans.modules.bpel.refactoring.Util;
import org.netbeans.modules.bpel.refactoring.XPath;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.xml.refactoring.ErrorItem;
import org.netbeans.modules.xml.refactoring.XMLRefactoringPlugin;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.spi.RefactoringUtil;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.CorrelationProperty;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PropertyAlias;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Query;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Renamer
extends Plugin {
    private XPath myXPath;
    private String myOldName;
    private RenameRefactoring myRequest;

    Renamer(RenameRefactoring renameRefactoring) {
        this.myRequest = renameRefactoring;
    }

    public Problem fastCheckParameters() {
        Referenceable referenceable = (Referenceable)this.myRequest.getRefactoringSource().lookup(Referenceable.class);
        ErrorItem errorItem = null;
        if (referenceable instanceof Model) {
            errorItem = RefactoringUtil.precheck((Model)((Model)referenceable), (String)this.myRequest.getNewName());
        } else if (referenceable instanceof Nameable) {
            errorItem = RefactoringUtil.precheck((Nameable)((Nameable)referenceable), (String)this.myRequest.getNewName());
        }
        if (errorItem != null) {
            return new Problem(true, errorItem.getMessage());
        }
        return null;
    }

    public Problem checkParameters() {
        Referenceable referenceable = (Referenceable)this.myRequest.getRefactoringSource().lookup(Referenceable.class);
        if (referenceable == null) {
            return null;
        }
        if (!(referenceable instanceof Model) && !(referenceable instanceof Nameable)) {
            return null;
        }
        Model model = SharedUtils.getModel((Referenceable)referenceable);
        ErrorItem errorItem = RefactoringUtil.precheckTarget((Model)model, (boolean)true);
        if (errorItem != null) {
            return new Problem(this.isFatal(errorItem), errorItem.getMessage());
        }
        if (referenceable instanceof Model) {
            errorItem = RefactoringUtil.precheck((Model)model, (String)this.myRequest.getNewName());
        } else if (referenceable instanceof Nameable) {
            errorItem = RefactoringUtil.precheck((Nameable)((Nameable)referenceable), (String)this.myRequest.getNewName());
        }
        if (errorItem != null) {
            return new Problem(this.isFatal(errorItem), errorItem.getMessage());
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Object object;
        Referenceable referenceable = (Referenceable)this.myRequest.getRefactoringSource().lookup(Referenceable.class);
        if (referenceable == null) {
            return null;
        }
        if (!(referenceable instanceof Model) && !(referenceable instanceof Nameable)) {
            return null;
        }
        Set<Component> set = this.getRoots(referenceable);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            List<Element> object3 = this.find(referenceable, (Component)object);
            if (object3 == null) continue;
            arrayList.addAll(object3);
        }
        if (arrayList.size() > 0 && (object = RefactoringUtil.precheckUsageModels((List)(object2 = this.getModels(arrayList)), (boolean)true)) != null && object.size() > 0) {
            return this.processErrors((List<ErrorItem>)object);
        }
        object2 = (XMLRefactoringTransaction)this.myRequest.getContext().lookup(XMLRefactoringTransaction.class);
        object2.register((XMLRefactoringPlugin)this, arrayList);
        refactoringElementsBag.registerTransaction((Transaction)object2);
        for (Element element : arrayList) {
            element.setTransactionObject((XMLRefactoringTransaction)object2);
            refactoringElementsBag.add((AbstractRefactoring)this.myRequest, (RefactoringElementImplementation)element);
        }
        return null;
    }

    public void doRefactoring(List<RefactoringElementImplementation> list) throws IOException {
        Map<Model, Set<RefactoringElementImplementation>> map = this.getModelMap(list);
        Set<Model> set = map.keySet();
        Referenceable referenceable = (Referenceable)this.myRequest.getRefactoringSource().lookup(Referenceable.class);
        String string = (String)this.myRequest.getContext().lookup(String.class);
        for (Model model : set) {
            if (referenceable instanceof Nameable) {
                this.rename(this.getComponents(map.get(model)), model, (Named)referenceable, string);
                continue;
            }
            if (!(referenceable instanceof Model)) continue;
            this.rename(this.getComponents(map.get(model)));
        }
    }

    @Override
    public String getModelReference(Component component) {
        if (component instanceof Import) {
            return ((Import)component).getLocation();
        }
        return null;
    }

    private Map<Model, Set<RefactoringElementImplementation>> getModelMap(List<RefactoringElementImplementation> list) {
        HashMap<Model, Set<RefactoringElementImplementation>> hashMap = new HashMap<Model, Set<RefactoringElementImplementation>>();
        for (RefactoringElementImplementation refactoringElementImplementation : list) {
            Model model = ((Component)refactoringElementImplementation.getLookup().lookup(Component.class)).getModel();
            HashSet<RefactoringElementImplementation> hashSet = (HashSet<RefactoringElementImplementation>)hashMap.get(model);
            if (hashSet == null) {
                hashSet = new HashSet<RefactoringElementImplementation>();
                hashSet.add(refactoringElementImplementation);
                hashMap.put(model, hashSet);
                continue;
            }
            hashSet.add(refactoringElementImplementation);
        }
        return hashMap;
    }

    private List<Component> getComponents(Set<RefactoringElementImplementation> set) {
        ArrayList<Component> arrayList = new ArrayList<Component>(set.size());
        for (RefactoringElementImplementation refactoringElementImplementation : set) {
            arrayList.add((Component)refactoringElementImplementation.getLookup().lookup(Component.class));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rename(List<Component> list, Model model, Named named, String string) throws IOException {
        if (named == null || list == null || model == null) {
            return;
        }
        this.myXPath = new XPath(null, named, string);
        this.myOldName = string;
        boolean bl = !model.isIntransaction();
        try {
            if (bl) {
                model.startTransaction();
            }
            for (Component component : list) {
                this.renameComponent(component, named);
            }
        }
        finally {
            if (bl && model.isIntransaction()) {
                model.endTransaction();
            }
        }
    }

    private void rename(List<Component> list) throws IOException {
        if (list == null) {
            return;
        }
        for (Component component : list) {
            this.renameFile(component);
        }
    }

    private void renameFile(Component component) throws IOException {
        if (!(component instanceof Import)) {
            return;
        }
        try {
            Import import_ = (Import)component;
            import_.setLocation(SharedUtils.calculateNewLocationString((String)import_.getLocation(), (RenameRefactoring)this.myRequest));
        }
        catch (VetoException vetoException) {
            throw new IOException(vetoException.getMessage());
        }
    }

    private void renameComponent(Component component, Named named) throws IOException {
        if (component instanceof PartReference && ((PartReference)component).getPart() != null && component instanceof ReferenceCollection && named instanceof Part) {
            this.rename((PartReference)component, (Part)named);
        } else if (component instanceof PropertyReference && ((PropertyReference)component).getProperty() != null && component instanceof ReferenceCollection && named instanceof CorrelationProperty) {
            this.rename((PropertyReference)component, (CorrelationProperty)named);
        } else if (component instanceof Variable) {
            this.rename((Variable)component, named);
        } else {
            this.renameCamponent(component, named);
        }
    }

    private void renameCamponent(Component component, Named named) throws IOException {
        if (component instanceof OperationReference && component instanceof ReferenceCollection && named instanceof Operation) {
            this.rename((OperationReference)component, (Operation)named);
        } else if (component instanceof PortTypeReference && component instanceof ReferenceCollection && named instanceof PortType) {
            this.rename((PortTypeReference)component, (PortType)named);
        } else if (component instanceof MessageExchangeReference && component instanceof ReferenceCollection && named instanceof MessageExchange) {
            this.rename((MessageExchangeReference)component, (MessageExchange)named);
        } else {
            this.renameCampanent(component, named);
        }
    }

    private void renameCampanent(Component component, Named named) throws IOException {
        if (component instanceof Role && named instanceof PortType) {
            this.rename((Role)component, (PortType)named);
        } else if (component instanceof Catch) {
            this.rename((Catch)component, named);
        } else if (component instanceof Reply) {
            this.rename((Reply)component, named);
        } else if (component instanceof Throw) {
            this.rename((Throw)component, named);
        } else if (component instanceof OnEvent) {
            this.rename((OnEvent)component, named);
        } else if (component instanceof CorrelationProperty) {
            this.rename((CorrelationProperty)component, named);
        } else if (component instanceof PropertyAlias) {
            this.rename((PropertyAlias)component, named);
        } else if (component instanceof PartnerLink) {
            this.rename((PartnerLink)component, named);
        } else {
            this.renameKomponent(component, named);
        }
    }

    private void renameKomponent(Component component, Named named) throws IOException {
        if (component instanceof CorrelationSet) {
            this.rename((CorrelationSet)component, named);
        } else if (component instanceof ContentElement && component instanceof BpelEntity) {
            this.rename((ContentElement)component);
        } else if (component instanceof Query) {
            this.rename((Query)component, named);
        } else {
            return;
        }
    }

    private void rename(PartReference partReference, Part part) {
        partReference.setPart(((ReferenceCollection)partReference).createWSDLReference((ReferenceableWSDLComponent)part, Part.class));
    }

    private void rename(PropertyReference propertyReference, CorrelationProperty correlationProperty) {
        propertyReference.setProperty(((ReferenceCollection)propertyReference).createWSDLReference((ReferenceableWSDLComponent)correlationProperty, CorrelationProperty.class));
    }

    private void rename(PortTypeReference portTypeReference, PortType portType) {
        portTypeReference.setPortType(portTypeReference.createWSDLReference((ReferenceableWSDLComponent)portType, PortType.class));
    }

    private void rename(OperationReference operationReference, Operation operation) {
        operationReference.setOperation(operationReference.createWSDLReference((ReferenceableWSDLComponent)operation, Operation.class));
    }

    private void rename(MessageExchangeReference messageExchangeReference, MessageExchange messageExchange) {
        messageExchangeReference.setMessageExchange(((ReferenceCollection)messageExchangeReference).createReference((BpelReferenceable)messageExchange, MessageExchange.class));
    }

    private void rename(Role role, PortType portType) throws IOException {
        role.setPortType(portType.createReferenceTo((ReferenceableWSDLComponent)portType, PortType.class));
    }

    private void rename(ContentElement contentElement) throws IOException {
        String string = this.myXPath.rename(contentElement.getContent(), (Component)((BpelEntity)contentElement));
        try {
            contentElement.setContent(string);
        }
        catch (VetoException vetoException) {
            throw new IOException(vetoException.getMessage());
        }
    }

    private void rename(CorrelationProperty correlationProperty, Named named) throws IOException {
        NamedComponentReference namedComponentReference;
        NamedComponentReference namedComponentReference2 = correlationProperty.getElement();
        if (namedComponentReference2 != null && named instanceof GlobalElement) {
            correlationProperty.setElement(((GlobalElement)named).createReferenceTo((ReferenceableSchemaComponent)((GlobalElement)named), GlobalElement.class));
        }
        if ((namedComponentReference = correlationProperty.getType()) != null && named instanceof GlobalType) {
            correlationProperty.setType(((GlobalType)named).createReferenceTo((ReferenceableSchemaComponent)((GlobalType)named), GlobalType.class));
        }
    }

    private void rename(PropertyAlias propertyAlias, Named named) throws IOException {
        NamedComponentReference namedComponentReference;
        NamedComponentReference namedComponentReference2 = propertyAlias.getElement();
        if (namedComponentReference2 != null && named instanceof GlobalElement) {
            propertyAlias.setElement(((GlobalElement)named).createReferenceTo((ReferenceableSchemaComponent)((GlobalElement)named), GlobalElement.class));
        }
        if ((namedComponentReference = propertyAlias.getType()) != null && named instanceof GlobalType) {
            propertyAlias.setType(((GlobalType)named).createReferenceTo((ReferenceableSchemaComponent)((GlobalType)named), GlobalType.class));
        }
        if (named instanceof Message) {
            propertyAlias.setMessageType(((Message)named).createReferenceTo((ReferenceableWSDLComponent)((Message)named), Message.class));
        } else if (named instanceof Part) {
            propertyAlias.setPart(((Part)named).getName());
        } else if (named instanceof CorrelationProperty) {
            propertyAlias.setPropertyName(((CorrelationProperty)named).createReferenceTo((ReferenceableWSDLComponent)((CorrelationProperty)named), CorrelationProperty.class));
        }
    }

    private void rename(Query query, Named named) throws IOException {
        int n = Util.checkQuery(query, this.myOldName);
        if (n == -1) {
            return;
        }
        String string = query.getContent();
        query.setContent(string.substring(0, n) + named.getName() + string.substring(n + this.myOldName.length()));
    }

    private void rename(OnEvent onEvent, Named named) throws IOException {
        if (named instanceof Message) {
            onEvent.setMessageType(onEvent.createWSDLReference((ReferenceableWSDLComponent)((Message)named), Message.class));
        }
    }

    private void rename(PartnerLink partnerLink, Named named) throws IOException {
        if (named instanceof PartnerLinkType) {
            partnerLink.setPartnerLinkType(partnerLink.createWSDLReference((ReferenceableWSDLComponent)((PartnerLinkType)named), PartnerLinkType.class));
        } else if (named instanceof Role) {
            WSDLReference wSDLReference = partnerLink.createWSDLReference((ReferenceableWSDLComponent)((Role)named), Role.class);
            if (this.isRenamedRole(partnerLink, "myRole")) {
                partnerLink.setMyRole(wSDLReference);
            } else if (this.isRenamedRole(partnerLink, "partnerRole")) {
                partnerLink.setPartnerRole(wSDLReference);
            }
        }
    }

    private void rename(CorrelationSet correlationSet, Named named) throws IOException {
        if (named instanceof CorrelationProperty) {
            List list = correlationSet.getProperties();
            ArrayList<WSDLReference> arrayList = new ArrayList<WSDLReference>();
            if (list == null) {
                return;
            }
            for (WSDLReference wSDLReference : list) {
                if (wSDLReference.get() != null) {
                    arrayList.add(wSDLReference);
                    continue;
                }
                arrayList.add(correlationSet.createWSDLReference((ReferenceableWSDLComponent)((CorrelationProperty)named), CorrelationProperty.class));
            }
            correlationSet.setProperties(arrayList);
        }
    }

    private boolean isRenamedRole(PartnerLink partnerLink, String string) {
        String string2 = partnerLink.getAttribute((Attribute)new StringAttribute(string));
        return this.myOldName.equals(string2);
    }

    private void rename(Variable variable, Named named) {
        if (named instanceof GlobalElement) {
            variable.setElement(variable.createSchemaReference((ReferenceableSchemaComponent)((GlobalElement)named), GlobalElement.class));
        } else if (named instanceof GlobalType) {
            variable.setType(variable.createSchemaReference((ReferenceableSchemaComponent)((GlobalType)named), GlobalType.class));
        } else if (named instanceof Message) {
            variable.setMessageType(variable.createWSDLReference((ReferenceableWSDLComponent)((Message)named), Message.class));
        }
    }

    private void rename(Catch catch_, Named named) throws IOException {
        if (named instanceof Fault) {
            this.renameFaultNameReference((FaultNameReference)catch_, named);
        } else if (named instanceof GlobalElement) {
            catch_.setFaultElement(catch_.createSchemaReference((ReferenceableSchemaComponent)((GlobalElement)named), GlobalElement.class));
        } else if (named instanceof Message) {
            catch_.setFaultMessageType(catch_.createWSDLReference((ReferenceableWSDLComponent)((Message)named), Message.class));
        }
    }

    private void rename(Reply reply, Named named) throws IOException {
        if (named instanceof Fault) {
            this.renameFaultNameReference((FaultNameReference)reply, named);
        }
    }

    private void rename(Throw throw_, Named named) throws IOException {
        if (named instanceof Fault) {
            this.renameFaultNameReference((FaultNameReference)throw_, named);
        }
    }

    private void renameFaultNameReference(FaultNameReference faultNameReference, Named named) throws IOException {
        try {
            faultNameReference.setFaultName(this.getQName(faultNameReference.getFaultName(), named));
        }
        catch (VetoException vetoException) {
            throw new IOException(vetoException.getMessage());
        }
    }

    private QName getQName(QName qName, Named named) {
        if (qName == null) {
            return null;
        }
        return new QName(qName.getNamespaceURI(), named.getName(), qName.getPrefix());
    }

    private static final class StringAttribute
    implements Attribute {
        private String myName;

        public StringAttribute(String string) {
            this.myName = string;
        }

        public Class getType() {
            return String.class;
        }

        public String getName() {
            return this.myName;
        }

        public Class getMemberType() {
            return null;
        }
    }
}

