/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.tools.apt.Main;
import com.sun.tools.ws.ToolVersion;
import com.sun.tools.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceAP;
import com.sun.tools.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.ws.wscompile.JavaCompilerHelper;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.WsgenOptions;
import com.sun.tools.ws.wscompile.WsimportListener;
import com.sun.tools.xjc.util.NullStream;
import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.TypedXmlWriter;
import com.sun.xml.txw2.annotation.XmlAttribute;
import com.sun.xml.txw2.annotation.XmlElement;
import com.sun.xml.txw2.output.StreamSerializer;
import com.sun.xml.txw2.output.XmlSerializer;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.RuntimeModeler;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.wsdl.writer.WSDLGenerator;
import com.sun.xml.ws.wsdl.writer.WSDLResolver;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Holder;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsgenTool
implements AnnotationProcessorFactory {
    private final PrintStream out;
    private final WsgenOptions options = new WsgenOptions();
    private AnnotationProcessorContext context;
    private final Container container;
    private WebServiceAP webServiceAP;
    private int round = 0;
    static final Collection<String> supportedOptions = Collections.unmodifiableSet(new HashSet());
    static final Collection<String> supportedAnnotations;

    public WsgenTool(OutputStream out, Container container) {
        this.out = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
        this.container = container;
    }

    public WsgenTool(OutputStream out) {
        this(out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String[] args) {
        Listener listener = new Listener();
        for (String arg : args) {
            if (!arg.equals("-version")) continue;
            listener.message(ToolVersion.VERSION.BUILD_VERSION);
            return true;
        }
        try {
            this.options.parseArguments(args);
            this.options.validate();
            if (!this.buildModel(this.options.endpoint.getName(), listener)) {
                boolean arr$ = false;
                return arr$;
            }
        }
        catch (Options.WeAreDone done) {
            this.usage(done.getOptions());
        }
        catch (BadCommandLineException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
                System.out.println();
            }
            this.usage(e.getOptions());
            boolean bl = false;
            return bl;
        }
        catch (AbortException abortException) {
        }
        finally {
            if (!this.options.keep) {
                this.options.removeGeneratedFiles();
            }
        }
        return true;
    }

    private void workAroundJavacDebug() {
        block2: {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                final Class<?> aptMain = cl.loadClass("com.sun.tools.apt.main.Main");
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        block4: {
                            try {
                                Field forcedOpts = aptMain.getDeclaredField("forcedOpts");
                                forcedOpts.setAccessible(true);
                                forcedOpts.set(null, new String[0]);
                            }
                            catch (NoSuchFieldException e) {
                                if (((WsgenTool)WsgenTool.this).options.verbose) {
                                    e.printStackTrace();
                                }
                            }
                            catch (IllegalAccessException e) {
                                if (!((WsgenTool)WsgenTool.this).options.verbose) break block4;
                                e.printStackTrace();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (ClassNotFoundException e) {
                if (!this.options.verbose) break block2;
                e.printStackTrace();
            }
        }
    }

    public boolean buildModel(String endpoint, Listener listener) throws BadCommandLineException {
        final ErrorReceiverFilter errReceiver = new ErrorReceiverFilter(listener);
        this.context = new AnnotationProcessorContext();
        this.webServiceAP = new WebServiceAP(this.options, this.context, errReceiver, this.out);
        String[] args = new String[]{"-d", this.options.destDir.getAbsolutePath(), "-classpath", this.options.classpath, "-s", this.options.sourceDir.getAbsolutePath(), "-XclassesAsDecls", endpoint, "-Xbootclasspath/p:" + JavaCompilerHelper.getJarFile(EndpointReference.class) + File.pathSeparator + JavaCompilerHelper.getJarFile(XmlSeeAlso.class)};
        this.workAroundJavacDebug();
        int result = Main.process((AnnotationProcessorFactory)this, (String[])args);
        if (result != 0) {
            this.out.println(WscompileMessages.WSCOMPILE_ERROR(WscompileMessages.WSCOMPILE_COMPILATION_FAILED()));
            return false;
        }
        if (this.options.genWsdl) {
            Class<?> endpointClass;
            String tmpPath = this.options.destDir.getAbsolutePath() + File.pathSeparator + this.options.classpath;
            URLClassLoader classLoader = new URLClassLoader(Options.pathToURLs(tmpPath), this.getClass().getClassLoader());
            try {
                endpointClass = classLoader.loadClass(endpoint);
            }
            catch (ClassNotFoundException e) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_CLASS_NOT_FOUND(endpoint));
            }
            BindingID bindingID = WsgenOptions.getBindingID(this.options.protocol);
            if (!this.options.protocolSet) {
                bindingID = BindingID.parse(endpointClass);
            }
            RuntimeModeler rtModeler = new RuntimeModeler(endpointClass, this.options.serviceName, bindingID);
            rtModeler.setClassLoader(classLoader);
            if (this.options.portName != null) {
                rtModeler.setPortName(this.options.portName);
            }
            AbstractSEIModelImpl rtModel = rtModeler.buildRuntimeModel();
            final File[] wsdlFileName = new File[1];
            final HashMap<String, File> schemaFiles = new HashMap<String, File>();
            WebServiceFeatureList wsfeatures = new WebServiceFeatureList(endpointClass);
            WSDLGenerator wsdlGenerator = new WSDLGenerator(rtModel, new WSDLResolver(){

                private File toFile(String suggestedFilename) {
                    return new File(((WsgenTool)WsgenTool.this).options.nonclassDestDir, suggestedFilename);
                }

                private Result toResult(File file) {
                    StreamResult result;
                    try {
                        result = new StreamResult(new FileOutputStream(file));
                        result.setSystemId(file.getPath().replace('\\', '/'));
                    }
                    catch (FileNotFoundException e) {
                        errReceiver.error(e);
                        return null;
                    }
                    return result;
                }

                @Override
                public Result getWSDL(String suggestedFilename) {
                    File f;
                    wsdlFileName[0] = f = this.toFile(suggestedFilename);
                    return this.toResult(f);
                }

                public Result getSchemaOutput(String namespace, String suggestedFilename) {
                    if (namespace.equals("")) {
                        return null;
                    }
                    File f = this.toFile(suggestedFilename);
                    schemaFiles.put(namespace, f);
                    return this.toResult(f);
                }

                @Override
                public Result getAbstractWSDL(Holder<String> filename) {
                    return this.toResult(this.toFile((String)filename.value));
                }

                @Override
                public Result getSchemaOutput(String namespace, Holder<String> filename) {
                    return this.getSchemaOutput(namespace, (String)filename.value);
                }
            }, bindingID.createBinding(wsfeatures.toArray()), this.container, endpointClass, ServiceFinder.find(WSDLGeneratorExtension.class).toArray());
            wsdlGenerator.doGeneration();
            if (this.options.wsgenReport != null) {
                this.generateWsgenReport(endpointClass, rtModel, wsdlFileName[0], schemaFiles);
            }
        }
        return true;
    }

    private void generateWsgenReport(Class<?> endpointClass, AbstractSEIModelImpl rtModel, File wsdlFile, Map<String, File> schemaFiles) {
        try {
            ReportOutput.Report report = (ReportOutput.Report)TXW.create(ReportOutput.Report.class, (XmlSerializer)new StreamSerializer((OutputStream)new BufferedOutputStream(new FileOutputStream(this.options.wsgenReport))));
            report.wsdl(wsdlFile.getAbsolutePath());
            ReportOutput.writeQName(rtModel.getServiceQName(), report.service());
            ReportOutput.writeQName(rtModel.getPortName(), report.port());
            ReportOutput.writeQName(rtModel.getPortTypeName(), report.portType());
            report.implClass(endpointClass.getName());
            for (Map.Entry<String, File> e : schemaFiles.entrySet()) {
                ReportOutput.Schema s = report.schema();
                s.ns(e.getKey());
                s.location(e.getValue().getAbsolutePath());
            }
            report.commit();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    protected void usage(Options options) {
        System.out.println(WscompileMessages.WSGEN_HELP("WSGEN"));
        System.out.println(WscompileMessages.WSGEN_USAGE_EXAMPLES());
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> set, AnnotationProcessorEnvironment apEnv) {
        if (this.options.verbose) {
            apEnv.getMessager().printNotice("\tap round: " + ++this.round);
        }
        this.webServiceAP.init(apEnv);
        return this.webServiceAP;
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add("*");
        types.add("javax.jws.*");
        types.add("javax.jws.soap.*");
        supportedAnnotations = Collections.unmodifiableCollection(types);
    }

    class Listener
    extends WsimportListener {
        ConsoleErrorReporter cer;

        Listener() {
            this.cer = new ConsoleErrorReporter(WsgenTool.this.out == null ? new PrintStream((OutputStream)new NullStream()) : WsgenTool.this.out);
        }

        public void generatedFile(String fileName) {
            this.message(fileName);
        }

        public void message(String msg) {
            WsgenTool.this.out.println(msg);
        }

        public void error(SAXParseException exception) {
            this.cer.error(exception);
        }

        public void fatalError(SAXParseException exception) {
            this.cer.fatalError(exception);
        }

        public void warning(SAXParseException exception) {
            this.cer.warning(exception);
        }

        public void info(SAXParseException exception) {
            this.cer.info(exception);
        }
    }

    static class ReportOutput {
        ReportOutput() {
        }

        private static void writeQName(QName n, QualifiedName w) {
            w.uri(n.getNamespaceURI());
            w.localName(n.getLocalPart());
        }

        static interface Schema
        extends TypedXmlWriter {
            @XmlAttribute
            public void ns(String var1);

            @XmlAttribute
            public void location(String var1);
        }

        static interface QualifiedName
        extends TypedXmlWriter {
            @XmlAttribute
            public void uri(String var1);

            @XmlAttribute
            public void localName(String var1);
        }

        @XmlElement(value="report")
        static interface Report
        extends TypedXmlWriter {
            @XmlElement
            public void wsdl(String var1);

            @XmlElement
            public QualifiedName portType();

            @XmlElement
            public QualifiedName service();

            @XmlElement
            public QualifiedName port();

            @XmlElement
            public void implClass(String var1);

            @XmlElement
            public Schema schema();
        }
    }
}

