/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.dd.loaders.webbnd;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.websphere6.dd.beans.DDXmiConstants;
import org.netbeans.modules.j2ee.websphere6.dd.beans.EjbRefBindingsType;
import org.netbeans.modules.j2ee.websphere6.dd.beans.ResEnvRefBindingsType;
import org.netbeans.modules.j2ee.websphere6.dd.beans.ResRefBindingsType;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSWebBnd;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.SectionNodes;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.webbnd.PanelFactory;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.webbnd.WSWebBndDataObject;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class WSWebBndToolBarMVElement
extends ToolBarMultiViewElement
implements PropertyChangeListener,
DDXmiConstants {
    private static final Logger LOGGER = Logger.getLogger(WSWebBndToolBarMVElement.class.getName());
    private ToolBarDesignEditor comp;
    private SectionView view;
    private WSWebBndDataObject dObj;
    private PanelFactory factory;
    private RequestProcessor.Task repaintingTask;
    private boolean needInit = true;
    private Action addResRefAction;
    private Action removeResRefAction;
    private Action addEjbRefAction;
    private Action removeEjbRefAction;
    private Action addResEnvRefAction;
    private Action removeResEnvRefAction;
    private static final long serialVersionUID = 76123745399723L;
    private static final String WEBBND_MV_ID = "webbnd_multiview_design";

    public WSWebBndToolBarMVElement(WSWebBndDataObject wSWebBndDataObject) {
        super((XmlMultiViewDataObject)wSWebBndDataObject);
        this.dObj = wSWebBndDataObject;
        this.comp = new ToolBarDesignEditor();
        this.factory = new PanelFactory(this.comp, wSWebBndDataObject);
        this.addResRefAction = new AddResRefAction("Add New Resource Reference Binding..");
        this.removeResRefAction = new RemoveResRefAction("Remove This Binding");
        this.addEjbRefAction = new AddEjbRefAction("Add New Ejb Reference Binding..");
        this.removeEjbRefAction = new RemoveEjbRefAction("Remove This Binding");
        this.addResEnvRefAction = new AddResEnvRefAction("Add New Resource Env Reference Binding..");
        this.removeResEnvRefAction = new RemoveResEnvRefAction("Remove This Binding");
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WSWebBndToolBarMVElement.this.repaintView();
                    }
                });
            }
        });
    }

    private void repaintView() {
        this.view = new WSWebBndView(this.dObj);
        this.comp.setContentView((PanelView)this.view);
        Object object = this.comp.getLastActive();
        if (object != null) {
            this.view.openPanel(object);
        }
        this.view.checkValidity();
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public WSWebBndView getWebBndView() {
        return (WSWebBndView)this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        if (this.needInit) {
            this.repaintView();
            this.needInit = false;
        }
        this.comp.setContentView((PanelView)this.view);
        try {
            this.view.openPanel((Object)this.dObj.getWebBnd());
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
        }
        this.view.checkValidity();
    }

    public void componentOpened() {
        super.componentOpened();
        try {
            this.dObj.getWebBnd().addPropertyChangeListener(this);
        }
        catch (IOException iOException) {
            Object var1_2 = null;
        }
    }

    public void componentClosed() {
        super.componentClosed();
        try {
            this.dObj.getWebBnd().removePropertyChangeListener(this);
        }
        catch (IOException iOException) {
            Object var1_2 = null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (!this.dObj.isChangedFromUI() && (string = propertyChangeEvent.getPropertyName()).indexOf("WebApplicationBnd") > 0) {
            if (WEBBND_MV_ID.equals(this.dObj.getSelectedPerspective().preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    public Error validateView() {
        try {
            WSWebBnd wSWebBnd = this.dObj.getWebBnd();
            ResRefBindingsType[] resRefBindingsTypeArray = wSWebBnd.getResRefBindings();
            if (resRefBindingsTypeArray == null) {
                return null;
            }
            for (int i = 0; i < resRefBindingsTypeArray.length; ++i) {
                String string = resRefBindingsTypeArray[i].getBindingReference();
                if (string == null || string.length() == 0) {
                    Error.ErrorLocation errorLocation = new Error.ErrorLocation((Object)resRefBindingsTypeArray[i], "title");
                    return new Error(2, "Title", errorLocation);
                }
                for (int j = 0; j < resRefBindingsTypeArray.length; ++j) {
                    String string2 = resRefBindingsTypeArray[j].getBindingReference();
                    if (i == j || !string.equals(string2)) continue;
                    Error.ErrorLocation errorLocation = new Error.ErrorLocation((Object)resRefBindingsTypeArray[i], "title");
                    return new Error(0, 3, string, errorLocation);
                }
            }
            EjbRefBindingsType[] ejbRefBindingsTypeArray = wSWebBnd.getEjbRefBindings();
            if (ejbRefBindingsTypeArray == null) {
                return null;
            }
            for (int i = 0; i < ejbRefBindingsTypeArray.length; ++i) {
                String string = ejbRefBindingsTypeArray[i].getBindingReference();
                if (string == null || string.length() == 0) {
                    Error.ErrorLocation errorLocation = new Error.ErrorLocation((Object)ejbRefBindingsTypeArray[i], "title");
                    return new Error(2, "Title", errorLocation);
                }
                for (int j = 0; j < ejbRefBindingsTypeArray.length; ++j) {
                    String string3 = ejbRefBindingsTypeArray[j].getBindingReference();
                    if (i == j || !string.equals(string3)) continue;
                    Error.ErrorLocation errorLocation = new Error.ErrorLocation((Object)ejbRefBindingsTypeArray[i], "title");
                    return new Error(0, 3, string, errorLocation);
                }
            }
            ResEnvRefBindingsType[] resEnvRefBindingsTypeArray = wSWebBnd.getResEnvRefBindings();
            if (resEnvRefBindingsTypeArray == null) {
                return null;
            }
            for (int i = 0; i < resEnvRefBindingsTypeArray.length; ++i) {
                String string = resEnvRefBindingsTypeArray[i].getBindingReference();
                if (string == null || string.length() == 0) {
                    Error.ErrorLocation errorLocation = new Error.ErrorLocation((Object)resEnvRefBindingsTypeArray[i], "title");
                    return new Error(2, "Title", errorLocation);
                }
                for (int j = 0; j < resEnvRefBindingsTypeArray.length; ++j) {
                    String string4 = resEnvRefBindingsTypeArray[j].getBindingReference();
                    if (i == j || !string.equals(string4)) continue;
                    Error.ErrorLocation errorLocation = new Error.ErrorLocation((Object)resEnvRefBindingsTypeArray[i], "title");
                    return new Error(0, 3, string, errorLocation);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static class WSWebBndNode
    extends AbstractNode {
        WSWebBndNode() {
            super(Children.LEAF);
            this.setDisplayName("General Deployment Binding Information");
        }
    }

    private class WSWebBndView
    extends SectionView {
        private SectionContainer resrefsCont;
        private SectionContainer ejbrefsCont;
        private SectionContainer resenvrefsCont;
        private WSWebBnd webbnd;
        XmlMultiViewDataSynchronizer sync;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WSWebBndView(WSWebBndDataObject wSWebBndDataObject) {
            super((InnerPanelFactory)WSWebBndToolBarMVElement.this.factory);
            Children.Array array = new Children.Array();
            AbstractNode abstractNode = new AbstractNode((Children)array);
            try {
                this.webbnd = wSWebBndDataObject.getWebBnd();
                array.add(new Node[]{this.createWebBndAttrNode(), this.createResRefNode(), this.createEjbRefNode(), this.createResEnvRefNode()});
            }
            catch (IOException iOException) {
                System.out.println("ex=" + iOException);
                abstractNode.setDisplayName("Invalid WebBnd");
            }
            finally {
                this.setRoot((Node)abstractNode);
            }
        }

        private Node createWebBndAttrNode() {
            WSWebBndNode wSWebBndNode = new WSWebBndNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)wSWebBndNode, (Object)this.webbnd));
            return wSWebBndNode;
        }

        private Node createResRefNode() {
            ResRefBindingsType[] resRefBindingsTypeArray = this.webbnd.getResRefBindings();
            Children.Array array = new Children.Array();
            Node[] nodeArray = null;
            if (resRefBindingsTypeArray != null && resRefBindingsTypeArray.length > 0) {
                nodeArray = new Node[resRefBindingsTypeArray.length];
                for (int i = 0; i < resRefBindingsTypeArray.length; ++i) {
                    nodeArray[i] = new SectionNodes.ResRefNode();
                    nodeArray[i].setDisplayName("Binding Item #" + (i + 1));
                }
                array.add(nodeArray);
            }
            SectionContainerNode sectionContainerNode = new SectionContainerNode((Children)array);
            sectionContainerNode.setDisplayName("Resource Reference Bindings");
            this.resrefsCont = new SectionContainer((SectionView)this, (Node)sectionContainerNode, "Resource Reference Bindings");
            this.resrefsCont.setHeaderActions(new Action[]{WSWebBndToolBarMVElement.this.addResRefAction});
            if (resRefBindingsTypeArray != null) {
                SectionPanel[] sectionPanelArray = new SectionPanel[resRefBindingsTypeArray.length];
                for (int i = 0; i < resRefBindingsTypeArray.length; ++i) {
                    sectionPanelArray[i] = new SectionPanel((SectionView)this, nodeArray[i], (Object)resRefBindingsTypeArray[i]);
                    sectionPanelArray[i].setHeaderActions(new Action[]{WSWebBndToolBarMVElement.this.removeResRefAction});
                    this.resrefsCont.addSection((NodeSectionPanel)sectionPanelArray[i]);
                }
            }
            this.addSection((NodeSectionPanel)this.resrefsCont);
            return sectionContainerNode;
        }

        private Node createEjbRefNode() {
            EjbRefBindingsType[] ejbRefBindingsTypeArray = this.webbnd.getEjbRefBindings();
            Children.Array array = new Children.Array();
            Node[] nodeArray = null;
            if (ejbRefBindingsTypeArray != null && ejbRefBindingsTypeArray.length > 0) {
                nodeArray = new Node[ejbRefBindingsTypeArray.length];
                for (int i = 0; i < ejbRefBindingsTypeArray.length; ++i) {
                    nodeArray[i] = new SectionNodes.EjbRefNode();
                    nodeArray[i].setDisplayName("Binding Item #" + (i + 1));
                }
                array.add(nodeArray);
            }
            SectionContainerNode sectionContainerNode = new SectionContainerNode((Children)array);
            sectionContainerNode.setDisplayName("Ejb Reference Bindings");
            this.ejbrefsCont = new SectionContainer((SectionView)this, (Node)sectionContainerNode, "Ejb Reference Bindings");
            this.ejbrefsCont.setHeaderActions(new Action[]{WSWebBndToolBarMVElement.this.addEjbRefAction});
            if (ejbRefBindingsTypeArray != null) {
                SectionPanel[] sectionPanelArray = new SectionPanel[ejbRefBindingsTypeArray.length];
                for (int i = 0; i < ejbRefBindingsTypeArray.length; ++i) {
                    sectionPanelArray[i] = new SectionPanel((SectionView)this, nodeArray[i], (Object)ejbRefBindingsTypeArray[i]);
                    sectionPanelArray[i].setHeaderActions(new Action[]{WSWebBndToolBarMVElement.this.removeEjbRefAction});
                    this.ejbrefsCont.addSection((NodeSectionPanel)sectionPanelArray[i]);
                }
            }
            this.addSection((NodeSectionPanel)this.ejbrefsCont);
            return sectionContainerNode;
        }

        private Node createResEnvRefNode() {
            ResEnvRefBindingsType[] resEnvRefBindingsTypeArray = this.webbnd.getResEnvRefBindings();
            Children.Array array = new Children.Array();
            Node[] nodeArray = null;
            if (resEnvRefBindingsTypeArray != null && resEnvRefBindingsTypeArray.length > 0) {
                nodeArray = new Node[resEnvRefBindingsTypeArray.length];
                for (int i = 0; i < resEnvRefBindingsTypeArray.length; ++i) {
                    nodeArray[i] = new SectionNodes.ResEnvRefNode();
                    nodeArray[i].setDisplayName("Binding Item #" + (i + 1));
                }
                array.add(nodeArray);
            }
            SectionContainerNode sectionContainerNode = new SectionContainerNode((Children)array);
            sectionContainerNode.setDisplayName("Resource Env Reference Bindings");
            this.resenvrefsCont = new SectionContainer((SectionView)this, (Node)sectionContainerNode, "Resource Env Reference Bindings");
            this.resenvrefsCont.setHeaderActions(new Action[]{WSWebBndToolBarMVElement.this.addResEnvRefAction});
            if (resEnvRefBindingsTypeArray != null) {
                SectionPanel[] sectionPanelArray = new SectionPanel[resEnvRefBindingsTypeArray.length];
                for (int i = 0; i < resEnvRefBindingsTypeArray.length; ++i) {
                    sectionPanelArray[i] = new SectionPanel((SectionView)this, nodeArray[i], (Object)resEnvRefBindingsTypeArray[i]);
                    sectionPanelArray[i].setHeaderActions(new Action[]{WSWebBndToolBarMVElement.this.removeResEnvRefAction});
                    this.resenvrefsCont.addSection((NodeSectionPanel)sectionPanelArray[i]);
                }
            }
            this.addSection((NodeSectionPanel)this.resenvrefsCont);
            return sectionContainerNode;
        }

        public SectionContainer getResRefsContainer() {
            return this.resrefsCont;
        }

        public SectionContainer getEjbRefsContainer() {
            return this.ejbrefsCont;
        }

        public SectionContainer getResEnvRefsContainer() {
            return this.resenvrefsCont;
        }
    }

    private class RemoveResEnvRefAction
    extends AbstractAction {
        RemoveResEnvRefAction(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            SectionPanel sectionPanel = ((SectionPanel.HeaderButton)actionEvent.getSource()).getSectionPanel();
            ResEnvRefBindingsType resEnvRefBindingsType = (ResEnvRefBindingsType)sectionPanel.getKey();
            try {
                WSWebBndToolBarMVElement.this.dObj.modelUpdatedFromUI();
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSWebBndToolBarMVElement.this.dObj.getWebBnd().removeResEnvRefBindings(resEnvRefBindingsType);
                sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
            }
            catch (IOException iOException) {
            }
            finally {
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
        }
    }

    private class AddResEnvRefAction
    extends AbstractAction {
        AddResEnvRefAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                WSWebBnd wSWebBnd = WSWebBndToolBarMVElement.this.dObj.getWebBnd();
                ResEnvRefBindingsType resEnvRefBindingsType = new ResEnvRefBindingsType("WebApplication");
                resEnvRefBindingsType.setDefaults();
                int n = wSWebBnd.getResEnvRefBindings().length + 1;
                wSWebBnd.addResEnvRefBindings(resEnvRefBindingsType);
                SectionNodes.ResEnvRefNode resEnvRefNode = new SectionNodes.ResEnvRefNode();
                WSWebBndToolBarMVElement.this.view.getRoot().getChildren().add(new Node[]{resEnvRefNode});
                resEnvRefNode.setDisplayName(resEnvRefNode.getDisplayName() + n);
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSWebBndToolBarMVElement.this.dObj.modelUpdatedFromUI();
                SectionPanel sectionPanel = new SectionPanel(WSWebBndToolBarMVElement.this.view, (Node)resEnvRefNode, (Object)resEnvRefBindingsType);
                sectionPanel.setHeaderActions(new Action[]{WSWebBndToolBarMVElement.this.removeResEnvRefAction});
                ((WSWebBndView)WSWebBndToolBarMVElement.this.view).getResEnvRefsContainer().addSection((NodeSectionPanel)sectionPanel, true);
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private class RemoveEjbRefAction
    extends AbstractAction {
        RemoveEjbRefAction(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            SectionPanel sectionPanel = ((SectionPanel.HeaderButton)actionEvent.getSource()).getSectionPanel();
            EjbRefBindingsType ejbRefBindingsType = (EjbRefBindingsType)sectionPanel.getKey();
            try {
                WSWebBndToolBarMVElement.this.dObj.modelUpdatedFromUI();
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSWebBndToolBarMVElement.this.dObj.getWebBnd().removeEjbRefBindings(ejbRefBindingsType);
                sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
            }
            catch (IOException iOException) {
            }
            finally {
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
        }
    }

    private class AddEjbRefAction
    extends AbstractAction {
        AddEjbRefAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSWebBnd wSWebBnd = WSWebBndToolBarMVElement.this.dObj.getWebBnd();
                EjbRefBindingsType ejbRefBindingsType = new EjbRefBindingsType("WebApplication");
                ejbRefBindingsType.setDefaults();
                int n = wSWebBnd.getEjbRefBindings().length + 1;
                wSWebBnd.addEjbRefBindings(ejbRefBindingsType);
                SectionNodes.EjbRefNode ejbRefNode = new SectionNodes.EjbRefNode();
                Node node = WSWebBndToolBarMVElement.this.view.getRoot();
                node.getChildren().add(new Node[]{ejbRefNode});
                ejbRefNode.setDisplayName(ejbRefNode.getDisplayName() + n);
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSWebBndToolBarMVElement.this.dObj.modelUpdatedFromUI();
                SectionPanel sectionPanel = new SectionPanel(WSWebBndToolBarMVElement.this.view, (Node)ejbRefNode, (Object)ejbRefBindingsType);
                sectionPanel.setHeaderActions(new Action[]{WSWebBndToolBarMVElement.this.removeEjbRefAction});
                ((WSWebBndView)WSWebBndToolBarMVElement.this.view).getEjbRefsContainer().addSection((NodeSectionPanel)sectionPanel, true);
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.log(Level.INFO, null, illegalArgumentException);
            }
        }
    }

    private class RemoveResRefAction
    extends AbstractAction {
        RemoveResRefAction(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            SectionPanel sectionPanel = ((SectionPanel.HeaderButton)actionEvent.getSource()).getSectionPanel();
            ResRefBindingsType resRefBindingsType = (ResRefBindingsType)sectionPanel.getKey();
            try {
                WSWebBndToolBarMVElement.this.dObj.modelUpdatedFromUI();
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSWebBndToolBarMVElement.this.dObj.getWebBnd().removeResRefBindings(resRefBindingsType);
                sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
            }
            catch (IOException iOException) {
            }
            finally {
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
        }
    }

    private class AddResRefAction
    extends AbstractAction {
        AddResRefAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSWebBnd wSWebBnd = WSWebBndToolBarMVElement.this.dObj.getWebBnd();
                ResRefBindingsType resRefBindingsType = new ResRefBindingsType("WebApplication");
                resRefBindingsType.setDefaults();
                int n = wSWebBnd.getResRefBindings().length + 1;
                wSWebBnd.addResRefBindings(resRefBindingsType);
                SectionNodes.ResRefNode resRefNode = new SectionNodes.ResRefNode();
                WSWebBndToolBarMVElement.this.view.getRoot().getChildren().add(new Node[]{resRefNode});
                resRefNode.setDisplayName(resRefNode.getDisplayName() + n);
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSWebBndToolBarMVElement.this.dObj.modelUpdatedFromUI();
                SectionPanel sectionPanel = new SectionPanel(WSWebBndToolBarMVElement.this.view, (Node)resRefNode, (Object)resRefBindingsType);
                sectionPanel.setHeaderActions(new Action[]{WSWebBndToolBarMVElement.this.removeResRefAction});
                ((WSWebBndView)WSWebBndToolBarMVElement.this.view).getResRefsContainer().addSection((NodeSectionPanel)sectionPanel, true);
                WSWebBndToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

