/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.wseditor.support;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.core.wseditor.spi.WSEditor;
import org.netbeans.modules.websvc.core.wseditor.spi.WSEditorProvider;
import org.netbeans.modules.websvc.core.wseditor.spi.WSEditorProviderRegistry;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookie;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public class EditWSAttributesCookieImpl
implements EditWSAttributesCookie {
    private Set<WSEditorProvider> providers;
    private Set<WSEditor> editors;
    private static Map<EditWSAttributesCookie, EditWSAttributesPanel> cachedTopComponents = new WeakHashMap<EditWSAttributesCookie, EditWSAttributesPanel>();
    private EditWSAttributesPanel tc;
    private Node node;
    private JaxWsModel jaxWsModel;
    private DialogWindowListener windowListener;

    public EditWSAttributesCookieImpl(Node node, JaxWsModel jaxWsModel) {
        this.node = node;
        this.jaxWsModel = jaxWsModel;
    }

    public void openWSAttributesEditor() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.openEditor();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditWSAttributesCookieImpl.this.openEditor();
                }
            });
        }
    }

    private void openEditor() {
        JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
        Cursor cursor = jFrame.getGlassPane().getCursor();
        jFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        jFrame.getGlassPane().setVisible(true);
        this.tc = cachedTopComponents.get(this.node);
        if (this.tc == null) {
            this.populateWSEditorProviderRegistry();
            this.providers = WSEditorProviderRegistry.getDefault().getEditorProviders();
            this.tc = new EditWSAttributesPanel();
            cachedTopComponents.put(this, this.tc);
        }
        this.populatePanels();
        this.tc.addTabs(this.editors, this.node, this.jaxWsModel);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.tc, this.node.getName());
        dialogDescriptor.setHelpCtx(new HelpCtx(EditWSAttributesCookieImpl.class));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(dialog.getTitle());
        dialog.setVisible(true);
        jFrame.getGlassPane().setCursor(cursor);
        jFrame.getGlassPane().setVisible(false);
        if (dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION) {
            for (WSEditor wSEditor : this.editors) {
                wSEditor.save(this.node, this.jaxWsModel);
            }
        } else {
            for (WSEditor wSEditor : this.editors) {
                wSEditor.cancel(this.node, this.jaxWsModel);
            }
        }
    }

    public Set getWSEditorProviders() {
        return this.providers;
    }

    private void populatePanels() {
        this.editors = new HashSet<WSEditor>();
        for (WSEditorProvider wSEditorProvider : this.providers) {
            if (!wSEditorProvider.enable(this.node)) continue;
            WSEditor wSEditor = wSEditorProvider.createWSEditor();
            this.editors.add(wSEditor);
        }
    }

    private void populateWSEditorProviderRegistry() {
        WSEditorProviderRegistry wSEditorProviderRegistry = WSEditorProviderRegistry.getDefault();
        if (wSEditorProviderRegistry.getEditorProviders().isEmpty()) {
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(WSEditorProvider.class));
            Collection collection = result.allInstances();
            for (WSEditorProvider wSEditorProvider : collection) {
                wSEditorProviderRegistry.register(wSEditorProvider);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DialogWindowListener
    extends WindowAdapter {
        Set<WSEditor> editors;

        public DialogWindowListener(Set<WSEditor> set) {
            this.editors = set;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            for (WSEditor wSEditor : this.editors) {
                wSEditor.cancel(EditWSAttributesCookieImpl.this.node, EditWSAttributesCookieImpl.this.jaxWsModel);
            }
        }
    }
}

