/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public class JaxWsSourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation {
    private final Map<URL, SourceForBinaryQuery.Result> cache = new HashMap<URL, SourceForBinaryQuery.Result>();
    private Project project;
    private boolean jarArtifactsSetCreated;
    private Set<URI> jarArtifacts = new HashSet<URI>();

    JaxWsSourceForBinaryQueryImpl(Project project) {
        this.project = project;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL uRL) {
        File file = FileUtil.archiveOrDirForURL((URL)uRL);
        if (file != null) {
            boolean bl = false;
            try {
                if (!this.jarArtifactsSetCreated) {
                    this.createJarArtifactsSet();
                    this.jarArtifactsSetCreated = true;
                }
                if (this.jarArtifacts.contains(file.toURI())) {
                    bl = true;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.getLogger(JaxWsSourceForBinaryQueryImpl.class.getName()).log(Level.INFO, "Cannot resolve JAR Artifact file", uRISyntaxException);
            }
            catch (IOException iOException) {
                Logger.getLogger(JaxWsSourceForBinaryQueryImpl.class.getName()).log(Level.INFO, "Cannot resolve JAR Artifact file", iOException);
            }
            if (bl) {
                JAXWSClientSupport jAXWSClientSupport;
                Project project;
                SourceForBinaryQuery.Result result = this.cache.get(uRL);
                if (result == null && (project = FileOwnerQuery.getOwner((URI)file.toURI())) != null && (jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)project.getProjectDirectory())) != null) {
                    result = new Result(project);
                    this.cache.put(uRL, result);
                }
                return result;
            }
        }
        return null;
    }

    private void createJarArtifactsSet() throws FileStateInvalidException, URISyntaxException {
        BinaryForSourceQuery.Result result;
        BinaryForSourceQuery.Result result2;
        AntArtifactProvider antArtifactProvider = (AntArtifactProvider)this.project.getLookup().lookup(AntArtifactProvider.class);
        if (antArtifactProvider != null) {
            result = result2 = antArtifactProvider.getBuildArtifacts();
            int n = ((AntArtifact[])result).length;
            for (int i = 0; i < n; ++i) {
                AntArtifact antArtifact = result[i];
                if (!"jar".equals(antArtifact.getType())) continue;
                File serializable = antArtifact.getScriptLocation();
                for (URI uRI : antArtifact.getArtifactLocations()) {
                    URI uRI2 = serializable.toURI().resolve(uRI).normalize();
                    this.jarArtifacts.add(uRI2);
                }
            }
        }
        if ((result2 = ProjectUtils.getSources((Project)this.project).getSourceGroups("java")) != null && ((AntArtifact[])result2).length > 0 && (result = BinaryForSourceQuery.findBinaryRoots((URL)result2[0].getRootFolder().getURL())) != null) {
            for (URL uRL : result.getRoots()) {
                this.jarArtifacts.add(uRL.toURI());
            }
        }
    }

    private class Result
    implements SourceForBinaryQuery.Result {
        private Project prj;

        public Result(Project project) {
            this.prj = project;
        }

        public FileObject[] getRoots() {
            FileObject[] fileObjectArray;
            FileObject fileObject = this.prj.getProjectDirectory().getFileObject("build/generated/wsimport/client");
            if (fileObject == null) {
                fileObjectArray = new FileObject[]{};
            } else {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = fileObject;
            }
            return fileObjectArray;
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }
}

