/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.element.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.cnd.gotodeclaration.element.spi.ElementDescriptor;
import org.netbeans.modules.cnd.gotodeclaration.element.ui.GoToElementAction;
import org.netbeans.modules.cnd.gotodeclaration.element.ui.GoToElementOptions;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class GoToElementPanel
extends JPanel {
    private static final int BRIGHTER_COLOR_COMPONENT = 10;
    private ContentProvider contentProvider;
    private boolean containsScrollPane;
    private JLabel messageLabel;
    long time = -1L;
    private JCheckBox caseSensitive;
    private JLabel jLabelList;
    private JLabel jLabelLocation;
    private JLabel jLabelText;
    private JTextField jTextFieldLocation;
    private JPanel listPanel;
    private JList matchesList;
    private JScrollPane matchesScrollPane1;
    private JTextField nameField;

    public GoToElementPanel(ContentProvider contentProvider) throws IOException {
        this.contentProvider = contentProvider;
        this.initComponents();
        this.containsScrollPane = true;
        this.matchesList.setSelectionMode(0);
        Color color = new Color(Math.min(this.getBackground().getRed() + 10, 255), Math.min(this.getBackground().getGreen() + 10, 255), Math.min(this.getBackground().getBlue() + 10, 255));
        this.messageLabel = new JLabel();
        this.messageLabel.setBackground(color);
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setEnabled(true);
        this.messageLabel.setText(NbBundle.getMessage(GoToElementPanel.class, (String)"TXT_NoElementsFound"));
        this.messageLabel.setFont(this.matchesList.getFont());
        this.matchesList.setCellRenderer(contentProvider.getListCellRenderer(this.matchesList));
        contentProvider.setListModel(this, null);
        PatternListener patternListener = new PatternListener(this);
        this.nameField.getDocument().addDocumentListener(patternListener);
        this.caseSensitive.setSelected(GoToElementOptions.GoToElementDialog.getCaseSensitive());
        this.caseSensitive.addItemListener(patternListener);
        this.matchesList.addListSelectionListener(patternListener);
    }

    public void setModel(final ListModel listModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (listModel.getSize() > 0 || GoToElementPanel.this.getText() == null || GoToElementPanel.this.getText().trim().length() == 0) {
                    GoToElementPanel.this.matchesList.setModel(listModel);
                    GoToElementPanel.this.matchesList.setSelectedIndex(0);
                    GoToElementPanel.this.setListPanelContent(null);
                    if (GoToElementPanel.this.time != -1L) {
                        if (GoToElementAction.TRACE) {
                            System.err.printf("Real search time: %d ms", System.currentTimeMillis() - GoToElementPanel.this.time);
                        }
                        GoToElementPanel.this.time = -1L;
                    }
                } else {
                    GoToElementPanel.this.setListPanelContent(NbBundle.getMessage(GoToElementPanel.class, (String)"TXT_NoElementsFound"));
                }
            }
        });
    }

    public void setInitialText(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string2 = GoToElementPanel.this.nameField.getText();
                if (string2 == null || string2.trim().length() == 0) {
                    GoToElementPanel.this.nameField.setText(string);
                    GoToElementPanel.this.nameField.setCaretPosition(string.length());
                    GoToElementPanel.this.nameField.setSelectionStart(0);
                    GoToElementPanel.this.nameField.setSelectionEnd(string.length());
                }
            }
        });
    }

    public void openSelectedItem() {
        ElementDescriptor elementDescriptor = (ElementDescriptor)this.matchesList.getSelectedValue();
        if (elementDescriptor != null) {
            ((ElementDescriptor)this.matchesList.getSelectedValue()).open();
        }
    }

    private void initComponents() {
        this.jLabelText = new JLabel();
        this.nameField = new JTextField();
        this.jLabelList = new JLabel();
        this.listPanel = new JPanel();
        this.matchesScrollPane1 = new JScrollPane();
        this.matchesList = new JList();
        this.caseSensitive = new JCheckBox();
        this.jLabelLocation = new JLabel();
        this.jTextFieldLocation = new JTextField();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setFocusable(false);
        this.setNextFocusableComponent(this.nameField);
        this.setLayout(new GridBagLayout());
        this.jLabelText.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.jLabelText, (String)NbBundle.getMessage(GoToElementPanel.class, (String)"TXT_GoToElement_ElementName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.jLabelText, gridBagConstraints);
        this.nameField.setBorder(BorderFactory.createEtchedBorder());
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GoToElementPanel.this.nameFieldActionPerformed(actionEvent);
            }
        });
        this.nameField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                GoToElementPanel.this.nameFieldKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                GoToElementPanel.this.nameFieldKeyReleased(keyEvent);
            }

            public void keyTyped(KeyEvent keyEvent) {
                GoToElementPanel.this.nameFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.nameField, gridBagConstraints);
        this.jLabelList.setLabelFor(this.matchesScrollPane1);
        this.jLabelList.setText(NbBundle.getMessage(GoToElementPanel.class, (String)"TXT_GoToElement_MatchesList_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.jLabelList, gridBagConstraints);
        this.listPanel.setBorder(BorderFactory.createEtchedBorder());
        this.listPanel.setName("dataPanel");
        this.listPanel.setLayout(new BorderLayout());
        this.matchesScrollPane1.setBorder(null);
        this.matchesScrollPane1.setFocusable(false);
        this.matchesList.setFocusable(false);
        this.matchesList.setVisibleRowCount(15);
        this.matchesList.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                GoToElementPanel.this.matchesListMouseReleased(mouseEvent);
            }
        });
        this.matchesScrollPane1.setViewportView(this.matchesList);
        this.listPanel.add((Component)this.matchesScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.listPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.caseSensitive, (String)NbBundle.getMessage(GoToElementPanel.class, (String)"TXT_GoToElement_CaseSensitive"));
        this.caseSensitive.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.caseSensitive, gridBagConstraints);
        this.jLabelLocation.setText(NbBundle.getMessage(GoToElementPanel.class, (String)"LBL_GoToElement_LocationJLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.jLabelLocation, gridBagConstraints);
        this.jTextFieldLocation.setEditable(false);
        this.jTextFieldLocation.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jTextFieldLocation, gridBagConstraints);
    }

    private void matchesListMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.nameFieldActionPerformed(null);
        }
    }

    private void nameFieldKeyTyped(KeyEvent keyEvent) {
        if (this.boundScrollingKey(keyEvent)) {
            this.delegateScrollingKey(keyEvent);
        }
    }

    private void nameFieldKeyReleased(KeyEvent keyEvent) {
        if (this.boundScrollingKey(keyEvent)) {
            this.delegateScrollingKey(keyEvent);
        }
    }

    private void nameFieldKeyPressed(KeyEvent keyEvent) {
        if (this.boundScrollingKey(keyEvent)) {
            this.delegateScrollingKey(keyEvent);
        }
    }

    private void nameFieldActionPerformed(ActionEvent actionEvent) {
        if (this.contentProvider.hasValidContent()) {
            this.contentProvider.closeDialog();
            this.openSelectedItem();
        }
    }

    private String getText() {
        try {
            String string = this.nameField.getDocument().getText(0, this.nameField.getDocument().getLength());
            return string;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive.isSelected();
    }

    void setListPanelContent(String string) {
        if (string == null && !this.containsScrollPane) {
            this.listPanel.remove(this.messageLabel);
            this.listPanel.add(this.matchesScrollPane1);
            this.containsScrollPane = true;
            this.revalidate();
            this.repaint();
        } else if (string != null) {
            this.jTextFieldLocation.setText("");
            this.messageLabel.setText(string);
            if (this.containsScrollPane) {
                this.listPanel.remove(this.matchesScrollPane1);
                this.listPanel.add(this.messageLabel);
                this.containsScrollPane = false;
            }
            this.revalidate();
            this.repaint();
        }
    }

    private String listActionFor(KeyEvent keyEvent) {
        InputMap inputMap = this.matchesList.getInputMap();
        Object object = inputMap.get(KeyStroke.getKeyStrokeForEvent(keyEvent));
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    private boolean boundScrollingKey(KeyEvent keyEvent) {
        String string = this.listActionFor(keyEvent);
        return "selectPreviousRow".equals(string) || "selectNextRow".equals(string) || "scrollUp".equals(string) || "scrollDown".equals(string);
    }

    private void delegateScrollingKey(KeyEvent keyEvent) {
        String string = this.listActionFor(keyEvent);
        if ("selectNextRow".equals(string) && this.matchesList.getSelectedIndex() == this.matchesList.getModel().getSize() - 1) {
            this.matchesList.setSelectedIndex(0);
            this.matchesList.ensureIndexIsVisible(0);
            return;
        }
        if ("selectPreviousRow".equals(string) && this.matchesList.getSelectedIndex() == 0) {
            int n = this.matchesList.getModel().getSize() - 1;
            this.matchesList.setSelectedIndex(n);
            this.matchesList.ensureIndexIsVisible(n);
            return;
        }
        Action action = this.matchesList.getActionMap().get(string);
        if (action != null) {
            action.actionPerformed(new ActionEvent(this.matchesList, 0, string));
        }
    }

    public static interface ContentProvider {
        public ListCellRenderer getListCellRenderer(JList var1);

        public void setListModel(GoToElementPanel var1, String var2);

        public void closeDialog();

        public boolean hasValidContent();
    }

    private static class PatternListener
    implements DocumentListener,
    ItemListener,
    ListSelectionListener {
        private final GoToElementPanel dialog;

        PatternListener(GoToElementPanel goToElementPanel) {
            this.dialog = goToElementPanel;
        }

        PatternListener(DocumentEvent documentEvent, GoToElementPanel goToElementPanel) {
            this.dialog = goToElementPanel;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            GoToElementOptions.GoToElementDialog.setCaseSensitive(this.dialog.isCaseSensitive());
            this.update();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ElementDescriptor elementDescriptor = (ElementDescriptor)this.dialog.matchesList.getSelectedValue();
            if (elementDescriptor != null) {
                String string = elementDescriptor.getAbsoluteFileName();
                this.dialog.jTextFieldLocation.setText(string == null ? "" : string);
            } else {
                this.dialog.jTextFieldLocation.setText("");
            }
        }

        private void update() {
            this.dialog.time = System.currentTimeMillis();
            this.dialog.setListPanelContent(NbBundle.getMessage(GoToElementPanel.class, (String)"TXT_Searching"));
            this.dialog.contentProvider.setListModel(this.dialog, this.dialog.getText());
        }
    }
}

