/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMDeliveryAssurance;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMSequenceBinding;
import org.netbeans.modules.websvc.wsitmodelext.policy.All;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.rm.AckRequestInterval;
import org.netbeans.modules.websvc.wsitmodelext.rm.AllowDuplicates;
import org.netbeans.modules.websvc.wsitmodelext.rm.CloseTimeout;
import org.netbeans.modules.websvc.wsitmodelext.rm.DeliveryAssurance;
import org.netbeans.modules.websvc.wsitmodelext.rm.FlowControl;
import org.netbeans.modules.websvc.wsitmodelext.rm.InOrder;
import org.netbeans.modules.websvc.wsitmodelext.rm.InactivityTimeout;
import org.netbeans.modules.websvc.wsitmodelext.rm.MaxReceiveBufferSize;
import org.netbeans.modules.websvc.wsitmodelext.rm.Ordered;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMAssertion;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMMS13QName;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMMSQName;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMQName;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMSunClientQName;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMSunQName;
import org.netbeans.modules.websvc.wsitmodelext.rm.ResendInterval;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;

public class RMModelHelper {
    public static final String DEFAULT_INACT_TIMEOUT = "600000";
    public static final String DEFAULT_MAXRCVBUFFERSIZE = "32";
    public static final String DEFAULT_ACKINTERVAL = "200";
    private static HashMap<ConfigVersion, RMModelHelper> instances = new HashMap();
    private ConfigVersion configVersion = ConfigVersion.getDefault();

    private RMModelHelper(ConfigVersion configVersion) {
        this.configVersion = configVersion;
    }

    public static final synchronized RMModelHelper getInstance(ConfigVersion configVersion) {
        RMModelHelper rMModelHelper = instances.get(configVersion);
        if (rMModelHelper == null) {
            rMModelHelper = new RMModelHelper(configVersion);
            instances.put(configVersion, rMModelHelper);
        }
        return rMModelHelper;
    }

    private RMAssertion getRMAssertion(Policy policy) {
        return (RMAssertion)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, RMAssertion.class, false);
    }

    private RMAssertion getRMAssertion(Binding binding) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        return this.getRMAssertion(policy);
    }

    public boolean isRMEnabled(WSDLComponent wSDLComponent) {
        if (wSDLComponent instanceof Operation) {
            Operation operation = (Operation)wSDLComponent;
            Binding binding = (Binding)operation.getParent();
            return this.isRMEnabledB(binding);
        }
        if (wSDLComponent instanceof Binding) {
            return this.isRMEnabledB((Binding)wSDLComponent);
        }
        return false;
    }

    private boolean isRMEnabledB(Binding binding) {
        return this.getRMAssertion(binding) != null;
    }

    public void enableRM(Binding binding, boolean bl) {
        if (bl) {
            PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
            All all = policyModelHelper.createPolicy((WSDLComponent)binding, true);
            policyModelHelper.createElement((WSDLComponent)all, RMQName.RMASSERTION.getQName(this.configVersion), RMAssertion.class, false);
        } else {
            RMAssertion rMAssertion = this.getRMAssertion(binding);
            if (rMAssertion != null) {
                PolicyModelHelper.removeElement((WSDLComponent)rMAssertion.getParent(), RMAssertion.class, false);
            }
            this.enableOrdered(binding, false);
            this.enableFlowControl(binding, false);
            this.enableAllowDuplicates(binding, false);
            this.setSequenceBinding(binding, null);
            this.setInactivityTimeout(binding, null);
            RMModelHelper.setMaxReceiveBufferSize(binding, null);
            PolicyModelHelper.cleanPolicies((WSDLComponent)binding);
        }
    }

    public String getInactivityTimeout(Binding binding) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        RMAssertion rMAssertion = this.getRMAssertion(policy);
        return this.getInactivityTimeout(rMAssertion);
    }

    public void setInactivityTimeout(Binding binding, String string) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        if (string != null) {
            this.enableRM(binding, true);
        }
        RMAssertion rMAssertion = this.getRMAssertion(policy);
        this.setInactivityTimeout(rMAssertion, string);
    }

    private String getInactivityTimeout(RMAssertion rMAssertion) {
        String string = null;
        if (rMAssertion != null) {
            if (ConfigVersion.CONFIG_1_3.equals((Object)this.configVersion)) {
                List list = ((WSDLComponent)rMAssertion.getParent()).getExtensibilityElements(InactivityTimeout.class);
                if (list != null && list.size() > 0) {
                    string = ((InactivityTimeout)list.get(0)).getMilliseconds();
                }
            } else {
                List list = rMAssertion.getExtensibilityElements(InactivityTimeout.class);
                if (list != null && list.size() > 0) {
                    string = ((InactivityTimeout)list.get(0)).getMilliseconds();
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInactivityTimeout(RMAssertion rMAssertion, String string) {
        if (rMAssertion != null) {
            WSDLModel wSDLModel = rMAssertion.getModel();
            boolean bl = wSDLModel.isIntransaction();
            if (!bl) {
                wSDLModel.startTransaction();
            }
            try {
                if (ConfigVersion.CONFIG_1_3.equals((Object)this.configVersion)) {
                    InactivityTimeout inactivityTimeout = (InactivityTimeout)PolicyModelHelper.getTopLevelElement((WSDLComponent)rMAssertion.getParent(), InactivityTimeout.class, false);
                    if (string != null) {
                        if (inactivityTimeout == null) {
                            WSDLComponentFactory wSDLComponentFactory = rMAssertion.getModel().getFactory();
                            InactivityTimeout inactivityTimeout2 = null;
                            inactivityTimeout2 = (InactivityTimeout)wSDLComponentFactory.create((WSDLComponent)rMAssertion.getParent(), RMMS13QName.INACTIVITYTIMEOUT.getQName(this.configVersion));
                            inactivityTimeout2.setMilliseconds(string);
                            ((WSDLComponent)rMAssertion.getParent()).addExtensibilityElement((ExtensibilityElement)inactivityTimeout2);
                        } else {
                            inactivityTimeout.setMilliseconds(string);
                        }
                    } else if (inactivityTimeout != null) {
                        ((WSDLComponent)rMAssertion.getParent()).removeExtensibilityElement((ExtensibilityElement)inactivityTimeout);
                    }
                } else {
                    List list = rMAssertion.getExtensibilityElements(InactivityTimeout.class);
                    InactivityTimeout inactivityTimeout = null;
                    if (list != null && list.size() > 0) {
                        inactivityTimeout = (InactivityTimeout)list.get(0);
                    }
                    if (inactivityTimeout == null) {
                        if (string != null) {
                            WSDLComponentFactory wSDLComponentFactory = rMAssertion.getModel().getFactory();
                            InactivityTimeout inactivityTimeout3 = null;
                            inactivityTimeout3 = (InactivityTimeout)wSDLComponentFactory.create((WSDLComponent)rMAssertion, RMMS13QName.INACTIVITYTIMEOUT.getQName(this.configVersion));
                            inactivityTimeout3.setMilliseconds(string);
                            rMAssertion.addExtensibilityElement((ExtensibilityElement)inactivityTimeout3);
                        }
                    } else if (string == null) {
                        rMAssertion.removeExtensibilityElement(inactivityTimeout);
                    } else {
                        inactivityTimeout.setMilliseconds(string);
                    }
                }
            }
            finally {
                if (!bl) {
                    wSDLModel.endTransaction();
                }
            }
        }
    }

    public void enableFlowControl(Binding binding, boolean bl) {
        if (bl) {
            PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
            All all = policyModelHelper.createPolicy((WSDLComponent)binding, true);
            policyModelHelper.createElement((WSDLComponent)all, RMMSQName.RMFLOWCONTROL.getQName(), FlowControl.class, false);
        } else {
            Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
            FlowControl flowControl = RMModelHelper.getFlowControl(policy);
            if (flowControl != null) {
                PolicyModelHelper.removeElement((WSDLComponent)flowControl.getParent(), FlowControl.class, false);
            }
            PolicyModelHelper.cleanPolicies((WSDLComponent)binding);
        }
    }

    public static boolean isFlowControl(Binding binding) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        if (policy != null) {
            FlowControl flowControl = RMModelHelper.getFlowControl(policy);
            return flowControl != null;
        }
        return false;
    }

    public void enableAllowDuplicates(Binding binding, boolean bl) {
        if (bl) {
            assert (ConfigVersion.CONFIG_1_0.equals((Object)this.configVersion));
            PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
            All all = policyModelHelper.createPolicy((WSDLComponent)binding, true);
            policyModelHelper.createElement((WSDLComponent)all, RMSunQName.ALLOWDUPLICATES.getQName(), AllowDuplicates.class, false);
        } else {
            Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
            AllowDuplicates allowDuplicates = RMModelHelper.getAllowDuplicates(policy);
            if (allowDuplicates != null) {
                PolicyModelHelper.removeElement((WSDLComponent)allowDuplicates.getParent(), AllowDuplicates.class, false);
            }
            PolicyModelHelper.cleanPolicies((WSDLComponent)binding);
        }
    }

    public static boolean isAllowDuplicates(Binding binding) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        if (policy != null) {
            AllowDuplicates allowDuplicates = RMModelHelper.getAllowDuplicates(policy);
            return allowDuplicates != null;
        }
        return false;
    }

    public boolean isSequenceBinding(Binding binding, RMSequenceBinding rMSequenceBinding) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        if (policy != null) {
            RMAssertion rMAssertion = this.getRMAssertion(PolicyModelHelper.getPolicyForElement((WSDLComponent)binding));
            return PolicyModelHelper.getTopLevelElement((WSDLComponent)rMAssertion, rMSequenceBinding.getAssertionClass(), false) != null;
        }
        return false;
    }

    public boolean isDeliveryAssurance(Binding binding, RMDeliveryAssurance rMDeliveryAssurance) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        if (policy != null) {
            RMAssertion rMAssertion = this.getRMAssertion(PolicyModelHelper.getPolicyForElement((WSDLComponent)binding));
            DeliveryAssurance deliveryAssurance = (DeliveryAssurance)PolicyModelHelper.getTopLevelElement((WSDLComponent)rMAssertion, DeliveryAssurance.class, true);
            return PolicyModelHelper.getTopLevelElement((WSDLComponent)deliveryAssurance, rMDeliveryAssurance.getAssertionClass(), true) != null;
        }
        return false;
    }

    public void setSequenceBinding(Binding binding, RMSequenceBinding rMSequenceBinding) {
        PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
        RMAssertion rMAssertion = this.getRMAssertion(binding);
        if (rMSequenceBinding == null) {
            if (rMAssertion != null) {
                for (RMSequenceBinding rMSequenceBinding2 : RMSequenceBinding.values()) {
                    PolicyModelHelper.removeElement((WSDLComponent)rMAssertion, rMSequenceBinding2.getAssertionClass(), true);
                }
                PolicyModelHelper.cleanPolicies((WSDLComponent)binding);
            }
            return;
        }
        policyModelHelper.createElement((WSDLComponent)rMAssertion, rMSequenceBinding.getQName(), rMSequenceBinding.getAssertionClass(), true);
    }

    public void setDeliveryAssurance(Binding binding, RMDeliveryAssurance rMDeliveryAssurance) {
        PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
        RMAssertion rMAssertion = this.getRMAssertion(binding);
        if (rMDeliveryAssurance == null || RMDeliveryAssurance.getDefault().equals((Object)rMDeliveryAssurance)) {
            DeliveryAssurance deliveryAssurance = (DeliveryAssurance)PolicyModelHelper.getTopLevelElement((WSDLComponent)rMAssertion, DeliveryAssurance.class, true);
            if (deliveryAssurance != null) {
                for (RMDeliveryAssurance rMDeliveryAssurance2 : RMDeliveryAssurance.values()) {
                    PolicyModelHelper.removeElement((WSDLComponent)deliveryAssurance, rMDeliveryAssurance2.getAssertionClass(), true);
                }
                if (PolicyModelHelper.isEmpty((WSDLComponent)deliveryAssurance)) {
                    PolicyModelHelper.removeElement((WSDLComponent)rMAssertion, DeliveryAssurance.class, true);
                }
            }
            PolicyModelHelper.cleanPolicies((WSDLComponent)binding);
            return;
        }
        DeliveryAssurance deliveryAssurance = (DeliveryAssurance)policyModelHelper.createElement((WSDLComponent)rMAssertion, RMQName.DELIVERYASSURANCE.getQName(this.configVersion), DeliveryAssurance.class, true);
        policyModelHelper.createElement((WSDLComponent)deliveryAssurance, rMDeliveryAssurance.getQName(), rMDeliveryAssurance.getAssertionClass(), true);
    }

    public static void setMaxReceiveBufferSize(Binding binding, String string) {
        FlowControl flowControl = RMModelHelper.getFlowControl(binding);
        RMModelHelper.setMaxReceiveBufferSize(flowControl, string);
    }

    public static String getMaxReceiveBufferSize(Binding binding) {
        FlowControl flowControl = RMModelHelper.getFlowControl(binding);
        return RMModelHelper.getMaxReceiveBufferSize(flowControl);
    }

    private static FlowControl getFlowControl(Binding binding) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        return RMModelHelper.getFlowControl(policy);
    }

    private static FlowControl getFlowControl(Policy policy) {
        return (FlowControl)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, FlowControl.class, false);
    }

    private static String getMaxReceiveBufferSize(FlowControl flowControl) {
        MaxReceiveBufferSize maxReceiveBufferSize;
        String string = null;
        if (flowControl != null && (maxReceiveBufferSize = flowControl.getMaxReceiveBufferSize()) != null) {
            string = maxReceiveBufferSize.getMaxReceiveBufferSize();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setMaxReceiveBufferSize(FlowControl flowControl, String string) {
        if (flowControl != null) {
            WSDLModel wSDLModel = flowControl.getModel();
            boolean bl = wSDLModel.isIntransaction();
            if (!bl) {
                wSDLModel.startTransaction();
            }
            try {
                MaxReceiveBufferSize maxReceiveBufferSize = flowControl.getMaxReceiveBufferSize();
                if (maxReceiveBufferSize == null) {
                    if (string != null) {
                        WSDLComponentFactory wSDLComponentFactory = flowControl.getModel().getFactory();
                        MaxReceiveBufferSize maxReceiveBufferSize2 = (MaxReceiveBufferSize)wSDLComponentFactory.create((WSDLComponent)flowControl, RMMSQName.MAXRECEIVEBUFFERSIZE.getQName());
                        maxReceiveBufferSize2.setMaxReceiveBufferSize(string);
                        flowControl.addExtensibilityElement((ExtensibilityElement)maxReceiveBufferSize2);
                    }
                } else if (string == null) {
                    flowControl.removeMaxReceiveBufferSize(maxReceiveBufferSize);
                } else {
                    maxReceiveBufferSize.setMaxReceiveBufferSize(string);
                }
            }
            finally {
                if (!bl) {
                    wSDLModel.endTransaction();
                }
            }
        }
    }

    public void enableOrdered(Binding binding, boolean bl) {
        if (this.configVersion.equals((Object)ConfigVersion.CONFIG_1_0)) {
            if (bl) {
                PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
                All all = policyModelHelper.createPolicy((WSDLComponent)binding, true);
                policyModelHelper.createElement((WSDLComponent)all, RMSunQName.ORDERED.getQName(), Ordered.class, false);
            } else {
                Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
                Ordered ordered = this.getOrdered(policy);
                if (ordered != null) {
                    PolicyModelHelper.removeElement((WSDLComponent)ordered.getParent(), Ordered.class, false);
                }
                PolicyModelHelper.cleanPolicies((WSDLComponent)binding);
            }
        } else {
            PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
            Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
            RMAssertion rMAssertion = this.getRMAssertion(policy);
            if (bl) {
                DeliveryAssurance deliveryAssurance = (DeliveryAssurance)policyModelHelper.createElement((WSDLComponent)rMAssertion, RMQName.DELIVERYASSURANCE.getQName(this.configVersion), DeliveryAssurance.class, true);
                policyModelHelper.createElement((WSDLComponent)deliveryAssurance, RMQName.INORDER.getQName(this.configVersion), InOrder.class, true);
            } else if (rMAssertion != null) {
                DeliveryAssurance deliveryAssurance = this.getDeliveryAssurance(binding);
                if (deliveryAssurance != null) {
                    PolicyModelHelper.removeElement((WSDLComponent)deliveryAssurance, InOrder.class, true);
                }
                if (PolicyModelHelper.isEmpty((WSDLComponent)deliveryAssurance)) {
                    PolicyModelHelper.removeElement((WSDLComponent)rMAssertion, DeliveryAssurance.class, true);
                }
            }
        }
    }

    public boolean isOrderedEnabled(Binding binding) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        if (policy != null) {
            if (this.configVersion.equals((Object)ConfigVersion.CONFIG_1_0)) {
                Ordered ordered = this.getOrdered(policy);
                return ordered != null;
            }
            DeliveryAssurance deliveryAssurance = this.getDeliveryAssurance(binding);
            if (deliveryAssurance == null) {
                return false;
            }
            InOrder inOrder = (InOrder)PolicyModelHelper.getTopLevelElement((WSDLComponent)deliveryAssurance, InOrder.class, true);
            return inOrder != null;
        }
        return false;
    }

    private DeliveryAssurance getDeliveryAssurance(Binding binding) {
        RMAssertion rMAssertion = this.getRMAssertion(binding);
        if (rMAssertion != null) {
            return (DeliveryAssurance)PolicyModelHelper.getTopLevelElement((WSDLComponent)rMAssertion, DeliveryAssurance.class, true);
        }
        return null;
    }

    private Ordered getOrdered(Policy policy) {
        return (Ordered)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, Ordered.class, false);
    }

    private static AllowDuplicates getAllowDuplicates(Policy policy) {
        return (AllowDuplicates)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, AllowDuplicates.class, false);
    }

    public static String getResendInterval(Binding binding) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        ResendInterval resendInterval = (ResendInterval)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, ResendInterval.class, false);
        if (resendInterval != null) {
            return resendInterval.getResendInterval();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResendInterval(Binding binding, String string) {
        WSDLModel wSDLModel = binding.getModel();
        PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
        All all = policyModelHelper.createPolicy((WSDLComponent)binding, false);
        ResendInterval resendInterval = (ResendInterval)policyModelHelper.createElement((WSDLComponent)all, RMSunClientQName.RESENDINTERVAL.getQName(), ResendInterval.class, false);
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        try {
            if (resendInterval != null) {
                if (string == null) {
                    PolicyModelHelper.removeElement((WSDLComponent)resendInterval);
                } else {
                    resendInterval.setResendInterval(string);
                }
            }
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
    }

    public static String getCloseTimeout(Binding binding) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        CloseTimeout closeTimeout = (CloseTimeout)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, CloseTimeout.class, false);
        if (closeTimeout != null) {
            return closeTimeout.getCloseTimeout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCloseTimeout(Binding binding, String string) {
        WSDLModel wSDLModel = binding.getModel();
        PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
        All all = policyModelHelper.createPolicy((WSDLComponent)binding, false);
        CloseTimeout closeTimeout = (CloseTimeout)policyModelHelper.createElement((WSDLComponent)all, RMSunClientQName.CLOSETIMEOUT.getQName(), CloseTimeout.class, false);
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        try {
            if (closeTimeout != null) {
                if (string == null) {
                    PolicyModelHelper.removeElement((WSDLComponent)closeTimeout);
                } else {
                    closeTimeout.setCloseTimeout(string);
                }
            }
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
    }

    public static String getAckRequestInterval(Binding binding) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        AckRequestInterval ackRequestInterval = (AckRequestInterval)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, AckRequestInterval.class, false);
        if (ackRequestInterval != null) {
            return ackRequestInterval.getAckRequestInterval();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAckRequestInterval(Binding binding, String string) {
        WSDLModel wSDLModel = binding.getModel();
        PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
        All all = policyModelHelper.createPolicy((WSDLComponent)binding, false);
        AckRequestInterval ackRequestInterval = (AckRequestInterval)policyModelHelper.createElement((WSDLComponent)all, RMSunClientQName.ACKREQUESTINTERVAL.getQName(), AckRequestInterval.class, false);
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        try {
            if (ackRequestInterval != null) {
                if (string == null) {
                    PolicyModelHelper.removeElement((WSDLComponent)ackRequestInterval);
                } else {
                    ackRequestInterval.setAckRequestInterval(string);
                }
            }
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
    }
}

