/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.design;

import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.configuration.WSConfiguration;
import org.netbeans.modules.websvc.design.javamodel.ServiceChangeListener;
import org.netbeans.modules.websvc.design.javamodel.ServiceModel;
import org.netbeans.modules.websvc.wsitconf.api.DesignerListenerProvider;
import org.netbeans.modules.websvc.wsitconf.design.ConfigRunnable;
import org.netbeans.modules.websvc.wsitconf.design.WsitServiceChangeListener;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfileRegistry;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SecurityConfiguration
implements WSConfiguration {
    private Service service;
    private DataObject implementationFile;
    private Project project;
    private ServiceModel serviceModel;
    private ServiceChangeListener scl;
    private ArrayList<PropertyChangeListener> listeners = new ArrayList();
    private Binding binding;
    private ComponentListener cl;
    private boolean clAdded = false;
    private PropertyChangeListener configCreationListener = null;
    private Collection<FileObject> createdFiles = new LinkedList<FileObject>();

    public SecurityConfiguration(final Service service, final FileObject fileObject) {
        try {
            this.service = service;
            this.implementationFile = DataObject.find((FileObject)fileObject);
            this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
            this.serviceModel = ServiceModel.getServiceModel((FileObject)fileObject);
            this.addServiceChangeListener();
            this.cl = new ComponentListener(){

                private void update() {
                    boolean bl = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)SecurityConfiguration.this.binding);
                    for (PropertyChangeListener propertyChangeListener : SecurityConfiguration.this.listeners) {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(SecurityConfiguration.this, "value", null, bl);
                        propertyChangeListener.propertyChange(propertyChangeEvent);
                    }
                }

                public void valueChanged(ComponentEvent componentEvent) {
                    this.update();
                }

                public void childrenAdded(ComponentEvent componentEvent) {
                    this.update();
                }

                public void childrenDeleted(ComponentEvent componentEvent) {
                    this.update();
                }
            };
            this.binding = WSITModelSupport.getBinding(service, fileObject, this.project, false, this.createdFiles);
            if (this.binding != null) {
                this.addCListener(this.binding);
            } else {
                this.configCreationListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        SecurityConfiguration.this.binding = WSITModelSupport.getBinding(service, fileObject, SecurityConfiguration.this.project, false, SecurityConfiguration.this.createdFiles);
                        SecurityConfiguration.this.addCListener(SecurityConfiguration.this.binding);
                        SecurityConfiguration.this.cl.valueChanged(null);
                    }
                };
                DesignerListenerProvider.registerListener(this.configCreationListener);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
    }

    public Component getComponent() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(SecurityConfiguration.class, (String)"DesignConfigPanel.Security");
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/wsitconf/resources/designer-security.gif");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SecurityConfiguration.class, (String)"DesignConfigPanel.Security");
    }

    private void addServiceChangeListener() {
        if (this.scl == null) {
            this.scl = new WsitServiceChangeListener(this.service, this.implementationFile.getPrimaryFile(), this.project);
        }
        if (this.scl != null && this.serviceModel != null) {
            this.serviceModel.addServiceChangeListener(this.scl);
        }
    }

    private synchronized void addCListener(Binding binding) {
        if (!this.clAdded && binding != null) {
            binding.getModel().addComponentListener(this.cl);
            this.clAdded = true;
        }
    }

    public boolean isSet() {
        boolean bl = false;
        this.binding = WSITModelSupport.getBinding(this.service, this.implementationFile.getPrimaryFile(), this.project, false, null);
        this.addCListener(this.binding);
        if (this.binding != null) {
            bl = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)this.binding);
        }
        return bl;
    }

    public void set() {
        this.switchIt(true);
    }

    public void unset() {
        this.switchIt(false);
    }

    private void switchIt(final boolean bl) {
        final ConfigRunnable configRunnable = new ConfigRunnable();
        SwingUtilities.invokeLater(configRunnable);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (bl) {
                        SecurityConfiguration.this.binding = WSITModelSupport.getBinding(SecurityConfiguration.this.service, SecurityConfiguration.this.implementationFile.getPrimaryFile(), SecurityConfiguration.this.project, true, null);
                        if (SecurityConfiguration.this.binding == null) {
                            return;
                        }
                        SecurityConfiguration.this.addCListener(SecurityConfiguration.this.binding);
                        if (!SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)SecurityConfiguration.this.binding)) {
                            SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(ComboConstants.PROF_MUTUALCERT);
                            securityProfile.profileSelected((WSDLComponent)SecurityConfiguration.this.binding, true, ConfigVersion.getDefault());
                            if (!RMModelHelper.getInstance(ConfigVersion.getDefault()).isRMEnabled((WSDLComponent)SecurityConfiguration.this.binding) && securityProfile instanceof SecureConversationFeature) {
                                ((SecureConversationFeature)((Object)securityProfile)).enableSecureConversation((WSDLComponent)SecurityConfiguration.this.binding, true);
                            }
                            Util.fillDefaults(SecurityConfiguration.this.project, false, true);
                            ProfilesModelHelper.setServiceDefaults(ComboConstants.PROF_MUTUALCERT, SecurityConfiguration.this.binding, SecurityConfiguration.this.project);
                            WSITModelSupport.save((WSDLComponent)SecurityConfiguration.this.binding);
                        }
                    } else {
                        if (SecurityConfiguration.this.binding == null) {
                            return;
                        }
                        if (SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)SecurityConfiguration.this.binding)) {
                            SecurityConfiguration.this.addCListener(SecurityConfiguration.this.binding);
                            SecurityPolicyModelHelper.getInstance(PolicyModelHelper.getConfigVersion((WSDLComponent)SecurityConfiguration.this.binding)).disableSecurity((WSDLComponent)SecurityConfiguration.this.binding, true);
                            WSITModelSupport.save((WSDLComponent)SecurityConfiguration.this.binding);
                        }
                    }
                }
                finally {
                    configRunnable.stop();
                }
            }
        });
    }

    public void registerListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    public void unregisterListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    protected void finalize() {
        if (this.scl != null && this.serviceModel != null) {
            this.serviceModel.removeServiceChangeListener(this.scl);
        }
        if (this.binding != null && this.clAdded) {
            this.binding.getModel().removeComponentListener(this.cl);
        }
    }

    public boolean isEnabled() {
        boolean bl = false;
        if (this.implementationFile == null || !this.implementationFile.isValid()) {
            return false;
        }
        Node node = this.implementationFile.getNodeDelegate();
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        bl = !SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(node, jaxWsModel);
        return bl;
    }
}

