/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.netbeans.junit.ControlFlow;
import org.netbeans.junit.NbTestCase;

public final class Log
extends Handler {
    private static NbTestCase current;
    private static final StringBuffer messages;
    private static int initialMessages;
    private Reference<PrintStream> log;
    private Logger logger;

    public Log() {
    }

    private Log(Logger logger, PrintStream printStream) {
        this.log = new WeakReference<PrintStream>(printStream);
        this.logger = logger;
    }

    public static CharSequence enable(String string, Level level) {
        Logger logger = Logger.getLogger(string);
        if (logger.getLevel() == null || logger.getLevel().intValue() > level.intValue()) {
            logger.setLevel(level);
        }
        class MyPs
        extends PrintStream
        implements CharSequence {
            private ByteArrayOutputStream os;

            public MyPs() {
                this(new ByteArrayOutputStream());
            }

            private MyPs(ByteArrayOutputStream byteArrayOutputStream) {
                super(byteArrayOutputStream);
                this.os = byteArrayOutputStream;
            }

            public int length() {
                return this.toString().length();
            }

            public char charAt(int n) {
                return this.toString().charAt(n);
            }

            public CharSequence subSequence(int n, int n2) {
                return this.toString().subSequence(n, n2);
            }

            public String toString() {
                return this.os.toString();
            }
        }
        MyPs myPs = new MyPs();
        Log log = new Log(logger, myPs);
        log.setLevel(level);
        logger.addHandler(log);
        return myPs;
    }

    public static void controlFlow(Logger logger, Logger logger2, String string, int n) {
        ControlFlow.registerSwitches(logger, logger2, string, n);
    }

    public static void enableInstances(Logger logger, String string, Level level) {
        if (logger == null) {
            logger = Logger.getLogger("TIMER");
        }
        logger.addHandler(new InstancesHandler(string, level));
        if (logger.getLevel() == null || logger.getLevel().intValue() > level.intValue()) {
            logger.setLevel(level);
        }
    }

    public static void assertInstances(String string) {
        InstancesHandler.assertGC(string, new String[0]);
    }

    public static void assertInstances(String string, String ... stringArray) {
        InstancesHandler.assertGC(string, stringArray);
    }

    static void configure(Level level, NbTestCase nbTestCase) {
        String string = "handlers=" + Log.class.getName() + "\n" + ".level=" + level.intValue() + "\n";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        try {
            LogManager.getLogManager().readConfiguration(byteArrayInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        current = nbTestCase;
        messages.setLength(0);
        messages.append("Starting test ");
        messages.append(nbTestCase.getName());
        messages.append('\n');
        initialMessages = messages.length();
    }

    private PrintStream getLog(LogRecord logRecord) {
        if (this.log != null) {
            PrintStream printStream = this.log.get();
            if (printStream == null) {
                this.logger.removeHandler(this);
            }
            return printStream == null ? System.err : printStream;
        }
        NbTestCase nbTestCase = current;
        return nbTestCase == null ? System.err : nbTestCase.getLog();
    }

    public void publish(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(logRecord.getLoggerName());
        stringBuffer.append("] THREAD: ");
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append(" MSG: ");
        String string = logRecord.getMessage();
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        if (resourceBundle != null) {
            try {
                string = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string != null && logRecord.getParameters() != null) {
            string = MessageFormat.format(string, logRecord.getParameters());
        }
        stringBuffer.append(string);
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                stringBuffer.append("\n  ").append(stackTraceElement.toString());
            }
        }
        this.getLog(logRecord).println(stringBuffer.toString());
        messages.append(stringBuffer.toString());
        messages.append('\n');
        if (messages.length() > 40000) {
            messages.delete(0, 20000);
        }
        if (logRecord.getThrown() != null) {
            logRecord.getThrown().printStackTrace(this.getLog(logRecord));
        }
    }

    public void flush() {
    }

    public void close() {
    }

    static Throwable wrapWithMessages(Throwable throwable) {
        if (messages.length() == initialMessages) {
            return throwable;
        }
        if (throwable instanceof AssertionFailedError) {
            AssertionFailedError assertionFailedError = new AssertionFailedError(throwable.getMessage() + " Log:\n" + messages);
            assertionFailedError.setStackTrace(throwable.getStackTrace());
            return assertionFailedError;
        }
        if (throwable instanceof IOException) {
            IOException iOException = new IOException(throwable.getMessage() + " Log:\n" + messages);
            iOException.setStackTrace(throwable.getStackTrace());
            return iOException;
        }
        if (throwable instanceof Exception) {
            return new InvocationTargetException(throwable, throwable.getMessage() + " Log:\n" + messages);
        }
        return throwable;
    }

    static {
        messages = new StringBuffer();
    }

    private static class InstancesHandler
    extends Handler {
        static final Map<Object, String> instances = Collections.synchronizedMap(new WeakHashMap());
        static int cnt;
        private final String msg;

        public InstancesHandler(String string, Level level) {
            this.setLevel(level);
            this.msg = string;
        }

        public void publish(LogRecord logRecord) {
            Object[] objectArray = logRecord.getParameters();
            if (objectArray == null) {
                return;
            }
            if (this.msg != null && !this.msg.equals(logRecord.getMessage())) {
                return;
            }
            ++cnt;
            for (Object object : objectArray) {
                instances.put(object, logRecord.getMessage());
            }
        }

        public void flush() {
        }

        public void close() throws SecurityException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void assertGC(String string, String ... stringArray) {
            Object object;
            AssertionFailedError assertionFailedError = null;
            ArrayList<WeakReference<Object>> arrayList = new ArrayList<WeakReference<Object>>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = 0;
            HashSet<String> hashSet = stringArray == null || stringArray.length == 0 ? null : new HashSet<String>(Arrays.asList(stringArray));
            Map<Object, String> map = instances;
            synchronized (map) {
                object = instances.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry<Object, String> entry = object.next();
                    if (hashSet != null && !hashSet.contains(entry.getValue())) continue;
                    arrayList.add(new WeakReference<Object>(entry.getKey()));
                    arrayList2.add(entry.getValue());
                    object.remove();
                    ++n;
                }
            }
            if (n == 0) {
                Assert.fail((String)"No instance of this type reported");
            }
            for (int i = 0; i < n; ++i) {
                object = (Reference)arrayList.get(i);
                try {
                    NbTestCase.assertGC(string + " " + (String)arrayList2.get(i), object);
                    continue;
                }
                catch (AssertionFailedError assertionFailedError2) {
                    if (assertionFailedError == null) {
                        assertionFailedError = assertionFailedError2;
                        continue;
                    }
                    Throwable throwable = assertionFailedError;
                    while (throwable.getCause() != null) {
                        throwable = throwable.getCause();
                    }
                    throwable.initCause(assertionFailedError2);
                }
            }
            if (assertionFailedError != null) {
                throw assertionFailedError;
            }
        }
    }
}

