/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Stack;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoTable;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.MACINFO;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

public class DwarfMacroInfoSection
extends ElfSection {
    HashMap<Long, DwarfMacinfoTable> macinfoTables = new HashMap();

    public DwarfMacroInfoSection(DwarfReader dwarfReader, int n) {
        super(dwarfReader, n);
    }

    public DwarfMacinfoTable getMacinfoTable(long l) {
        Long l2 = new Long(l);
        DwarfMacinfoTable dwarfMacinfoTable = this.macinfoTables.get(l2);
        if (dwarfMacinfoTable == null) {
            dwarfMacinfoTable = new DwarfMacinfoTable(this, l);
            this.macinfoTables.put(l2, dwarfMacinfoTable);
        }
        return dwarfMacinfoTable;
    }

    public long readMacinfoTable(DwarfMacinfoTable dwarfMacinfoTable, long l, boolean bl) throws IOException {
        long l2;
        long l3 = this.reader.getFilePointer();
        this.reader.seek(this.header.getSectionOffset() + l);
        MACINFO mACINFO = MACINFO.get(this.reader.readByte());
        if (bl && mACINFO.equals((Object)MACINFO.DW_MACINFO_start_file)) {
            long l4 = this.reader.readUnsignedLEB128();
            if (l4 == 0L) {
                l2 = this.reader.readUnsignedLEB128();
            } else {
                this.reader.seek(this.header.getSectionOffset() + l);
            }
            mACINFO = MACINFO.get(this.reader.readByte());
        }
        Stack<Integer> stack = new Stack<Integer>();
        int n = -1;
        while (mACINFO != null && (!bl || bl && n == -1)) {
            DwarfMacinfoEntry dwarfMacinfoEntry = new DwarfMacinfoEntry(mACINFO);
            if (mACINFO.equals((Object)MACINFO.DW_MACINFO_define) || mACINFO.equals((Object)MACINFO.DW_MACINFO_undef)) {
                dwarfMacinfoEntry.lineNum = this.reader.readUnsignedLEB128();
                dwarfMacinfoEntry.definition = this.reader.readString();
                dwarfMacinfoEntry.fileIdx = n;
            } else if (mACINFO.equals((Object)MACINFO.DW_MACINFO_start_file)) {
                if (bl) break;
                dwarfMacinfoEntry.lineNum = this.reader.readUnsignedLEB128();
                dwarfMacinfoEntry.fileIdx = this.reader.readUnsignedLEB128();
                stack.push(n);
                n = dwarfMacinfoEntry.fileIdx;
            } else if (mACINFO.equals((Object)MACINFO.DW_MACINFO_end_file)) {
                if (!stack.empty()) {
                    n = (Integer)stack.pop();
                }
            } else if (mACINFO.equals((Object)MACINFO.DW_MACINFO_vendor_ext)) {
                this.reader.readUnsignedLEB128();
                this.reader.readString();
            }
            dwarfMacinfoTable.addEntry(dwarfMacinfoEntry);
            mACINFO = MACINFO.get(this.reader.readByte());
        }
        l2 = this.reader.getFilePointer() - (this.header.getSectionOffset() + l + 1L);
        this.reader.seek(l3);
        return l2;
    }

    public void dump(PrintStream printStream) {
        super.dump(printStream);
        for (DwarfMacinfoTable dwarfMacinfoTable : this.macinfoTables.values()) {
            dwarfMacinfoTable.dump(printStream);
        }
    }
}

