/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfStatementList;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;
import org.netbeans.modules.cnd.dwarfdump.section.FileEntry;

public class DwarfLineInfoSection
extends ElfSection {
    HashMap<Long, DwarfStatementList> statementLists = new HashMap();

    public DwarfLineInfoSection(DwarfReader dwarfReader, int n) {
        super(dwarfReader, n);
    }

    public DwarfStatementList getStatementList(long l) {
        Long l2 = new Long(l);
        DwarfStatementList dwarfStatementList = this.statementLists.get(l2);
        if (dwarfStatementList == null) {
            try {
                dwarfStatementList = this.readStatementList(l);
                this.statementLists.put(l2, dwarfStatementList);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return dwarfStatementList;
    }

    private DwarfStatementList readStatementList(long l) throws IOException {
        long l2 = this.reader.getFilePointer();
        this.reader.seek(this.header.getSectionOffset() + l);
        DwarfStatementList dwarfStatementList = new DwarfStatementList(l);
        dwarfStatementList.total_length = this.reader.readDWlen();
        dwarfStatementList.version = this.reader.readShort();
        dwarfStatementList.prologue_length = this.reader.read3264();
        dwarfStatementList.minimum_instruction_length = this.reader.readByte();
        dwarfStatementList.default_is_stmt = this.reader.readByte();
        dwarfStatementList.line_base = this.reader.readByte();
        dwarfStatementList.line_range = this.reader.readByte();
        dwarfStatementList.opcode_base = this.reader.readByte();
        dwarfStatementList.standard_opcode_lengths = new long[dwarfStatementList.opcode_base - 1];
        for (int i = 0; i < dwarfStatementList.opcode_base - 1; ++i) {
            dwarfStatementList.standard_opcode_lengths[i] = this.reader.readUnsignedLEB128();
        }
        String string = this.reader.readString();
        while (string.length() > 0) {
            dwarfStatementList.includeDirs.add(string);
            string = this.reader.readString();
        }
        String string2 = this.reader.readString();
        while (string2.length() > 0) {
            dwarfStatementList.fileEntries.add(new FileEntry(string2, this.reader.readUnsignedLEB128(), this.reader.readUnsignedLEB128(), this.reader.readUnsignedLEB128()));
            string2 = this.reader.readString();
        }
        this.reader.seek(l2);
        return dwarfStatementList;
    }

    public void dump(PrintStream printStream) {
        super.dump(printStream);
        for (DwarfStatementList dwarfStatementList : this.statementLists.values()) {
            dwarfStatementList.dump(printStream);
        }
    }
}

