/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.javascript.editing.spi.JSPreferencesPanel;
import org.netbeans.modules.javascript.editing.spi.JSPreferencesPanelProvider;
import org.netbeans.modules.web.client.javascript.debugger.models.NbJSPreferences;
import org.netbeans.modules.web.client.tools.api.FirefoxBrowserUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class NbJSPreferencesPanelProvider
extends JSPreferencesPanel
implements JSPreferencesPanelProvider,
ActionListener {
    private List<ChangeListener> listeners;
    private NbJSPreferencesPanelProvider INSTANCE = null;
    public static final NbJSPreferences preferences = NbJSPreferences.getInstance();
    private JLabel errorLabel;
    private JButton ffProfileBrowseButton;
    private JLabel ffProfileLabel;
    private JTextField ffProfileTextField;
    private JCheckBox ignoreQueryStringsCheckBox;
    private JLabel jLabel1;
    private JCheckBox showConstantsCheckBox;
    private JCheckBox showFunctionsCheckBox;
    private JCheckBox suspendOnDebuggerKeywordCheckBox;
    private JCheckBox suspendOnErrorsCheckBox;
    private JCheckBox suspendOnExceptionsCheckBox;
    private JCheckBox suspendOnFirstLineCheckBox;

    public JSPreferencesPanel getPanel() {
        if (this.INSTANCE == null) {
            this.INSTANCE = new NbJSPreferencesPanelProvider();
        }
        return this.INSTANCE;
    }

    public NbJSPreferencesPanelProvider() {
        this.initComponents();
        this.showFunctionsCheckBox.addActionListener(this);
        this.showFunctionsCheckBox.addActionListener(this);
        this.suspendOnErrorsCheckBox.addActionListener(this);
        this.suspendOnExceptionsCheckBox.addActionListener(this);
        this.suspendOnFirstLineCheckBox.addActionListener(this);
        this.errorLabel.setVisible(false);
        this.ffProfileTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                NbJSPreferencesPanelProvider.this.validateProfileDir();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NbJSPreferencesPanelProvider.this.validateProfileDir();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                NbJSPreferencesPanelProvider.this.validateProfileDir();
            }
        });
    }

    public void load() {
        this.updateUIFromPreferences(preferences);
    }

    public void store() {
        this.updatePreferencesFromUI(preferences);
    }

    void updateUIFromPreferences(NbJSPreferences nbJSPreferences) {
        this.showConstantsCheckBox.setSelected(nbJSPreferences.getShowConstants());
        this.showFunctionsCheckBox.setSelected(nbJSPreferences.getShowFunctions());
        this.suspendOnDebuggerKeywordCheckBox.setSelected(nbJSPreferences.getSuspendOnDebuggerKeyword());
        this.suspendOnErrorsCheckBox.setSelected(nbJSPreferences.getSuspendOnErrors());
        this.suspendOnExceptionsCheckBox.setSelected(nbJSPreferences.getSuspendOnExceptions());
        this.suspendOnFirstLineCheckBox.setSelected(nbJSPreferences.getSuspendOnFirstLine());
        this.ignoreQueryStringsCheckBox.setSelected(nbJSPreferences.getIgnoreQueryStrings());
        Preferences preferences = NbPreferences.forModule(FirefoxBrowserUtils.class);
        String string = preferences.get("firefox-defaultProfile", "");
        this.ffProfileTextField.setText(string);
        this.validateProfileDir();
    }

    void updatePreferencesFromUI(NbJSPreferences nbJSPreferences) {
        nbJSPreferences.setShowConstants(this.showConstantsCheckBox.isSelected());
        nbJSPreferences.setShowFunctions(this.showFunctionsCheckBox.isSelected());
        nbJSPreferences.setSuspendOnDebuggerKeyword(this.suspendOnDebuggerKeywordCheckBox.isSelected());
        nbJSPreferences.setSuspendOnErrors(this.suspendOnErrorsCheckBox.isSelected());
        nbJSPreferences.setSuspendOnExceptions(this.suspendOnExceptionsCheckBox.isSelected());
        nbJSPreferences.setSuspendOnFirstLine(this.suspendOnFirstLineCheckBox.isSelected());
        nbJSPreferences.setIgnoreQueryStrings(this.ignoreQueryStringsCheckBox.isSelected());
        Preferences preferences = NbPreferences.forModule(FirefoxBrowserUtils.class);
        String string = preferences.get("firefox-defaultProfile", "");
        String string2 = this.ffProfileTextField.getText();
        if (!string.equals(string2) && this.validateProfileDir()) {
            preferences.put("firefox-defaultProfile", string2);
            try {
                preferences.sync();
            }
            catch (BackingStoreException backingStoreException) {
                Logger.getLogger(NbJSPreferencesPanelProvider.class.getName()).log(Level.INFO, "Could not save preferences", backingStoreException);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JCheckBox) {
            ChangeEvent changeEvent = new ChangeEvent(object);
            if (this.listeners != null) {
                for (ChangeListener changeListener : this.listeners) {
                    changeListener.stateChanged(changeEvent);
                }
            }
        }
    }

    private boolean validateProfileDir() {
        String string = this.ffProfileTextField.getText();
        if (string.length() == 0) {
            this.errorLabel.setVisible(false);
            return true;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            this.errorLabel.setVisible(false);
            return true;
        }
        this.errorLabel.setVisible(true);
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void initComponents() {
        this.showFunctionsCheckBox = new JCheckBox();
        this.showConstantsCheckBox = new JCheckBox();
        this.suspendOnFirstLineCheckBox = new JCheckBox();
        this.suspendOnExceptionsCheckBox = new JCheckBox();
        this.suspendOnErrorsCheckBox = new JCheckBox();
        this.suspendOnDebuggerKeywordCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.ffProfileLabel = new JLabel();
        this.ffProfileTextField = new JTextField();
        this.ffProfileBrowseButton = new JButton();
        this.errorLabel = new JLabel();
        this.ignoreQueryStringsCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.showFunctionsCheckBox, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.showFunctionsCheckBox.text"));
        this.showFunctionsCheckBox.setMaximumSize(new Dimension(122, 22));
        this.showFunctionsCheckBox.setMinimumSize(new Dimension(122, 22));
        Mnemonics.setLocalizedText((AbstractButton)this.showConstantsCheckBox, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.showConstantsCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.suspendOnFirstLineCheckBox, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.suspendOnFirstLineCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.suspendOnExceptionsCheckBox, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.suspendOnExceptionsCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.suspendOnErrorsCheckBox, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.suspendOnErrorsCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.suspendOnDebuggerKeywordCheckBox, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.suspendOnDebuggerKeywordCheckBox.text"));
        this.jLabel1.setText(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.Debugging.text"));
        this.ffProfileLabel.setLabelFor(this.ffProfileTextField);
        Mnemonics.setLocalizedText((JLabel)this.ffProfileLabel, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.ffProfileLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.ffProfileBrowseButton, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.ffProfileBrowseButton.text"));
        this.ffProfileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbJSPreferencesPanelProvider.this.ffProfileBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.errorLabel.setText(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.errorLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreQueryStringsCheckBox, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.ignoreQueryStringsCheckBox.text"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.suspendOnFirstLineCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.suspendOnDebuggerKeywordCheckBox).add((Component)this.suspendOnErrorsCheckBox).add((Component)this.suspendOnExceptionsCheckBox)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.ignoreQueryStringsCheckBox).add((Component)this.showConstantsCheckBox).add((Component)this.showFunctionsCheckBox, -2, -1, -2))))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.ffProfileLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.errorLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.ffProfileTextField, -2, 302, -2).addPreferredGap(0).add((Component)this.ffProfileBrowseButton))))).addContainerGap(27, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.suspendOnDebuggerKeywordCheckBox)).addPreferredGap(0).add((Component)this.suspendOnErrorsCheckBox).addPreferredGap(0).add((Component)this.suspendOnExceptionsCheckBox).addPreferredGap(0).add((Component)this.suspendOnFirstLineCheckBox)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.showConstantsCheckBox).addPreferredGap(0).add((Component)this.showFunctionsCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.ignoreQueryStringsCheckBox))).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.ffProfileLabel).add((Component)this.ffProfileTextField, -2, -1, -2).add((Component)this.ffProfileBrowseButton)).addPreferredGap(0).add((Component)this.errorLabel).addContainerGap(76, Short.MAX_VALUE)));
        this.showFunctionsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_ShowFunctions"));
        this.showFunctionsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_ShowFunctions"));
        this.showConstantsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_ShowConstants"));
        this.showConstantsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_ShowConstants"));
        this.suspendOnFirstLineCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_SuspendOnFirstLine"));
        this.suspendOnFirstLineCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_SuspendOnFirstLine"));
        this.suspendOnExceptionsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_SuspendOnExceptions"));
        this.suspendOnExceptionsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_SuspendOnExceptions"));
        this.suspendOnErrorsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_SuspendOnErrors"));
        this.suspendOnErrorsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSAdvancedOptionsPanel.suspendOnErrorsCheckBox.AccessibleContext.accessibleDescription"));
        this.suspendOnDebuggerKeywordCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_ShowOnDebuggerKeyword"));
        this.suspendOnDebuggerKeywordCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_ShowOnDebuggerKeyword"));
        this.ffProfileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.ffProfileTextField.AccessibleContext.accessibleDescription"));
        this.ffProfileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.ffProfileBrowseButton.AccessibleContext.accessibleDescription"));
        this.ignoreQueryStringsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.ignoreQueryStringsCheckBox.AccessibleContext.accessibleDescription"));
    }

    private void ffProfileBrowseButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        String string = this.ffProfileTextField.getText();
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setCurrentDirectory(file);
        }
        if (jFileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.ffProfileTextField.setText(file.getAbsolutePath());
        }
    }
}

