/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.javascript.editing.lexer.Call;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSCallStackFrame;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSObject;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSProperty;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSValue;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public final class ToolTipAnnotation
extends Annotation
implements Runnable {
    private Line.Part lp;
    private EditorCookie ec;

    public String getShortDescription() {
        NbJSDebugger nbJSDebugger = ToolTipAnnotation.getDebugger();
        if (nbJSDebugger == null) {
            return null;
        }
        JSCallStackFrame jSCallStackFrame = nbJSDebugger.getSelectedFrame();
        if (jSCallStackFrame == null) {
            return null;
        }
        Line.Part part = (Line.Part)this.getAttachedAnnotatable();
        if (part == null) {
            return null;
        }
        Line line = part.getLine();
        DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        this.lp = part;
        this.ec = editorCookie;
        RequestProcessor.getDefault().post((Runnable)this);
        return null;
    }

    public void run() {
        String string;
        StyledDocument styledDocument;
        NbJSDebugger nbJSDebugger = ToolTipAnnotation.getDebugger();
        if (nbJSDebugger == null) {
            return;
        }
        JSCallStackFrame jSCallStackFrame = nbJSDebugger.getSelectedFrame();
        if (jSCallStackFrame == null) {
            return;
        }
        if (this.lp == null || this.ec == null) {
            return;
        }
        try {
            styledDocument = this.ec.openDocument();
        }
        catch (IOException iOException) {
            return;
        }
        JEditorPane jEditorPane = EditorContextDispatcher.getDefault().getCurrentEditor();
        if (jEditorPane == null) {
            return;
        }
        String string2 = ToolTipAnnotation.getIdentifier(styledDocument, jEditorPane, NbDocument.findLineOffset((StyledDocument)styledDocument, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn());
        if (string2 == null) {
            return;
        }
        if (string2.trim().length() == 0) {
            return;
        }
        JSProperty jSProperty = jSCallStackFrame.eval(string2);
        if (jSProperty == null) {
            return;
        }
        JSValue jSValue = jSProperty.getValue();
        if (jSValue == null) {
            return;
        }
        String string3 = string = jSValue instanceof JSObject ? ((JSObject)jSValue).getClassName() : jSValue.getDisplayValue();
        if (string == null || string.equals(string2)) {
            return;
        }
        String string4 = string2 + " = " + string;
        this.firePropertyChange("shortDescription", null, string4);
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        Object object;
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        if (styledDocument instanceof BaseDocument) {
            try {
                object = Call.getCallExpression((BaseDocument)((BaseDocument)styledDocument), (int)n);
                if (object != null) {
                    return object;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        try {
            object = Utilities.getIdentifierBlock((JTextComponent)jEditorPane, (int)n);
            if (object != null) {
                return styledDocument.getText(object[0], object[1] - object[0]);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private static NbJSDebugger getDebugger() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        return debuggerEngine == null ? null : (NbJSDebugger)debuggerEngine.lookupFirst(null, NbJSDebugger.class);
    }
}

