/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.models;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSContextProviderWrapper;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSCallStackFrame;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEventListener;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerState;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSObject;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSPrimitive;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSProperty;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSValue;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;

public class NbJSVariablesModel
implements TreeModel,
ExtendedNodeModel,
TableModel,
JSDebuggerEventListener {
    public static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png";
    public static final String CLASS = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable.gif";
    protected final NbJSDebugger debugger;
    private PropertyChangeListener propertyChangeListener;
    protected final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private boolean staleState = true;

    public NbJSVariablesModel(ContextProvider contextProvider) {
        this.debugger = NbJSContextProviderWrapper.getContextProviderWrapper(contextProvider).getNbJSDebugger();
        this.propertyChangeListener = new PropertyChangeListenerImpl();
        this.debugger.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propertyChangeListener, (Object)this.debugger));
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (!this.debugger.isSessionSuspended()) {
            return EMPTY_OBJECT_ARRAY;
        }
        JSCallStackFrame jSCallStackFrame = this.debugger.getSelectedFrame();
        if (object == "Root") {
            if (jSCallStackFrame != null) {
                return new Object[]{jSCallStackFrame.getScope(), jSCallStackFrame.getThis()};
            }
            return EMPTY_OBJECT_ARRAY;
        }
        if (object instanceof JSProperty) {
            JSProperty jSProperty = (JSProperty)object;
            JSValue jSValue = jSProperty.getValue();
            if (jSValue instanceof JSObject) {
                JSObject jSObject = (JSObject)jSValue;
                Object[] objectArray = jSObject.getProperties();
                return objectArray;
            }
            return EMPTY_OBJECT_ARRAY;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof JSProperty) {
            JSProperty jSProperty = (JSProperty)object;
            JSValue jSValue = jSProperty.getValue();
            return !(jSValue instanceof JSObject);
        }
        throw new UnknownTypeException(object);
    }

    private boolean isSessionSuspended() {
        return this.debugger.getState().getState() == JSDebuggerState.State.SUSPENDED;
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (this.isSessionSuspended()) {
            return 0;
        }
        if (object == "Root") {
            JSCallStackFrame jSCallStackFrame = this.debugger.getSelectedFrame();
            if (jSCallStackFrame != null) {
                return 2;
            }
            return 0;
        }
        if (object instanceof JSProperty) {
            JSProperty jSProperty = (JSProperty)object;
            JSValue jSValue = jSProperty.getValue();
            if (jSValue instanceof JSObject) {
                return ((JSObject)jSValue).getProperties().length;
            }
            return 0;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireChanges() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        String string;
        if (object == "Root") {
            string = NbJSVariablesModel.getMessage("CTL_VariablesModel.Column.Name.Name");
        } else if (object instanceof JSProperty) {
            string = ((JSProperty)object).getName();
            assert (string != null) : "null name for the JavaScript Variable: " + object;
        } else {
            assert (object != null) : "null node passed to VariablesModel.getDisplayName()";
            throw new UnknownTypeException(object);
        }
        return string;
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        throw new UnsupportedOperationException();
    }

    public String getIconBaseWithExtension(Object object) throws UnknownTypeException {
        assert (object != "Root");
        if (object instanceof JSProperty) {
            JSProperty jSProperty = (JSProperty)object;
            if (jSProperty.getFullName().equals(".")) {
                return CLASS;
            }
            return LOCAL;
        }
        throw new UnknownTypeException(object);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(NbJSVariablesModel.class, (String)string);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbJSVariablesModel.getMessage("CTL_VariablesModel.Column.Name.Desc");
        }
        if (object instanceof JSProperty) {
            JSProperty jSProperty = (JSProperty)object;
            JSValue jSValue = jSProperty.getValue();
            return jSValue.getTypeOf().getTypeDisplayName() + ":" + jSValue.getDisplayValue();
        }
        throw new UnknownTypeException(object);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object == "Root") {
            return "";
        }
        if (object instanceof JSProperty) {
            JSProperty jSProperty = (JSProperty)object;
            JSValue jSValue = jSProperty.getValue();
            if ("LocalsValue".equals(string)) {
                return jSValue.getDisplayValue();
            }
            if ("LocalsType".equals(string)) {
                String string2 = jSValue.getTypeOf().getTypeDisplayName();
                if (jSValue instanceof JSObject) {
                    string2 = string2 + " " + this.getValueAt(object, "LocalsToString");
                }
                return string2;
            }
            if ("LocalsToString".equals(string)) {
                if (jSValue instanceof JSObject) {
                    return "{" + ((JSObject)jSValue).getClassName() + "}";
                }
                return "";
            }
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        JSProperty jSProperty;
        return !"LocalsValue".equals(string) || !(object instanceof JSProperty) || !((jSProperty = (JSProperty)object).getValue() instanceof JSPrimitive) && jSProperty.getValue().getTypeOf() != JSValue.TypeOf.STRING;
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        JSProperty jSProperty;
        if ("LocalsValue".equals(string) && object instanceof JSProperty && ((jSProperty = (JSProperty)object).getValue() instanceof JSPrimitive || jSProperty.getValue().getTypeOf() == JSValue.TypeOf.STRING)) {
            if (jSProperty.setValue(object2.toString())) {
                this.fireChanges();
            }
            return;
        }
        throw new UnknownTypeException(object);
    }

    public boolean canRename(Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object object) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object object) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Transferable clipboardCut(Object object) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PasteType[] getPasteTypes(Object object, Transferable transferable) throws UnknownTypeException {
        return null;
    }

    public void setName(Object object, String string) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected boolean isStaleState() {
        return this.staleState;
    }

    private void setStaleState(boolean bl) {
        this.staleState = bl;
    }

    public void onDebuggerEvent(JSDebuggerEvent jSDebuggerEvent) {
        JSDebuggerState jSDebuggerState = jSDebuggerEvent.getDebuggerState();
        NbJSDebugger nbJSDebugger = (NbJSDebugger)jSDebuggerEvent.getSource();
        switch (jSDebuggerState.getState()) {
            case SUSPENDED: {
                this.setStaleState(false);
                break;
            }
            case RUNNING: 
            case STARTING: {
                this.setStaleState(true);
                break;
            }
            case DISCONNECTED: {
                nbJSDebugger.removeJSDebuggerEventListener(this);
                break;
            }
        }
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("selectedFrame")) {
                NbJSVariablesModel.this.fireChanges();
            }
        }
    }
}

