/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.http.ui.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.javascript.debugger.http.api.HttpActivity;
import org.netbeans.modules.web.client.javascript.debugger.http.ui.HttpMonitorPreferences;
import org.netbeans.modules.web.client.javascript.debugger.http.ui.models.AbstractColumnModel;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSHttpMessage;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSHttpMessageEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSHttpMessageEventListener;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSHttpProgress;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSHttpRequest;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSHttpResponse;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpActivitiesModel
implements TreeModel,
TableModel,
NodeModel,
NodeActionsProvider {
    private final List<ModelListener> listeners;
    public static final String METHOD_COLUMN = "METHOD_COLUMN";
    public static final String SENT_COLUMN = "SENT_COLUMN";
    public static final String RESPONSE_COLUMN = "RESPONSE_COLUMN";
    private static final String HTTP_RESPONSE = "org/netbeans/modules/web/client/javascript/debugger/http/ui/resources/GreenArrow";
    private static final HttpMonitorPreferences httpMonitorPreferences = HttpMonitorPreferences.getInstance();
    private NbJSDebugger debugger;
    private final JSHttpMessageEventListener httpMessageEventListener = new JSHttpMesageEventListenerImpl();
    private final PreferenceChangeListenerImpl preferenceChangeListener = new PreferenceChangeListenerImpl();
    private static final Logger LOG = Logger.getLogger(HttpActivitiesModel.class.getName());
    private final Map<String, HttpActivity> id2ActivityMap = new HashMap<String, HttpActivity>();
    final List<HttpActivity> activityList = Collections.synchronizedList(new LinkedList());
    private List<HttpActivity> filteredActivites;
    private final Object lock = new Object();
    public static final List<String> HTML_CONTENT_TYPES = Arrays.asList("text/plain", "application/octet-stream", "text/html", "text/xml");
    public static final List<String> JS_CONTENT_TYPES = Arrays.asList("application/x-javascript", "text/javascript", "application/javascript");
    public static final List<String> CSS_CONTENT_TYPES = Arrays.asList("text/css");
    public static final List<String> IMAGES_CONTENT_TYPES = Arrays.asList("image/jpeg", "image/gif", "image/png", "image/bmp");
    public static final List<String> FLASH_CONTENT_TYPES = Arrays.asList("application/x-shockwave-flash");
    private static List<String> editorMimeType = new ArrayList<String>();
    private static final String HTML_CATEGORY = "html";
    private static final String JS_CATEGORY = "js";
    private static final String CSS_CATEGORY = "css";
    private static final String IMAGE_CATEGORY = "image";
    private static final String FLASH_CATEGORY = "flash";
    private static final String XHR_CATEGORY = "xhr";
    private static final String BIN_CATEGORY = "bin";
    private static final String TEXT_CATEGORY = "text";
    private static final MethodColumn methodColumn;
    private static final SentColumn sentColumn;
    private static final ResponseColumn resColumn;

    public HttpActivitiesModel(NbJSDebugger nbJSDebugger) {
        this.listeners = new CopyOnWriteArrayList<ModelListener>();
        this.debugger = nbJSDebugger;
        nbJSDebugger.addJSHttpMessageEventListener((JSHttpMessageEventListener)WeakListeners.create(JSHttpMessageEventListener.class, (EventListener)this.httpMessageEventListener, (Object)nbJSDebugger));
        httpMonitorPreferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.preferenceChangeListener, (Object)httpMonitorPreferences));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HttpActivity> getHttpActivities() {
        Object object = this.lock;
        synchronized (object) {
            if (this.filteredActivites == null) {
                this.filteredActivites = this.filterActivities(Collections.unmodifiableList(this.activityList));
            }
            return Collections.unmodifiableList(this.filteredActivites);
        }
    }

    private final List<HttpActivity> filterActivities(List<HttpActivity> list) {
        LinkedList<HttpActivity> linkedList = new LinkedList();
        if (httpMonitorPreferences.isShowAll()) {
            linkedList = list;
        } else {
            for (HttpActivity httpActivity : list) {
                String string = httpActivity.getCategory();
                if (string == null || this.filterOutCategory(string)) continue;
                linkedList.add(httpActivity);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearActivities() {
        Object object = this.lock;
        synchronized (object) {
            this.activityList.clear();
            this.id2ActivityMap.clear();
            this.filteredActivites = null;
        }
        this.fireModelChange();
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if ("Root".equals(object)) {
            return this.getHttpActivities();
        }
        if (object instanceof HttpActivity) {
            HttpActivity httpActivity = (HttpActivity)object;
            if (METHOD_COLUMN.equals(string)) {
                return httpActivity.getMethod();
            }
            if (SENT_COLUMN.equals(string)) {
                Date date = httpActivity.getStartTime();
                return date != null ? date.toString() : "";
            }
            if (RESPONSE_COLUMN.equals(string)) {
                Date date = httpActivity.getEndTime();
                return date != null ? date.toString() : "";
            }
            throw new UnknownTypeException((Object)("Column type not recognized: " + string));
        }
        throw new UnknownTypeException((Object)("Type not recognized:" + object));
    }

    public static final List getEditorMimeTypes() {
        return editorMimeType;
    }

    private boolean filterOutCategory(String string) {
        if (!httpMonitorPreferences.isShowHTML() && HTML_CATEGORY.equals(string)) {
            return true;
        }
        if (!httpMonitorPreferences.isShowJS() && JS_CATEGORY.equals(string)) {
            return true;
        }
        if (!httpMonitorPreferences.isShowCSS() && CSS_CATEGORY.equals(string)) {
            return true;
        }
        if (!httpMonitorPreferences.isShowImages() && IMAGE_CATEGORY.equals(string)) {
            return true;
        }
        if (!httpMonitorPreferences.isShowFlash() && FLASH_CATEGORY.equals(string)) {
            return true;
        }
        return !httpMonitorPreferences.isShowXHR() && XHR_CATEGORY.equals(string);
    }

    public Object[] getChildren(Object object, int n, int n2) {
        if ("Root".equals(object)) {
            return this.getHttpActivities().toArray();
        }
        return new Object[0];
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if ("Root".equals(object)) {
            return this.getHttpActivities().size();
        }
        return 0;
    }

    public Object getRoot() {
        return "Root";
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        return !"Root".equals(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        return true;
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
        Object object = this.lock;
        synchronized (object) {
            this.filteredActivites = null;
        }
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if ("Root".equals(object)) {
            return NbBundle.getMessage(HttpActivitiesModel.class, (String)"URL_COLUMN");
        }
        if (object instanceof HttpActivity) {
            HttpActivity httpActivity = (HttpActivity)object;
            return httpActivity.toString();
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if ("Root".equals(object)) {
            return null;
        }
        return HTTP_RESPONSE;
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof HttpActivity) {
            HttpActivity httpActivity = (HttpActivity)object;
            String string = httpActivity.getRequest().toString();
            return string;
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        return new Action[0];
    }

    public static ColumnModel getColumnModel(String string) {
        if (METHOD_COLUMN.equals(string)) {
            return methodColumn;
        }
        if (SENT_COLUMN.equals(string)) {
            return sentColumn;
        }
        if (RESPONSE_COLUMN.equals(string)) {
            return resColumn;
        }
        return null;
    }

    static {
        editorMimeType.addAll(HTML_CONTENT_TYPES);
        editorMimeType.addAll(JS_CONTENT_TYPES);
        editorMimeType.addAll(CSS_CONTENT_TYPES);
        methodColumn = new MethodColumn();
        sentColumn = new SentColumn();
        resColumn = new ResponseColumn();
    }

    private class PreferenceChangeListenerImpl
    implements PreferenceChangeListener {
        private PreferenceChangeListenerImpl() {
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if (HttpMonitorPreferences.isPreference(preferenceChangeEvent.getKey())) {
                HttpActivitiesModel.this.fireModelChange();
            }
        }
    }

    private static final class ResponseColumn
    extends AbstractColumnModel {
        private ResponseColumn() {
        }

        public String getID() {
            return HttpActivitiesModel.RESPONSE_COLUMN;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(HttpActivitiesModel.class, (String)HttpActivitiesModel.RESPONSE_COLUMN);
        }

        public Class getType() {
            return String.class;
        }
    }

    private static final class SentColumn
    extends AbstractColumnModel {
        private SentColumn() {
        }

        public String getID() {
            return HttpActivitiesModel.SENT_COLUMN;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(HttpActivitiesModel.class, (String)HttpActivitiesModel.SENT_COLUMN);
        }

        public Class getType() {
            return String.class;
        }
    }

    private static final class MethodColumn
    extends AbstractColumnModel {
        private static final HttpMonitorPreferences httpMonitorPreferences = HttpMonitorPreferences.getInstance();

        private MethodColumn() {
        }

        public String getID() {
            return HttpActivitiesModel.METHOD_COLUMN;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(HttpActivitiesModel.class, (String)HttpActivitiesModel.METHOD_COLUMN);
        }

        public Class getType() {
            return String.class;
        }

        public int getColumnWidth() {
            return this.properties.getInt(this.getID() + ".columnWidth", HttpMonitorPreferences.DEFAULT_METHOD_COLUMN_WIDTH);
        }
    }

    private class JSHttpMesageEventListenerImpl
    implements JSHttpMessageEventListener {
        private JSHttpMesageEventListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onHttpMessageEvent(JSHttpMessageEvent jSHttpMessageEvent) {
            JSHttpMessage jSHttpMessage = jSHttpMessageEvent.getHttpMessage();
            assert (jSHttpMessage != null);
            if (jSHttpMessage instanceof JSHttpRequest) {
                JSHttpRequest jSHttpRequest = (JSHttpRequest)jSHttpMessage;
                HttpActivity httpActivity = new HttpActivity(jSHttpRequest);
                Object object = HttpActivitiesModel.this.lock;
                synchronized (object) {
                    if (jSHttpRequest.isLoadTriggeredByUser()) {
                        HttpActivitiesModel.this.activityList.clear();
                        HttpActivitiesModel.this.id2ActivityMap.clear();
                    }
                    HttpActivitiesModel.this.id2ActivityMap.put(jSHttpMessage.getId(), httpActivity);
                    HttpActivitiesModel.this.activityList.add(httpActivity);
                }
            } else {
                HttpActivity httpActivity = (HttpActivity)HttpActivitiesModel.this.id2ActivityMap.get(jSHttpMessage.getId());
                if (httpActivity == null) {
                    LOG.warning("Activity should not be null for response:" + jSHttpMessage);
                    return;
                }
                if (jSHttpMessage instanceof JSHttpResponse) {
                    httpActivity.setResponse((JSHttpResponse)jSHttpMessage);
                } else if (jSHttpMessage instanceof JSHttpProgress) {
                    httpActivity.updateProgress((JSHttpProgress)jSHttpMessage);
                }
            }
            HttpActivitiesModel.this.fireModelChange();
        }
    }
}

