/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.http.ui;

import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.javascript.debugger.http.ui.models.HttpActivitiesModel;
import org.netbeans.modules.web.client.javascript.debugger.http.ui.models.HttpActivitiesWrapper;
import org.netbeans.modules.web.client.javascript.debugger.models.NbJSPreferences;

public class HttpMonitorUtility {
    private static final NbJSPreferences NbJSPREF = NbJSPreferences.getInstance();

    public static boolean isEnabled() {
        return NbJSPREF.getHttpMonitorEnabled();
    }

    public static void setEnabled(boolean bl) {
        NbJSPREF.setHttpMonitorEnabled(bl);
    }

    public static void setHttpMonitorOpened(boolean bl) {
        NbJSPREF.setHttpMonitorOpened(bl);
    }

    public static Session getCurrentSession() {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        Session session = debuggerManager.getCurrentSession();
        if (session != null && HttpMonitorUtility.isJSDebuggerSession(session)) {
            return session;
        }
        Session[] sessionArray = debuggerManager.getSessions();
        if (sessionArray.length > 0) {
            for (Session session2 : sessionArray) {
                if (!HttpMonitorUtility.isJSDebuggerSession(session2)) continue;
                return session2;
            }
        }
        return null;
    }

    public static boolean isJSDebuggerSession(Session session) {
        DebuggerEngine debuggerEngine = session.getCurrentEngine();
        if (debuggerEngine == null) {
            return false;
        }
        NbJSDebugger nbJSDebugger = (NbJSDebugger)debuggerEngine.lookupFirst(null, NbJSDebugger.class);
        return nbJSDebugger != null && nbJSDebugger.supportsHttpMonitor();
    }

    public static HttpActivitiesModel getCurrentHttpMonitorModel() {
        HttpActivitiesWrapper httpActivitiesWrapper;
        Session session = HttpMonitorUtility.getCurrentSession();
        if (session != null && (httpActivitiesWrapper = (HttpActivitiesWrapper)session.lookupFirst(null, HttpActivitiesWrapper.class)) != null) {
            return httpActivitiesWrapper.getModel();
        }
        return null;
    }
}

