/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.api;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.web.client.javascript.debugger.NbJSDebuggerEngineProvider;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.javascript.debugger.models.NbJSBreakpointModel;
import org.netbeans.modules.web.client.javascript.debugger.models.NbJSCallStackModel;
import org.netbeans.modules.web.client.javascript.debugger.models.NbJSSessionsModel;
import org.netbeans.modules.web.client.javascript.debugger.models.NbJSThreadsModel;
import org.netbeans.modules.web.client.javascript.debugger.models.NbJSVariablesModel;
import org.netbeans.modules.web.client.javascript.debugger.models.NbJSWatchesModel;
import org.netbeans.modules.web.client.tools.api.JSToNbJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NbJSContextProviderWrapper {
    private static Map<ContextProvider, WeakReference<NbJSContextProviderWrapper>> instances = new WeakHashMap<ContextProvider, WeakReference<NbJSContextProviderWrapper>>();
    private ContextProvider contextProvider;
    private static NbJSBreakpointModel breakpointModel;
    private static NbJSSessionsModel sessionsModel;
    private NbJSDebugger debugger;
    private NbJSToJSLocationMapper nbJSToJSLocation;
    private JSToNbJSLocationMapper jsToNbJSLocation;
    private NbJSCallStackModel callStackModel;
    private NbJSVariablesModel variablesModel;
    private NbJSWatchesModel watchesModel;
    private NbJSThreadsModel threadsModel;

    public static synchronized NbJSContextProviderWrapper getContextProviderWrapper(ContextProvider contextProvider) {
        NbJSContextProviderWrapper nbJSContextProviderWrapper;
        WeakReference<NbJSContextProviderWrapper> weakReference = instances.get(contextProvider);
        NbJSContextProviderWrapper nbJSContextProviderWrapper2 = nbJSContextProviderWrapper = weakReference != null ? (NbJSContextProviderWrapper)weakReference.get() : null;
        if (nbJSContextProviderWrapper == null) {
            nbJSContextProviderWrapper = new NbJSContextProviderWrapper(contextProvider);
            instances.put(contextProvider, new WeakReference<NbJSContextProviderWrapper>(nbJSContextProviderWrapper));
        }
        return nbJSContextProviderWrapper;
    }

    private NbJSContextProviderWrapper(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    private static <T> List<? extends T> debugLookup(String string, Class<T> clazz) {
        return DebuggerManager.getDebuggerManager().lookup(string, clazz);
    }

    static <T> T lookupFirst(ContextProvider contextProvider, Class<T> clazz) {
        return (T)contextProvider.lookupFirst(null, clazz);
    }

    public void fireModelChanges() {
        this.getThreadsModel().fireChanges();
        this.getCallStackModel().fireTreeChanges();
        this.getVariablesModel().fireChanges();
        this.getWatchesModel().fireChanges();
        NbJSContextProviderWrapper.getBreakpointModel().fireChanges();
        NbJSContextProviderWrapper.getSessionsModel().fireChanges();
    }

    public static NbJSBreakpointModel getBreakpointModel() {
        if (breakpointModel == null) {
            List<TableModel> list = NbJSContextProviderWrapper.debugLookup("BreakpointsView", TableModel.class);
            for (TableModel tableModel : list) {
                if (!(tableModel instanceof NbJSBreakpointModel)) continue;
                breakpointModel = (NbJSBreakpointModel)tableModel;
                break;
            }
        }
        return breakpointModel;
    }

    public static NbJSSessionsModel getSessionsModel() {
        if (sessionsModel == null) {
            List<TableModelFilter> list = NbJSContextProviderWrapper.debugLookup("SessionsView", TableModelFilter.class);
            for (TableModelFilter tableModelFilter : list) {
                if (!(tableModelFilter instanceof NbJSSessionsModel)) continue;
                sessionsModel = (NbJSSessionsModel)tableModelFilter;
                break;
            }
        }
        return sessionsModel;
    }

    public Session getSession() {
        return NbJSContextProviderWrapper.lookupFirst(this.contextProvider, Session.class);
    }

    public NbJSDebuggerEngineProvider getNbJSDebuggerEngineProvider() {
        for (DebuggerEngineProvider debuggerEngineProvider : this.contextProvider.lookup(null, DebuggerEngineProvider.class)) {
            if (!(debuggerEngineProvider instanceof NbJSDebuggerEngineProvider)) continue;
            return (NbJSDebuggerEngineProvider)debuggerEngineProvider;
        }
        return null;
    }

    public NbJSDebugger getNbJSDebugger() {
        if (this.debugger == null) {
            this.debugger = NbJSContextProviderWrapper.lookupFirst(this.contextProvider, NbJSDebugger.class);
        }
        return this.debugger;
    }

    public NbJSToJSLocationMapper getNbJSToJSLocation() {
        if (this.nbJSToJSLocation == null) {
            this.nbJSToJSLocation = NbJSContextProviderWrapper.lookupFirst(this.contextProvider, NbJSToJSLocationMapper.class);
        }
        return this.nbJSToJSLocation;
    }

    public JSToNbJSLocationMapper getJSToNbJSLocation() {
        if (this.jsToNbJSLocation == null) {
            this.jsToNbJSLocation = NbJSContextProviderWrapper.lookupFirst(this.contextProvider, JSToNbJSLocationMapper.class);
        }
        return this.jsToNbJSLocation;
    }

    public NbJSThreadsModel getThreadsModel() {
        if (this.threadsModel == null) {
            this.threadsModel = (NbJSThreadsModel)this.contextProvider.lookupFirst("ThreadsView", TreeModel.class);
        }
        return this.threadsModel;
    }

    public NbJSCallStackModel getCallStackModel() {
        if (this.callStackModel == null) {
            this.callStackModel = (NbJSCallStackModel)this.contextProvider.lookupFirst("CallStackView", TreeModel.class);
        }
        return this.callStackModel;
    }

    public NbJSVariablesModel getVariablesModel() {
        if (this.variablesModel == null) {
            this.variablesModel = (NbJSVariablesModel)this.contextProvider.lookupFirst("LocalsView", TreeModel.class);
        }
        return this.variablesModel;
    }

    public NbJSWatchesModel getWatchesModel() {
        if (this.watchesModel == null) {
            this.watchesModel = (NbJSWatchesModel)this.contextProvider.lookupFirst("WatchesView", TreeModel.class);
        }
        return this.watchesModel;
    }
}

