/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletWrapper;

class SSLRequiredHandler
extends ServletWrapper {
    SSLRequiredHandler() {
        this.initialized = true;
        this.internal = true;
        this.name = "tomcat.sslRequiredHandler";
    }

    public void doService(Request req, Response res) throws Exception {
        Context ctx = req.getContext();
        ContextManager cm = ctx.getContextManager();
        int secureP = cm.getSecurePort();
        if (secureP <= 0) {
            res.setStatus(403);
            StringBuffer body = new StringBuffer();
            body.append("<h1>SSL required to access this page</H1>");
            res.setContentLength(body.length());
            if (res.isUsingStream()) {
                ServletOutputStream out = res.getOutputStream();
                out.print(body.toString());
                out.flush();
            } else {
                PrintWriter out = res.getWriter();
                out.print(body);
                out.flush();
            }
        } else {
            StringBuffer securePage = new StringBuffer();
            securePage.append("https://").append(req.getServerName());
            securePage.append(":").append(secureP);
            securePage.append(req.getRequestURI());
            String qS = req.getQueryString();
            if (qS != null) {
                securePage.append("?").append(qS);
            }
            req.setAttribute("javax.servlet.error.message", securePage.toString());
            this.contextM.handleStatus(req, res, 302);
            return;
        }
    }
}

