/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernateweb.framework;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernateweb.framework.HibernateConfigurationPanel;
import org.netbeans.modules.hibernateweb.framework.Util;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateWebModuleExtender
extends WebModuleExtender {
    private HibernateConfigurationPanel configPanel = null;
    private static final String DEFAULT_CONFIG_FILENAME = "hibernate.cfg";
    private final String dialect = "hibernate.dialect";
    private final String driver = "hibernate.connection.driver_class";
    private final String url = "hibernate.connection.url";
    private final String userName = "hibernate.connection.username";
    private final String password = "hibernate.connection.password";
    private Logger logger = Logger.getLogger(HibernateWebModuleExtender.class.getName());
    private final Set listeners = new HashSet(1);

    public HibernateWebModuleExtender(boolean bl, WebModule webModule, ExtenderController extenderController) {
        this.configPanel = new HibernateConfigurationPanel(this, extenderController, bl);
        if (!bl) {
            this.showConfigPanelForCustomizer(webModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireChangeEvent() {
        Iterator iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent((Object)this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }

    public JComponent getComponent() {
        return this.configPanel;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void update() {
    }

    public boolean isValid() {
        return this.configPanel.isPanelValid();
    }

    public Set<FileObject> extend(WebModule webModule) {
        Project project = Util.getEnclosingProjectFromWebModule(webModule);
        Sources sources = ProjectUtils.getSources((Project)project);
        try {
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("resources");
            if (sourceGroupArray == null || sourceGroupArray.length == 0) {
                sourceGroupArray = sources.getSourceGroups("java");
            }
            if (sourceGroupArray != null && sourceGroupArray.length != 0) {
                FileObject fileObject = sourceGroupArray[0].getRootFolder();
                CreateHibernateConfiguration createHibernateConfiguration = new CreateHibernateConfiguration(fileObject, project);
                fileObject.getFileSystem().runAtomicAction((FileSystem.AtomicAction)createHibernateConfiguration);
                return createHibernateConfiguration.getCreatedFiles();
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return Collections.EMPTY_SET;
    }

    private void showConfigPanelForCustomizer(WebModule webModule) {
        Project project = Util.getEnclosingProjectFromWebModule(webModule);
        HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        List list = hibernateEnvironment.getAllHibernateConfigFileObjects();
        for (FileObject fileObject : list) {
            if (fileObject.getName().equals(DEFAULT_CONFIG_FILENAME)) {
                try {
                    HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)DataObject.find((FileObject)fileObject);
                    SessionFactory sessionFactory = hibernateCfgDataObject.getHibernateConfiguration().getSessionFactory();
                    int n = 0;
                    for (String string : sessionFactory.getProperty2()) {
                        String string2;
                        if ("hibernate.dialect".contains(string2 = sessionFactory.getAttributeValue("Property2", n++, "name"))) {
                            this.configPanel.setDialect(string);
                        }
                        if (!"hibernate.connection.url".contains(string2)) continue;
                        this.configPanel.setDatabaseConnection(string);
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            }
            this.configPanel.disable();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CreateHibernateConfiguration
    implements FileSystem.AtomicAction {
        private FileObject targetFolder;
        private Project enclosingProject;
        private Set<FileObject> createdFilesSet = new LinkedHashSet<FileObject>();

        public CreateHibernateConfiguration(FileObject fileObject, Project project) {
            this.targetFolder = fileObject;
            this.enclosingProject = project;
        }

        public Set<FileObject> getCreatedFiles() {
            return this.createdFilesSet;
        }

        public void run() throws IOException {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)this.targetFolder);
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Hibernate/Hibernate.cfg.xml");
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, HibernateWebModuleExtender.DEFAULT_CONFIG_FILENAME);
            SessionFactory sessionFactory = new SessionFactory();
            int n = 0;
            if (HibernateWebModuleExtender.this.configPanel.getSelectedDialect() != null && !"".equals(HibernateWebModuleExtender.this.configPanel.getSelectedDialect())) {
                n = sessionFactory.addProperty2(HibernateWebModuleExtender.this.configPanel.getSelectedDialect());
                sessionFactory.setAttributeValue("Property2", n, "name", "hibernate.dialect");
            }
            if (HibernateWebModuleExtender.this.configPanel.getSelectedDriver() != null && !"".equals(HibernateWebModuleExtender.this.configPanel.getSelectedDriver())) {
                n = sessionFactory.addProperty2(HibernateWebModuleExtender.this.configPanel.getSelectedDriver());
                sessionFactory.setAttributeValue("Property2", n, "name", "hibernate.connection.driver_class");
            }
            if (HibernateWebModuleExtender.this.configPanel.getSelectedURL() != null && !"".equals(HibernateWebModuleExtender.this.configPanel.getSelectedURL())) {
                n = sessionFactory.addProperty2(HibernateWebModuleExtender.this.configPanel.getSelectedURL());
                sessionFactory.setAttributeValue("Property2", n, "name", "hibernate.connection.url");
            }
            if (HibernateWebModuleExtender.this.configPanel.getUserName() != null && !"".equals(HibernateWebModuleExtender.this.configPanel.getUserName())) {
                n = sessionFactory.addProperty2(HibernateWebModuleExtender.this.configPanel.getUserName());
                sessionFactory.setAttributeValue("Property2", n, "name", "hibernate.connection.username");
            }
            if (HibernateWebModuleExtender.this.configPanel.getPassword() != null && !"".equals(HibernateWebModuleExtender.this.configPanel.getPassword())) {
                n = sessionFactory.addProperty2(HibernateWebModuleExtender.this.configPanel.getPassword());
                sessionFactory.setAttributeValue("Property2", n, "name", "hibernate.connection.password");
            }
            HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)dataObject2;
            hibernateCfgDataObject.addSessionFactory(sessionFactory);
            hibernateCfgDataObject.save();
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.enclosingProject.getLookup().lookup(HibernateEnvironment.class);
            HibernateWebModuleExtender.this.logger.info("Library registered : " + hibernateEnvironment.addHibernateLibraryToProject(hibernateCfgDataObject.getPrimaryFile()));
            if (!hibernateEnvironment.canLoadDBDriver(hibernateCfgDataObject.getHibernateConfiguration())) {
                HibernateWebModuleExtender.this.logger.info("DB Driver not registered with the project. Registering now..");
                HibernateWebModuleExtender.this.logger.info("DB Driver registered : " + hibernateEnvironment.registerDBDriver(HibernateWebModuleExtender.this.configPanel.getSelectedDriver(), hibernateCfgDataObject.getPrimaryFile()));
            }
            this.createdFilesSet.add(hibernateCfgDataObject.getPrimaryFile());
        }
    }
}

