/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.spi.settings.DOMConvertor;
import org.netbeans.spi.settings.Saver;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TargetModuleConverter
extends DOMConvertor {
    private static final String PUBLIC_ID = "-//org_netbeans_modules_j2ee//DTD TargetModule 1.0//EN";
    private static final String SYSTEM_ID = "nbres:/org/netbeans/modules/j2ee/deployment/impl/target-module.dtd";
    private static final String E_TARGET_MODULE_LIST = "target-module-list";
    private static final String E_TARGET_MODULE = "target-module";
    private static final String A_ID = "id";
    private static final String A_INSTANCE_URL = "instance-url";
    private static final String A_TARGET_NAME = "target-name";
    private static final String A_TIMESTAMP = "timestamp";
    private static final String A_CONTENT_DIR = "content-dir";
    private static final String A_CONTEXT_ROOT = "context-root";
    private static final String DIR_TARGETMODULES = "TargetModules";
    private static FileObject targetModulesDir = null;

    public static DOMConvertor create() {
        return new TargetModuleConverter();
    }

    protected TargetModuleConverter() {
        super(PUBLIC_ID, SYSTEM_ID, E_TARGET_MODULE_LIST);
    }

    protected Object readElement(Element element) throws IOException, ClassNotFoundException {
        NodeList nodeList = element.getElementsByTagName(E_TARGET_MODULE);
        TargetModule[] targetModuleArray = new TargetModule[nodeList.getLength()];
        for (int i = 0; i < targetModuleArray.length; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute(A_ID);
            String string2 = element2.getAttribute(A_INSTANCE_URL);
            String string3 = element2.getAttribute(A_TARGET_NAME);
            String string4 = element2.getAttribute(A_TIMESTAMP);
            String string5 = element2.getAttribute(A_CONTENT_DIR);
            String string6 = element2.getAttribute(A_CONTEXT_ROOT);
            if (string == null || string2 == null || string3 == null) {
                throw new IOException(NbBundle.getMessage(TargetModuleConverter.class, (String)"MSG_TargetModuleParseError"));
            }
            try {
                targetModuleArray[i] = new TargetModule(string, string2, string3, Long.parseLong(string4), string5, string6);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                IOException iOException = new IOException();
                iOException.initCause(numberFormatException);
                throw iOException;
            }
        }
        return new TargetModule.List(targetModuleArray);
    }

    protected void writeElement(Document document, Element element, Object object) throws IOException, DOMException {
        if (object == null) {
            return;
        }
        if (!(object instanceof TargetModule.List)) {
            throw new DOMException(9, NbBundle.getMessage(TargetModuleConverter.class, (String)"MSG_NotSupportedObject", object.getClass()));
        }
        TargetModule.List list = (TargetModule.List)object;
        TargetModule[] targetModuleArray = list.getTargetModules();
        for (int i = 0; i < targetModuleArray.length; ++i) {
            Element element2 = document.createElement(E_TARGET_MODULE);
            element2.setAttribute(A_ID, targetModuleArray[i].getId());
            element2.setAttribute(A_INSTANCE_URL, targetModuleArray[i].getInstanceUrl());
            element2.setAttribute(A_TARGET_NAME, targetModuleArray[i].getTargetName());
            element2.setAttribute(A_TIMESTAMP, String.valueOf(targetModuleArray[i].getTimestamp()));
            element2.setAttribute(A_CONTENT_DIR, targetModuleArray[i].getContentDirectory());
            element2.setAttribute(A_CONTEXT_ROOT, targetModuleArray[i].getContextRoot());
            element.appendChild(element2);
        }
    }

    public void registerSaver(Object object, Saver saver) {
    }

    public void unregisterSaver(Object object, Saver saver) {
    }

    private static FileObject getTargetModulesDir() throws IOException {
        FileObject fileObject;
        if (targetModulesDir == null && (targetModulesDir = (fileObject = Repository.getDefault().getDefaultFileSystem().findResource("/J2EE")).getFileObject(DIR_TARGETMODULES)) == null) {
            targetModulesDir = fileObject.createFolder(DIR_TARGETMODULES);
        }
        return targetModulesDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeTargetModule(TargetModule targetModule, String string, String string2, String string3) {
        boolean bl;
        FileLock fileLock = null;
        Writer writer = null;
        try {
            try {
                FileObject fileObject;
                FileObject fileObject2 = TargetModuleConverter.getTargetModulesDir().getFileObject(string);
                if (fileObject2 == null) {
                    fileObject2 = TargetModuleConverter.getTargetModulesDir().createFolder(string);
                }
                if ((fileObject = fileObject2.getFileObject(string2)) == null) {
                    fileObject = fileObject2.createFolder(string2);
                }
                FileObject fileObject3 = FileUtil.createData((FileObject)fileObject, (String)string3);
                fileLock = fileObject3.lock();
                writer = new OutputStreamWriter(fileObject3.getOutputStream(fileLock));
                TargetModuleConverter.create().write(writer, (Object)new TargetModule.List(targetModule));
                bl = true;
                Object var11_12 = null;
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.WARNING, null, exception);
                boolean bl2 = false;
                Object var11_13 = null;
                try {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                    if (writer == null) return bl2;
                    writer.close();
                    return bl2;
                }
                catch (Exception exception3) {
                    Logger.getLogger("global").log(Level.WARNING, null, exception3);
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            try {}
            catch (Exception exception2) {
                Logger.getLogger("global").log(Level.WARNING, null, exception2);
                throw throwable;
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            if (writer == null) throw throwable;
            writer.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.WARNING, null, exception);
            return bl;
        }
        if (fileLock != null) {
            fileLock.releaseLock();
        }
        if (writer == null) return bl;
        writer.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static TargetModule readTargetModule(String string, String string2, String string3) {
        FileObject fileObject;
        Reader reader;
        block17: {
            TargetModule.List list;
            block18: {
                reader = null;
                FileObject fileObject2 = TargetModuleConverter.getTargetModulesDir().getFileObject(string);
                if (fileObject2 == null || (fileObject2 = fileObject2.getFileObject(string2)) == null || (fileObject = fileObject2.getFileObject(string3)) == null) break block17;
                reader = new InputStreamReader(fileObject.getInputStream());
                list = (TargetModule.List)TargetModuleConverter.create().read(reader);
                if (list != null && list.getTargetModules().length >= 1) break block18;
                TargetModule targetModule = null;
                Object var9_10 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.WARNING, null, exception);
                }
                return targetModule;
            }
            TargetModule targetModule = list.getTargetModules()[0];
            Object var9_11 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.WARNING, null, exception);
            }
            return targetModule;
        }
        fileObject = null;
        Object var9_12 = null;
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.WARNING, null, exception);
        }
        return fileObject;
        catch (Exception exception) {
            try {
                Logger.getLogger("global").log(Level.WARNING, null, exception);
                fileObject = null;
                Object var9_13 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception2) {
                    Logger.getLogger("global").log(Level.WARNING, null, exception2);
                }
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception3) {
                Logger.getLogger("global").log(Level.WARNING, null, exception3);
            }
            return fileObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List getTargetModulesByContextRoot(String string, String string2, String string3) {
        Reader reader;
        block15: {
            FileObject fileObject;
            reader = null;
            FileObject fileObject2 = TargetModuleConverter.getTargetModulesDir().getFileObject(string);
            if (fileObject2 == null || (fileObject2 = fileObject2.getFileObject(string2)) == null) break block15;
            Enumeration enumeration = fileObject2.getChildren(false);
            FileObject fileObject3 = new ArrayList();
            while (enumeration.hasMoreElements()) {
                TargetModule targetModule;
                fileObject = (FileObject)enumeration.nextElement();
                reader = new InputStreamReader(fileObject.getInputStream());
                TargetModule.List list = (TargetModule.List)TargetModuleConverter.create().read(reader);
                if (list == null || list.getTargetModules().length <= 0 || !string3.equals((targetModule = list.getTargetModules()[0]).getContextRoot())) continue;
                fileObject3.add(targetModule);
            }
            fileObject = fileObject3;
            Object var11_13 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.WARNING, null, exception);
            }
            return fileObject;
        }
        List list = Collections.EMPTY_LIST;
        Object var11_14 = null;
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.WARNING, null, exception);
        }
        return list;
        catch (Exception exception) {
            List list2;
            try {
                Logger.getLogger("global").log(Level.WARNING, null, exception);
                list2 = Collections.EMPTY_LIST;
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception2) {
                    Logger.getLogger("global").log(Level.WARNING, null, exception2);
                }
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception3) {
                Logger.getLogger("global").log(Level.WARNING, null, exception3);
            }
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TargetModule remove(String string, String string2, String string3) {
        FileObject fileObject;
        FileLock fileLock = null;
        try {
            try {
                FileObject fileObject2 = TargetModuleConverter.getTargetModulesDir().getFileObject(string);
                if (fileObject2 != null && (fileObject2 = fileObject2.getFileObject(string2)) != null && (fileObject = fileObject2.getFileObject(string3)) != null) {
                    fileLock = fileObject.lock();
                    fileObject.delete(fileLock);
                }
                fileObject = null;
                Object var7_8 = null;
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.WARNING, null, exception);
                TargetModule targetModule = null;
                Object var7_9 = null;
                try {
                    if (fileLock == null) return targetModule;
                    fileLock.releaseLock();
                    return targetModule;
                }
                catch (Exception exception3) {
                    Logger.getLogger("global").log(Level.WARNING, null, exception3);
                }
                return targetModule;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {}
            catch (Exception exception2) {
                Logger.getLogger("global").log(Level.WARNING, null, exception2);
                throw throwable;
            }
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.WARNING, null, exception);
            return fileObject;
        }
        if (fileLock == null) return fileObject;
        fileLock.releaseLock();
        return fileObject;
    }
}

