/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.remote.CommandProvider;
import org.openide.util.Lookup;

public class VersionCommand {
    private final Tool tool;
    private final String path;
    private boolean alreadyRun;
    private String version;

    public VersionCommand(Tool tool, String string) {
        this.tool = tool;
        this.path = string;
    }

    public String getVersion() {
        if (!this.alreadyRun) {
            this.run();
        }
        return this.version;
    }

    private void run() {
        if ("localhost".equals(this.tool.getHostKey())) {
            File file = new File(this.path);
            if (file.exists()) {
                ProcessBuilder processBuilder = new ProcessBuilder(this.path, this.getVersionFlags());
                processBuilder.redirectErrorStream(true);
                try {
                    Process process = processBuilder.start();
                    this.version = this.extractVersion(process.getInputStream());
                }
                catch (IOException iOException) {}
            }
        } else {
            CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
            if (commandProvider != null) {
                commandProvider.run(this.tool.getHostKey(), this.path + " " + this.getVersionFlags() + " 2>&1", Collections.EMPTY_MAP);
                this.version = this.extractVersion(new StringReader(commandProvider.getOutput()));
            }
        }
        this.alreadyRun = true;
    }

    private String getVersionFlags() {
        String string = null;
        if (this.tool.getDescriptor() != null) {
            string = this.tool.getDescriptor().getVersionFlags();
        }
        if (string == null) {
            return "--version";
        }
        return string;
    }

    private String extractVersion(InputStream inputStream) {
        return this.extractVersion(new InputStreamReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractVersion(Reader reader) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            return string;
        }
        catch (IOException iOException) {
            String string = null;
            return string;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

