/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.remote.ServerUpdateCache;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.modules.cnd.ui.options.AddCompilerSetPanel;
import org.netbeans.modules.cnd.ui.options.DuplicateCompilerSetPanel;
import org.netbeans.modules.cnd.ui.options.GlobalToolsPanelModel;
import org.netbeans.modules.cnd.ui.options.IsChangedListener;
import org.netbeans.modules.cnd.ui.options.ToolsPanelModel;
import org.netbeans.modules.cnd.ui.options.VersionCommand;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolsPanel
extends JPanel
implements ActionListener,
DocumentListener,
ListSelectionListener,
ItemListener {
    private final String MAKE_NAME = "make";
    private final String GDB_NAME = "gdb";
    private final String C_NAME = "C";
    private final String CPP_NAME = "C++";
    private final String FORTRAN_NAME = "Fortran";
    public static final String PROP_VALID = "valid";
    private boolean initialized = false;
    private boolean changed;
    private boolean changingCompilerSet;
    private boolean updating;
    private boolean valid;
    private ToolsPanelModel model = null;
    private Color tfColor = null;
    private boolean gdbEnabled;
    private String hkey;
    private static ToolsPanel instance = null;
    private CompilerSetManager csm;
    private HashMap<String, CompilerSetManager> copiedManagers = new HashMap();
    private CompilerSet currentCompilerSet;
    private ServerList serverList;
    private ServerUpdateCache serverUpdateCache;
    private static final Logger log = Logger.getLogger("cnd.remote.logger");
    static Set<ChangeListener> listenerChanged = new HashSet<ChangeListener>();
    static Set<ChangeListener> listenerModified = new HashSet<ChangeListener>();
    static Set<IsChangedListener> listenerIsChanged = new HashSet<IsChangedListener>();
    private JPanel ToolSetPanel;
    private JButton btAdd;
    private JButton btBaseDirectory;
    private JButton btCBrowse;
    private JButton btCppBrowse;
    private JButton btDebuggerBrowse;
    private JButton btDefault;
    private JButton btDuplicate;
    private JButton btEditDevHost;
    private JButton btFortranBrowse;
    private JButton btMakeBrowse;
    private JButton btRemove;
    private JButton btRestore;
    private JButton btVersions;
    private JPanel buttomPanel;
    private JPanel buttonPanel;
    private JCheckBox cbCRequired;
    private JCheckBox cbCppRequired;
    private JComboBox cbDevHost;
    private JComboBox cbFamily;
    private JCheckBox cbFortranRequired;
    private JCheckBox cbGdbRequired;
    private JCheckBox cbMakeRequired;
    private JLabel lbBaseDirectory;
    private JLabel lbCCommand;
    private JLabel lbCppCommand;
    private JLabel lbDevHost;
    private JLabel lbFamily;
    private JLabel lbFortranCommand;
    private JLabel lbGdbCommand;
    private JLabel lbMakeCommand;
    private JLabel lbToolCollections;
    private JLabel lblErrors;
    private JList lstDirlist;
    private JLabel requiredToolsLabel;
    private JPanel requiredToolsPanel;
    private JScrollPane spDirlist;
    private JTextField tfBaseDirectory;
    private JTextField tfCPath;
    private JTextField tfCppPath;
    private JTextField tfFortranPath;
    private JTextField tfGdbPath;
    private JTextField tfMakePath;

    public ToolsPanel() {
        this.initComponents();
        this.setName("TAB_ToolsTab");
        this.cbGdbRequired.setName("gdb");
        this.cbCRequired.setName("c");
        this.cbCppRequired.setName("c++");
        this.cbFortranRequired.setName("fortran");
        this.changed = false;
        instance = this;
        this.currentCompilerSet = null;
        this.serverUpdateCache = null;
        this.serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class);
        if (this.serverList != null) {
            this.hkey = this.serverList.getDefaultRecord().getName();
            this.btEditDevHost.setEnabled(true);
            this.cbDevHost.setEnabled(true);
        } else {
            this.hkey = "localhost";
        }
        this.lstDirlist.setCellRenderer(new MyCellRenderer());
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(false);
        }
        HelpCtx.setHelpIDString((JComponent)this, (String)"ResolveBuildTools");
    }

    public ToolsPanel(ToolsPanelModel toolsPanelModel) {
        this();
        this.model = toolsPanelModel;
    }

    private void initialize() {
        if (instance == null) {
            instance = this;
        }
        this.changingCompilerSet = true;
        if (this.model == null) {
            this.model = new GlobalToolsPanelModel();
        }
        if (!this.model.showRequiredTools()) {
            this.requiredToolsLabel.setVisible(false);
            this.requiredToolsPanel.setVisible(false);
        }
        this.cbDevHost.removeItemListener(this);
        if (this.serverUpdateCache != null) {
            log.fine("TP.initialize: Initializing from serverUpdateCache");
            this.cbDevHost.removeAllItems();
            for (String string : this.serverUpdateCache.getHostKeyList()) {
                this.cbDevHost.addItem(string);
            }
            this.cbDevHost.setSelectedIndex(this.serverUpdateCache.getDefaultIndex());
            log.fine("TP.initialize: Done");
        } else if (this.serverList != null) {
            log.fine("TP.initialize: Initializing from serverList");
            this.cbDevHost.removeAllItems();
            for (String string : this.serverList.getServerNames()) {
                this.cbDevHost.addItem(string);
            }
            this.cbDevHost.setSelectedIndex(this.serverList.getDefaultIndex());
            log.fine("TP.initialize: Done");
        } else {
            log.fine("TP.initialize: Initializing to \"localhost\"");
            this.cbDevHost.addItem("localhost");
            this.cbDevHost.setSelectedIndex(0);
            log.fine("TP.initialize: Done");
        }
        if (this.model.getSelectedDevelopmentHost() != null) {
            this.cbDevHost.setSelectedItem(this.model.getSelectedDevelopmentHost());
        }
        this.cbDevHost.setRenderer(new MyDevHostListCellRenderer());
        this.cbDevHost.addItemListener(this);
        this.cbDevHost.setEnabled(this.model.getEnableDevelopmentHostChange());
        this.btEditDevHost.setEnabled(this.model.getEnableDevelopmentHostChange());
        this.hkey = (String)this.cbDevHost.getSelectedItem();
        this.btBaseDirectory.setEnabled(false);
        this.btCBrowse.setEnabled(false);
        this.btCppBrowse.setEnabled(false);
        this.btFortranBrowse.setEnabled(false);
        this.btMakeBrowse.setEnabled(false);
        this.btDebuggerBrowse.setEnabled(false);
        this.btVersions.setEnabled(false);
        this.tfMakePath.setEditable(false);
        this.tfGdbPath.setEditable(false);
        this.btVersions.setEnabled(false);
        if (this.model.enableRequiredCompilerCB()) {
            this.cbCRequired.setEnabled(true);
            this.cbCppRequired.setEnabled(true);
            this.cbFortranRequired.setEnabled(true);
        } else {
            this.cbCRequired.setEnabled(false);
            this.cbCppRequired.setEnabled(false);
            this.cbFortranRequired.setEnabled(false);
        }
        this.csm = this.getCompilerSetManagerCopy(this.hkey);
        this.gdbEnabled = !IpeUtils.isDbxguiEnabled();
        boolean bl = CppSettings.getDefault().isFortranEnabled();
        this.lbFortranCommand.setVisible(bl);
        this.tfFortranPath.setVisible(bl);
        this.btFortranBrowse.setVisible(bl);
        this.cbFortranRequired.setVisible(bl);
        this.cbMakeRequired.setSelected(this.model.isMakeRequired());
        this.cbGdbRequired.setSelected(this.model.isGdbRequired());
        this.cbCRequired.setSelected(this.model.isCRequired());
        this.cbCppRequired.setSelected(this.model.isCppRequired());
        this.cbFortranRequired.setSelected(this.model.isFortranRequired());
    }

    private void addCompilerSet() {
        AddCompilerSetPanel addCompilerSetPanel = new AddCompilerSetPanel(this.csm);
        String string = this.isRemoteHostSelected() ? ToolsPanel.getString("NEW_TOOL_SET_TITLE_REMOTE", this.csm.getHost()) : ToolsPanel.getString("NEW_TOOL_SET_TITLE");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addCompilerSetPanel, string);
        addCompilerSetPanel.setDialogDescriptor(dialogDescriptor);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        CompilerSet compilerSet = addCompilerSetPanel.getCompilerSet();
        this.csm.add(compilerSet);
        this.changed = true;
        this.update(false, compilerSet);
    }

    private void duplicateCompilerSet() {
        CompilerSet compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        DuplicateCompilerSetPanel duplicateCompilerSetPanel = new DuplicateCompilerSetPanel(this.csm, compilerSet);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)duplicateCompilerSetPanel, ToolsPanel.getString("COPY_TOOL_SET_TITLE"));
        duplicateCompilerSetPanel.setDialogDescriptor(dialogDescriptor);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        String string = duplicateCompilerSetPanel.getCompilerSetName().trim();
        CompilerSet compilerSet2 = compilerSet.createCopy();
        compilerSet2.setName(string);
        compilerSet2.setAsDefault(false);
        compilerSet2.setAutoGenerated(false);
        this.csm.add(compilerSet2);
        this.changed = true;
        this.update(false, compilerSet2);
    }

    private void onCompilerSetChanged() {
        boolean bl = this.model.showRequiredTools() ? this.lstDirlist.getSelectedIndex() >= 0 : this.csm.getCompilerSets().size() > 1 && this.lstDirlist.getSelectedIndex() >= 0;
        this.changeCompilerSet((CompilerSet)this.lstDirlist.getSelectedValue());
        this.btAdd.setEnabled(this.isHostValidForEditing());
        this.btRemove.setEnabled(bl && this.isHostValidForEditing());
        this.btDuplicate.setEnabled(this.lstDirlist.getSelectedIndex() >= 0 && this.isHostValidForEditing());
        this.btDefault.setEnabled(this.lstDirlist.getSelectedIndex() >= 0 && !((CompilerSet)this.lstDirlist.getSelectedValue()).isDefault());
    }

    private void onNewDevHostSelected() {
        if (!this.hkey.equals((String)this.cbDevHost.getSelectedItem())) {
            log.fine("TP.itemStateChanged: About to update");
            this.changed = true;
            if (this.serverUpdateCache == null) {
                this.serverUpdateCache = new ServerUpdateCache();
                String[] stringArray = new String[this.cbDevHost.getItemCount()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)this.cbDevHost.getItemAt(i);
                }
                this.serverUpdateCache.setHostKeyList(stringArray);
            }
            this.serverUpdateCache.setDefaultIndex(this.cbDevHost.getSelectedIndex());
            this.hkey = (String)this.cbDevHost.getSelectedItem();
            this.model.setSelectedDevelopmentHost(this.hkey);
            this.update(true);
        } else {
            this.update(false);
        }
    }

    private void removeCompilerSet() {
        CompilerSet compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        if (compilerSet != null) {
            int n = this.csm.getCompilerSets().indexOf(compilerSet);
            this.csm.remove(compilerSet);
            if (compilerSet.isDefault() && this.csm.getCompilerSets().size() > 0) {
                this.csm.getCompilerSet(0).setAsDefault(true);
            }
            if (n >= 0 && n < this.csm.getCompilerSets().size()) {
                this.update(false, this.csm.getCompilerSets().get(n));
            } else if (n > 0) {
                this.update(false, this.csm.getCompilerSets().get(n - 1));
            } else {
                this.tfBaseDirectory.setText("");
                this.btBaseDirectory.setEnabled(false);
                this.cbFamily.removeAllItems();
                this.tfCPath.setText("");
                this.tfCppPath.setText("");
                this.tfFortranPath.setText("");
                this.tfMakePath.setText("");
                this.tfGdbPath.setText("");
                this.update(false);
            }
            this.changed = true;
        }
    }

    private void saveCompileSetManagers(List<String> list) {
        ArrayList<CompilerSetManager> arrayList = new ArrayList<CompilerSetManager>();
        for (String string : this.copiedManagers.keySet()) {
            if (list != null && !list.contains(string)) continue;
            arrayList.add(this.copiedManagers.get(string));
        }
        CompilerSetManager.setDefaults(arrayList);
        this.copiedManagers.clear();
    }

    private void setSelectedAsDefault() {
        CompilerSet compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        this.csm.setDefault(compilerSet);
        this.changed = true;
        this.update(false);
    }

    private void setMakePathField(String string) {
        this.tfMakePath.setText(string);
    }

    private void validateMakePathField() {
        this.setPathFieldValid(this.tfMakePath, this.isPathFieldValid(this.tfMakePath) && this.supportedMake(this.tfMakePath));
        this.dataValid();
    }

    private void setGdbPathField(String string) {
        this.tfGdbPath.setText(string);
    }

    private void validateGdbPathField() {
        this.setPathFieldValid(this.tfGdbPath, this.isPathFieldValid(this.tfGdbPath));
        this.dataValid();
    }

    private void setCPathField(String string) {
        this.tfCPath.setText(string);
    }

    private void validateCPathField() {
        this.setPathFieldValid(this.tfCPath, this.isPathFieldValid(this.tfCPath));
        this.dataValid();
    }

    private void setCppPathField(String string) {
        this.tfCppPath.setText(string);
    }

    private void validateCppPathField() {
        this.setPathFieldValid(this.tfCppPath, this.isPathFieldValid(this.tfCppPath));
        this.dataValid();
    }

    private void setFortranPathField(String string) {
        this.tfFortranPath.setText(string);
    }

    private void validateFortranPathField() {
        this.setPathFieldValid(this.tfFortranPath, this.isPathFieldValid(this.tfFortranPath));
        this.dataValid();
    }

    public static boolean supportedMake(String string) {
        return !(string = IpeUtils.getBaseName(string)).toLowerCase().equals("mingw32-make.exe");
    }

    private boolean supportedMake(JTextField jTextField) {
        String string = jTextField.getText();
        if (string.length() == 0) {
            return false;
        }
        return ToolsPanel.supportedMake(string);
    }

    private boolean isPathFieldValid(JTextField jTextField) {
        String string = jTextField.getText();
        if (string.length() == 0) {
            return false;
        }
        if (this.hkey.equals("localhost")) {
            File file = new File(string);
            boolean bl = false;
            boolean bl2 = bl = file.exists() && !file.isDirectory();
            if (!bl) {
                String string2;
                ArrayList<String> arrayList = Path.getPath();
                Iterator<String> iterator = arrayList.iterator();
                while (iterator.hasNext() && !(bl = (file = new File((string2 = iterator.next()) + File.separatorChar + string)).exists() && !file.isDirectory())) {
                }
            }
            return bl;
        }
        return true;
    }

    private void setPathFieldValid(JTextField jTextField, boolean bl) {
        if (bl) {
            jTextField.setForeground(this.tfColor);
        } else {
            jTextField.setForeground(Color.RED);
        }
    }

    public void update() {
        this.update(true, null);
    }

    private void update(boolean bl) {
        this.update(bl, null);
    }

    public void update(boolean bl, CompilerSet compilerSet) {
        this.updating = true;
        if (!this.initialized || bl) {
            this.initialize();
        }
        this.lbGdbCommand.setVisible(this.gdbEnabled);
        this.tfGdbPath.setVisible(this.gdbEnabled);
        this.btDebuggerBrowse.setVisible(this.gdbEnabled);
        this.cbMakeRequired.setVisible(this.model.showRequiredBuildTools());
        this.cbGdbRequired.setVisible(this.model.showRequiredDebugTools() && this.gdbEnabled);
        this.cbCppRequired.setVisible(this.model.showRequiredBuildTools());
        this.cbCRequired.setVisible(this.model.showRequiredBuildTools());
        this.cbFortranRequired.setVisible(this.model.showRequiredBuildTools() && CppSettings.getDefault().isFortranEnabled());
        if (bl && !this.csm.getCompilerSets().isEmpty()) {
            String string = this.model.getCompilerSetName();
            if (string.length() == 0 || this.csm.getCompilerSet(string) == null) {
                this.csm.getCompilerSet(0).setAsDefault(true);
            } else {
                this.csm.setDefault(this.csm.getCompilerSet(string));
            }
            String string2 = this.model.getSelectedCompilerSetName();
            if (string2 != null) {
                compilerSet = this.csm.getCompilerSet(string2);
            }
            if (compilerSet == null) {
                compilerSet = this.csm.getDefaultCompilerSet();
            }
        }
        if (compilerSet == null) {
            compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        }
        this.lstDirlist.setListData(this.csm.getCompilerSets().toArray());
        if (compilerSet != null) {
            this.lstDirlist.setSelectedValue(compilerSet, true);
        }
        if (this.lstDirlist.getSelectedIndex() < 0) {
            this.lstDirlist.setSelectedIndex(0);
        }
        this.lstDirlist.invalidate();
        this.lstDirlist.repaint();
        this.onCompilerSetChanged();
        this.updating = false;
        this.dataValid();
        this.initialized = true;
    }

    private boolean isRemoteHostSelected() {
        return this.serverList == null ? false : this.serverList.get((String)this.cbDevHost.getSelectedItem()).isRemote();
    }

    private boolean isHostValidForEditing() {
        return true;
    }

    private void changeCompilerSet(CompilerSet compilerSet) {
        Object object;
        Object object2;
        Object object3;
        if (compilerSet != null) {
            this.tfBaseDirectory.setText(compilerSet.getDirectory());
            this.btBaseDirectory.setEnabled(!this.isRemoteHostSelected());
            this.cbFamily.removeAllItems();
            object3 = CompilerSet.CompilerFlavor.getFlavors(this.csm.getPlatform());
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                this.cbFamily.addItem(object);
            }
        } else {
            this.cbFamily.removeAllItems();
            ServerRecord serverRecord = null;
            if (this.serverList != null) {
                serverRecord = this.serverList.get(this.hkey);
            }
            boolean bl = this.serverList == null || serverRecord != null && serverRecord.isOnline();
            String string = "";
            if (!bl) {
                string = NbBundle.getMessage(ToolsPanel.class, (String)"TP_ErrorMessage_BadDevHost", (Object)this.hkey);
            }
            this.lblErrors.setText("<html>" + string + "</html>");
            this.updateToolsControls(false, false, false, true);
            return;
        }
        this.cbFamily.setSelectedItem(compilerSet.getCompilerFlavor());
        if (this.currentCompilerSet != null && this.currentCompilerSet != compilerSet) {
            object3 = this.currentCompilerSet.findTool(0);
            ((Tool)object3).setPath(this.tfCPath.getText());
            object3 = this.currentCompilerSet.findTool(1);
            ((Tool)object3).setPath(this.tfCppPath.getText());
            object3 = this.currentCompilerSet.findTool(2);
            ((Tool)object3).setPath(this.tfFortranPath.getText());
            object3 = this.currentCompilerSet.findTool(5);
            ((Tool)object3).setPath(this.tfMakePath.getText());
            object3 = this.currentCompilerSet.findTool(6);
            ((Tool)object3).setPath(this.tfGdbPath.getText());
        }
        this.changingCompilerSet = true;
        object3 = compilerSet.getTool(0);
        object2 = compilerSet.getTool(1);
        object = compilerSet.getTool(2);
        Tool tool = compilerSet.getTool(5);
        Tool tool2 = compilerSet.getTool(6);
        if (object3 != null) {
            this.setCPathField(((Tool)object3).getPath());
        } else {
            this.tfCPath.setText("");
        }
        if (object2 != null) {
            this.setCppPathField(((Tool)object2).getPath());
        } else {
            this.tfCppPath.setText("");
        }
        if (object != null) {
            this.setFortranPathField(((Tool)object).getPath());
        } else {
            this.tfFortranPath.setText("");
        }
        this.setMakePathField(tool.getPath());
        this.setGdbPathField(tool2.getPath());
        this.changingCompilerSet = false;
        this.currentCompilerSet = compilerSet;
        this.fireCompilerSetChange();
        this.dataValid();
    }

    public void applyChanges(boolean bl) {
        this.changed = bl;
        this.applyChanges();
    }

    public void applyChanges() {
        if (this.changed || this.isChangedInOtherPanels()) {
            ArrayList<String> arrayList = null;
            if (this.serverList != null) {
                if (this.serverUpdateCache != null) {
                    arrayList = new ArrayList<String>();
                    this.serverList.clear();
                    for (String string : this.serverUpdateCache.getHostKeyList()) {
                        this.serverList.addServer(string, false, false);
                        arrayList.add(string);
                    }
                    this.serverList.setDefaultIndex(this.serverUpdateCache.getDefaultIndex());
                    this.serverUpdateCache = null;
                } else {
                    this.serverList.setDefaultIndex(this.cbDevHost.getSelectedIndex());
                }
            }
            String[] stringArray = (String[])this.lstDirlist.getSelectedValue();
            this.changed = false;
            if (stringArray != null) {
                stringArray.getTool(5).setPath(this.tfMakePath.getText());
                stringArray.getTool(6).setPath(this.tfGdbPath.getText());
                stringArray.getTool(0).setPath(this.tfCPath.getText());
                stringArray.getTool(1).setPath(this.tfCppPath.getText());
                stringArray.getTool(2).setPath(this.tfFortranPath.getText());
                this.model.setCompilerSetName(this.csm.getDefaultCompilerSet().getName());
                this.model.setSelectedCompilerSetName(stringArray.getName());
            }
            this.saveCompileSetManagers(arrayList);
            this.currentCompilerSet = stringArray;
        }
        if (this.model != null) {
            if (this.model.isGdbRequired() != this.cbGdbRequired.isSelected()) {
                this.model.setGdbRequired(this.cbGdbRequired.isSelected());
            }
            if (this.model.isCRequired() != this.cbCRequired.isSelected()) {
                this.model.setCRequired(this.cbCRequired.isSelected());
            }
            if (this.model.isCppRequired() != this.cbCppRequired.isSelected()) {
                this.model.setCppRequired(this.cbCppRequired.isSelected());
            }
            if (this.model.isFortranRequired() != this.cbFortranRequired.isSelected()) {
                this.model.setFortranRequired(this.cbFortranRequired.isSelected());
            }
        }
        instance = null;
    }

    public void cancel() {
        this.serverUpdateCache = null;
        this.changed = false;
        instance = null;
    }

    public static ToolsPanel getToolsPanel() {
        return instance;
    }

    public synchronized CompilerSetManager getCompilerSetManagerCopy(String string) {
        CompilerSetManager compilerSetManager = this.copiedManagers.get(string);
        if (compilerSetManager == null) {
            compilerSetManager = CompilerSetManager.getDefault(string).deepCopy();
            if (compilerSetManager.getCompilerSets().size() == 1 && compilerSetManager.getCompilerSets().get(0).getName().equals("None")) {
                compilerSetManager.remove(compilerSetManager.getCompilerSets().get(0));
            }
            this.copiedManagers.put(string, compilerSetManager);
        }
        return compilerSetManager;
    }

    public CompilerSet getCurrentCompilerSet() {
        return this.currentCompilerSet;
    }

    public boolean dataValid() {
        boolean bl;
        int n;
        boolean bl2;
        boolean bl3;
        if (this.csm.getCompilerSets().size() == 0) {
            this.valid = false;
            this.firePropertyChange(PROP_VALID, !this.valid, this.valid);
            return false;
        }
        if (this.updating || this.changingCompilerSet) {
            return true;
        }
        boolean bl4 = bl3 = this.csm.getCompilerSets().size() > 0;
        boolean bl5 = this.cbMakeRequired.isSelected() ? this.isPathFieldValid(this.tfMakePath) && this.supportedMake(this.tfMakePath) : true;
        boolean bl6 = this.cbGdbRequired.isSelected() ? this.isPathFieldValid(this.tfGdbPath) : true;
        boolean bl7 = this.cbCRequired.isSelected() ? this.isPathFieldValid(this.tfCPath) : true;
        boolean bl8 = this.cbCppRequired.isSelected() ? this.isPathFieldValid(this.tfCppPath) : true;
        boolean bl9 = this.cbFortranRequired.isSelected() ? this.isPathFieldValid(this.tfFortranPath) : true;
        ServerRecord serverRecord = null;
        if (this.serverList != null) {
            serverRecord = this.serverList.get(this.hkey);
        }
        boolean bl10 = bl2 = this.serverList == null || serverRecord != null && serverRecord.isOnline();
        if (!this.initialized) {
            this.valid = !bl3 || !bl5 || !bl6 || !bl7 || !bl8 || !bl9 || !bl2;
        }
        if (this.valid != (bl3 && bl5 && bl6 && bl7 && bl8 && bl9 && bl2)) {
            this.valid = !this.valid;
            this.firePropertyChange(PROP_VALID, !this.valid, this.valid);
        }
        this.lblErrors.setText("<html>");
        if (!this.valid) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!bl2) {
                arrayList.add(NbBundle.getMessage(ToolsPanel.class, (String)"TP_ErrorMessage_BadDevHost", (Object)this.hkey));
            }
            if (this.cbMakeRequired.isSelected() && !bl5) {
                if (!this.isPathFieldValid(this.tfMakePath)) {
                    arrayList.add(NbBundle.getBundle(ToolsPanel.class).getString("TP_ErrorMessage_MissedMake"));
                } else {
                    arrayList.add(NbBundle.getMessage(ToolsPanel.class, (String)"TP_ErrorMessage_UnsupportedMake", (Object)"mingw32-make"));
                }
            }
            if (this.cbCRequired.isSelected() && !bl7) {
                arrayList.add(NbBundle.getBundle(ToolsPanel.class).getString("TP_ErrorMessage_MissedCCompiler"));
            }
            if (this.cbCppRequired.isSelected() && !bl8) {
                arrayList.add(NbBundle.getBundle(ToolsPanel.class).getString("TP_ErrorMessage_MissedCppCompiler"));
            }
            if (this.cbGdbRequired.isSelected() && !bl6 && this.gdbEnabled) {
                arrayList.add(NbBundle.getBundle(ToolsPanel.class).getString("TP_ErrorMessage_MissedDebugger"));
            }
            if (this.cbFortranRequired.isSelected() && !bl9) {
                arrayList.add(NbBundle.getBundle(ToolsPanel.class).getString("TP_ErrorMessage_MissedFortranCompiler"));
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < arrayList.size(); ++n) {
                stringBuilder.append((String)arrayList.get(n));
                if (n >= arrayList.size() - 1) continue;
                stringBuilder.append("<br>");
            }
            this.lblErrors.setText("<html>" + stringBuilder.toString() + "</html>");
            this.validate();
            this.repaint();
        }
        boolean bl11 = (bl = new File(this.tfBaseDirectory.getText()).exists()) || this.isRemoteHostSelected() && this.isHostValidForEditing();
        n = bl && !this.isRemoteHostSelected() ? 1 : 0;
        boolean bl12 = (bl || this.isRemoteHostSelected()) && this.isHostValidForEditing();
        this.updateToolsControls(bl11, n != 0, bl12, false);
        return this.valid;
    }

    private void updateToolsControls(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.btCBrowse.setEnabled(bl2);
        this.btCppBrowse.setEnabled(bl2);
        this.btFortranBrowse.setEnabled(bl2);
        this.btMakeBrowse.setEnabled(bl2);
        this.btDebuggerBrowse.setEnabled(bl2);
        this.btVersions.setEnabled(bl3);
        this.updateTextField(this.tfMakePath, bl, bl4);
        this.updateTextField(this.tfGdbPath, bl, bl4);
        this.updateTextField(this.tfBaseDirectory, bl, bl4);
        this.updateTextField(this.tfCPath, bl, bl4);
        this.updateTextField(this.tfCppPath, bl, bl4);
        this.updateTextField(this.tfFortranPath, bl, bl4);
    }

    private void updateTextField(JTextField jTextField, boolean bl, boolean bl2) {
        if (bl2) {
            jTextField.setText("");
        }
        jTextField.setEditable(bl);
    }

    public boolean isChanged() {
        return this.changed;
    }

    String getToolVersion(Tool tool, JTextField jTextField) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tool.getDisplayName() + ": ");
        if (this.isPathFieldValid(jTextField)) {
            String string;
            String string2 = jTextField.getText();
            if (!IpeUtils.isPathAbsolute(string2)) {
                string2 = Path.findCommand(string2);
            }
            if ((string = this.postVersionInfo(tool, string2)) != null) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append(ToolsPanel.getString("TOOL_VERSION_NOT_FOUND"));
            }
        } else {
            stringBuilder.append(ToolsPanel.getString("TOOL_NOT_FOUND"));
        }
        return stringBuilder.toString();
    }

    private String postVersionInfo(Tool tool, String string) {
        if (string == null) {
            return null;
        }
        return new VersionCommand(tool, string).getVersion();
    }

    public static void addCompilerSetChangeListener(ChangeListener changeListener) {
        listenerChanged.add(changeListener);
    }

    public static void removeCompilerSetChangeListener(ChangeListener changeListener) {
        listenerChanged.remove(changeListener);
    }

    public void fireCompilerSetChange() {
        ChangeEvent changeEvent = new ChangeEvent(this.currentCompilerSet);
        for (ChangeListener changeListener : listenerChanged) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public static void addCompilerSetModifiedListener(ChangeListener changeListener) {
        listenerModified.add(changeListener);
    }

    public static void removeCompilerSetModifiedListener(ChangeListener changeListener) {
        listenerModified.remove(changeListener);
    }

    public void fireCompilerSetModified() {
        ChangeEvent changeEvent = new ChangeEvent(this.currentCompilerSet);
        for (ChangeListener changeListener : listenerModified) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public static void addIsChangedListener(IsChangedListener isChangedListener) {
        listenerIsChanged.add(isChangedListener);
    }

    public static void removeIsChangedListener(IsChangedListener isChangedListener) {
        listenerIsChanged.remove(isChangedListener);
    }

    private boolean isChangedInOtherPanels() {
        boolean bl = false;
        for (IsChangedListener isChangedListener : listenerIsChanged) {
            if (!isChangedListener.isChanged()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.btAdd) {
                this.addCompilerSet();
            } else if (object == this.btRemove) {
                this.removeCompilerSet();
            } else if (object == this.btDuplicate) {
                this.duplicateCompilerSet();
            } else if (object == this.btEditDevHost) {
                this.editDevHosts();
            } else if (object == this.btDefault) {
                this.setSelectedAsDefault();
            } else if (object == this.btMakeBrowse || object == this.btDebuggerBrowse || object == this.btCBrowse || object == this.btCppBrowse || object == this.btFortranBrowse) {
                // empty if block
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (!this.updating) {
            if (object == this.cbDevHost && itemEvent.getStateChange() == 1) {
                this.onNewDevHostSelected();
            } else if (object instanceof JCheckBox && !this.changingCompilerSet) {
                this.dataValid();
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        Document document;
        String string;
        if (!this.updating) {
            this.changed = true;
        }
        if ((string = (String)(document = documentEvent.getDocument()).getProperty("title")).equals("make")) {
            this.validateMakePathField();
        } else if (string.equals("gdb")) {
            this.validateGdbPathField();
        } else if (string.equals("C")) {
            this.validateCPathField();
        } else if (string.equals("C++")) {
            this.validateCppPathField();
        } else if (string.equals("Fortran")) {
            this.validateFortranPathField();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && !this.updating && listSelectionEvent.getSource() == this.lstDirlist) {
            this.onCompilerSetChanged();
        }
    }

    private void editDevHosts() {
        assert (this.serverList != null);
        ServerUpdateCache serverUpdateCache = this.serverList.show(this.serverUpdateCache);
        if (serverUpdateCache != null) {
            this.changed = !this.equalsLists(this.serverUpdateCache, serverUpdateCache);
            this.serverUpdateCache = serverUpdateCache;
            this.cbDevHost.removeItemListener(this);
            log.fine("TP.editDevHosts: Removing all items from cbDevHost");
            this.cbDevHost.removeAllItems();
            log.fine("TP.editDevHosts: Adding " + this.serverUpdateCache.getHostKeyList().length + " items to cbDevHost");
            for (String string : this.serverUpdateCache.getHostKeyList()) {
                log.fine("    Adding " + string);
                this.cbDevHost.addItem(string);
            }
            log.fine("TP.editDevHosts: cbDevHost has " + this.cbDevHost.getItemCount() + " items");
            log.fine("TP.editDevHosts: serverUpdateCache.getDefaultIndex returns " + this.serverUpdateCache.getDefaultIndex());
            this.cbDevHost.setSelectedIndex(this.serverUpdateCache.getDefaultIndex());
            String string = (String)this.cbDevHost.getSelectedItem();
            if (string != null) {
                this.serverList.get(string);
            } else {
                log.fine("TP.editDevHosts: No selection found");
            }
            this.cbDevHost.addItemListener(this);
            this.onNewDevHostSelected();
        }
    }

    private boolean equalsLists(ServerUpdateCache serverUpdateCache, ServerUpdateCache serverUpdateCache2) {
        String[] stringArray;
        if (serverUpdateCache == serverUpdateCache2) {
            return true;
        }
        if (serverUpdateCache == null || serverUpdateCache2 == null) {
            return false;
        }
        if (serverUpdateCache.getDefaultIndex() != serverUpdateCache2.getDefaultIndex()) {
            return false;
        }
        String[] stringArray2 = serverUpdateCache.getHostKeyList();
        if (stringArray2.length != (stringArray = serverUpdateCache2.getHostKeyList()).length) {
            return false;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            String string2 = stringArray2[i];
            if (string.equals(string2)) continue;
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.lbToolCollections = new JLabel();
        this.lbMakeCommand = new JLabel();
        this.tfMakePath = new JTextField();
        this.tfMakePath.getDocument().putProperty("title", "make");
        this.tfMakePath.getDocument().addDocumentListener(this);
        this.btMakeBrowse = new JButton();
        this.btMakeBrowse.addActionListener(this);
        this.lbGdbCommand = new JLabel();
        this.tfGdbPath = new JTextField();
        this.tfGdbPath.getDocument().putProperty("title", "gdb");
        this.tfGdbPath.getDocument().addDocumentListener(this);
        this.btDebuggerBrowse = new JButton();
        this.btDebuggerBrowse.addActionListener(this);
        this.lbCCommand = new JLabel();
        this.tfCPath = new JTextField();
        this.tfCPath.getDocument().putProperty("title", "C");
        this.tfCPath.getDocument().addDocumentListener(this);
        this.btCBrowse = new JButton();
        this.btCBrowse.addActionListener(this);
        this.lbCppCommand = new JLabel();
        this.tfCppPath = new JTextField();
        this.tfCppPath.getDocument().putProperty("title", "C++");
        this.tfCppPath.getDocument().addDocumentListener(this);
        this.btCppBrowse = new JButton();
        this.btCppBrowse.addActionListener(this);
        this.lbFortranCommand = new JLabel();
        this.tfFortranPath = new JTextField();
        this.tfFortranPath.getDocument().putProperty("title", "Fortran");
        this.tfFortranPath.getDocument().addDocumentListener(this);
        this.btFortranBrowse = new JButton();
        this.btFortranBrowse.addActionListener(this);
        this.lbFamily = new JLabel();
        this.requiredToolsLabel = new JLabel();
        this.requiredToolsPanel = new JPanel();
        this.cbMakeRequired = new JCheckBox();
        this.cbGdbRequired = new JCheckBox();
        this.cbGdbRequired.addItemListener(this);
        this.cbCRequired = new JCheckBox();
        this.cbCRequired.addItemListener(this);
        this.cbCppRequired = new JCheckBox();
        this.cbCppRequired.addItemListener(this);
        this.cbFortranRequired = new JCheckBox();
        this.cbFortranRequired.addItemListener(this);
        this.lbBaseDirectory = new JLabel();
        this.tfBaseDirectory = new JTextField();
        this.btBaseDirectory = new JButton();
        this.btVersions = new JButton();
        this.buttomPanel = new JPanel();
        this.lblErrors = new JLabel();
        this.btRestore = new JButton();
        this.ToolSetPanel = new JPanel();
        this.spDirlist = new JScrollPane(this.lstDirlist);
        this.lstDirlist = new JList();
        this.buttonPanel = new JPanel();
        this.btAdd = new JButton();
        this.btAdd.addActionListener(this);
        this.btRemove = new JButton();
        this.btRemove.addActionListener(this);
        this.btDuplicate = new JButton();
        this.btDuplicate.addActionListener(this);
        this.btDefault = new JButton();
        this.btDefault.addActionListener(this);
        this.cbFamily = new JComboBox();
        this.lbDevHost = new JLabel();
        this.cbDevHost = new JComboBox();
        this.cbDevHost.addItemListener(this);
        this.btEditDevHost = new JButton();
        this.btEditDevHost.addActionListener(this);
        this.setMinimumSize(new Dimension(600, 400));
        this.setLayout(new GridBagLayout());
        this.lbToolCollections.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_DirlistLabel").charAt(0));
        this.lbToolCollections.setLabelFor(this.spDirlist);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle");
        this.lbToolCollections.setText(resourceBundle.getString("LBL_DirlistLabel"));
        this.lbToolCollections.setToolTipText(resourceBundle.getString("HINT_DirListLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 0, 4);
        this.add((Component)this.lbToolCollections, gridBagConstraints);
        this.lbToolCollections.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_DirlistLabel"));
        this.lbToolCollections.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_DirlistLabel"));
        this.lbMakeCommand.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_MakeCommand").charAt(0));
        this.lbMakeCommand.setLabelFor(this.tfMakePath);
        this.lbMakeCommand.setText(resourceBundle.getString("LBL_MakeCommand"));
        this.lbMakeCommand.setToolTipText(resourceBundle.getString("HINT_MakeCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 10, 0, 0);
        this.add((Component)this.lbMakeCommand, gridBagConstraints);
        this.lbMakeCommand.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_MakeCommand"));
        this.lbMakeCommand.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_MakeCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 2, 0, 0);
        this.add((Component)this.tfMakePath, gridBagConstraints);
        this.tfMakePath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.tfMakePath.AccessibleContext.accessibleDescription"));
        this.btMakeBrowse.setText(resourceBundle.getString("LBL_MakeVersion"));
        this.btMakeBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btMakeBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.add((Component)this.btMakeBrowse, gridBagConstraints);
        this.btMakeBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btMakeVersion.AccessibleContext.accessibleDescription"));
        this.lbGdbCommand.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_GdbCommand").charAt(0));
        this.lbGdbCommand.setLabelFor(this.tfGdbPath);
        this.lbGdbCommand.setText(resourceBundle.getString("LBL_GdbCommand"));
        this.lbGdbCommand.setToolTipText(resourceBundle.getString("HINT_GdbCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbGdbCommand, gridBagConstraints);
        this.lbGdbCommand.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_GdbCommand"));
        this.lbGdbCommand.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_GdbCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfGdbPath, gridBagConstraints);
        this.tfGdbPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.tfGdbPath.AccessibleContext.accessibleDescription"));
        this.btDebuggerBrowse.setText(resourceBundle.getString("LBL_GdbVersion"));
        this.btDebuggerBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btDebuggerBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btDebuggerBrowse, gridBagConstraints);
        this.btDebuggerBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btGdbVersion.AccessibleContext.accessibleDescription"));
        this.lbCCommand.setLabelFor(this.tfCPath);
        this.lbCCommand.setText(resourceBundle.getString("LBL_CCommand"));
        this.lbCCommand.setToolTipText(resourceBundle.getString("HINT_CCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbCCommand, gridBagConstraints);
        this.lbCCommand.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CCommand"));
        this.lbCCommand.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CCommand"));
        this.tfCPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfCPath, gridBagConstraints);
        this.btCBrowse.setText(resourceBundle.getString("LBL_CVersion"));
        this.btCBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btCBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btCBrowse, gridBagConstraints);
        this.btCBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btCVersion.AccessibleContext.accessibleDescription"));
        this.lbCppCommand.setLabelFor(this.tfCppPath);
        this.lbCppCommand.setText(resourceBundle.getString("LBL_CppCommand"));
        this.lbCppCommand.setToolTipText(resourceBundle.getString("HINT_CppCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbCppCommand, gridBagConstraints);
        this.lbCppCommand.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CppCommand"));
        this.lbCppCommand.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CppCommand"));
        this.tfCppPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfCppPath, gridBagConstraints);
        this.btCppBrowse.setText(resourceBundle.getString("LBL_CppVersion"));
        this.btCppBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btCppBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btCppBrowse, gridBagConstraints);
        this.btCppBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btCppVersion.AccessibleContext.accessibleDescription"));
        this.lbFortranCommand.setLabelFor(this.tfFortranPath);
        this.lbFortranCommand.setText(resourceBundle.getString("LBL_FortranCommand"));
        this.lbFortranCommand.setToolTipText(resourceBundle.getString("HINT_FortranCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbFortranCommand, gridBagConstraints);
        this.lbFortranCommand.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_FortranCommand"));
        this.lbFortranCommand.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_FortranCommand"));
        this.tfFortranPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfFortranPath, gridBagConstraints);
        this.btFortranBrowse.setText(resourceBundle.getString("LBL_FortranVersion"));
        this.btFortranBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btFortranBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btFortranBrowse, gridBagConstraints);
        this.btFortranBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btFortranVersion.AccessibleContext.accessibleDescription"));
        this.lbFamily.setLabelFor(this.cbFamily);
        this.lbFamily.setText(resourceBundle.getString("LBL_CompilerCollection"));
        this.lbFamily.setToolTipText(resourceBundle.getString("HINT_CompilerCollection"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.lbFamily, gridBagConstraints);
        this.lbFamily.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CompilerCollection"));
        this.lbFamily.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CompilerCollection"));
        this.requiredToolsLabel.setLabelFor(this.cbMakeRequired);
        this.requiredToolsLabel.setText(resourceBundle.getString("LBL_RequiredTools"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 10, 0, 0);
        this.add((Component)this.requiredToolsLabel, gridBagConstraints);
        this.requiredToolsPanel.setLayout(new GridBagLayout());
        this.cbMakeRequired.setSelected(true);
        this.cbMakeRequired.setText(resourceBundle.getString("LBL_RequiredMake"));
        this.cbMakeRequired.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.requiredToolsPanel.add((Component)this.cbMakeRequired, gridBagConstraints);
        this.cbGdbRequired.setText(resourceBundle.getString("LBL_RequiredGdb"));
        this.cbGdbRequired.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.requiredToolsPanel.add((Component)this.cbGdbRequired, gridBagConstraints);
        this.cbCRequired.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_CCompiler_CB").charAt(0));
        this.cbCRequired.setText(resourceBundle.getString("LBL_RequiredCompiler_C"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.requiredToolsPanel.add((Component)this.cbCRequired, gridBagConstraints);
        this.cbCppRequired.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_CppCompiler_CB").charAt(0));
        this.cbCppRequired.setText(resourceBundle.getString("LBL_RequiredCompiler_Cpp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.requiredToolsPanel.add((Component)this.cbCppRequired, gridBagConstraints);
        this.cbFortranRequired.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_FortranCompiler_CB").charAt(0));
        this.cbFortranRequired.setText(resourceBundle.getString("LBL_RequiredCompiler_Fortran"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.requiredToolsPanel.add((Component)this.cbFortranRequired, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 2, 0, 6);
        this.add((Component)this.requiredToolsPanel, gridBagConstraints);
        this.lbBaseDirectory.setLabelFor(this.tfBaseDirectory);
        this.lbBaseDirectory.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lbBaseDirectory.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbBaseDirectory, gridBagConstraints);
        this.tfBaseDirectory.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 2, 0, 0);
        this.add((Component)this.tfBaseDirectory, gridBagConstraints);
        this.tfBaseDirectory.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.tfBaseDirectory.AccessibleContext.accessibleDescription"));
        this.btBaseDirectory.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btBaseDirectory.text"));
        this.btBaseDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btBaseDirectoryActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btBaseDirectory, gridBagConstraints);
        this.btBaseDirectory.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btBaseDirectory.AccessibleContext.accessibleDescription"));
        this.btVersions.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_Versions").charAt(0));
        this.btVersions.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btVersions.text"));
        this.btVersions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btVersionsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.add((Component)this.btVersions, gridBagConstraints);
        this.btVersions.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btVersions.AccessibleContext.accessibleDescription"));
        this.buttomPanel.setOpaque(false);
        this.buttomPanel.setLayout(new BoxLayout(this.buttomPanel, 2));
        this.lblErrors.setForeground(new Color(255, 51, 51));
        this.lblErrors.setHorizontalAlignment(2);
        this.lblErrors.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lblErrors.text"));
        this.lblErrors.setEnabled(false);
        this.lblErrors.setFocusable(false);
        this.buttomPanel.add(this.lblErrors);
        this.lblErrors.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lblErrors.AccessibleContext.accessibleName"));
        this.btRestore.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_RestoreDefault_BT").charAt(0));
        this.btRestore.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btRestore.text"));
        this.btRestore.setHorizontalAlignment(4);
        this.btRestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btRestoreActionPerformed(actionEvent);
            }
        });
        this.buttomPanel.add(this.btRestore);
        this.btRestore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btRestore.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.buttomPanel, gridBagConstraints);
        this.ToolSetPanel.setOpaque(false);
        this.ToolSetPanel.setLayout(new GridBagLayout());
        this.spDirlist.setMinimumSize(new Dimension(180, 20));
        this.spDirlist.setPreferredSize(new Dimension(180, 20));
        this.lstDirlist.setSelectionMode(0);
        this.lstDirlist.setAutoscrolls(false);
        this.lstDirlist.addListSelectionListener(this);
        this.spDirlist.setViewportView(this.lstDirlist);
        this.lstDirlist.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lstDirlist.AccessibleContext.accessibleName"));
        this.lstDirlist.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lstDirlist.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.ToolSetPanel.add((Component)this.spDirlist, gridBagConstraints);
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.btAdd.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_AddButton").charAt(0));
        this.btAdd.setText(resourceBundle.getString("LBL_AddButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.btAdd, gridBagConstraints);
        this.btAdd.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_AddButton"));
        this.btAdd.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_AddButton"));
        this.btRemove.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_RemoveButton").charAt(0));
        this.btRemove.setText(resourceBundle.getString("LBL_RemoveButton"));
        this.btRemove.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.btRemove, gridBagConstraints);
        this.btRemove.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_RemoveButton"));
        this.btRemove.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_RemoveButton"));
        this.btDuplicate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_UpButton").charAt(0));
        this.btDuplicate.setText(resourceBundle.getString("LBL_UpButton"));
        this.btDuplicate.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.buttonPanel.add((Component)this.btDuplicate, gridBagConstraints);
        this.btDuplicate.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_UpButton"));
        this.btDuplicate.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_UpButton"));
        this.btDefault.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_DownButton").charAt(0));
        this.btDefault.setText(resourceBundle.getString("LBL_DownButton"));
        this.btDefault.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.buttonPanel.add((Component)this.btDefault, gridBagConstraints);
        this.btDefault.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_DownButton"));
        this.btDefault.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_DownButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.ToolSetPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.ToolSetPanel, gridBagConstraints);
        this.cbFamily.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.cbFamily, gridBagConstraints);
        this.lbDevHost.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_DevelopmentHosts").charAt(0));
        this.lbDevHost.setLabelFor(this.cbDevHost);
        this.lbDevHost.setText(NbBundle.getMessage(ToolsPanel.class, (String)"LBL_DevelopmentHosts"));
        this.lbDevHost.setToolTipText(NbBundle.getMessage(ToolsPanel.class, (String)"HINT_DevelopmentHosts"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.add((Component)this.lbDevHost, gridBagConstraints);
        this.cbDevHost.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.cbDevHost, gridBagConstraints);
        this.btEditDevHost.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_AddDevHost").charAt(0));
        this.btEditDevHost.setText(NbBundle.getMessage(ToolsPanel.class, (String)"Lbl_AddDevHost"));
        this.btEditDevHost.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btEditDevHost, gridBagConstraints);
    }

    private void btVersionsActionPerformed(ActionEvent actionEvent) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)ToolsPanel.getString("LBL_VersionInfo_Progress"));
                progressHandle.start(ToolsPanel.this.gdbEnabled ? 5 : 4);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\n");
                stringBuilder.append(ToolsPanel.this.getToolVersion(ToolsPanel.this.currentCompilerSet.findTool(0), ToolsPanel.this.tfCPath) + "\n");
                progressHandle.progress(1);
                stringBuilder.append(ToolsPanel.this.getToolVersion(ToolsPanel.this.currentCompilerSet.findTool(1), ToolsPanel.this.tfCppPath) + "\n");
                progressHandle.progress(2);
                stringBuilder.append(ToolsPanel.this.getToolVersion(ToolsPanel.this.currentCompilerSet.findTool(2), ToolsPanel.this.tfFortranPath) + "\n");
                progressHandle.progress(3);
                stringBuilder.append(ToolsPanel.this.getToolVersion(ToolsPanel.this.currentCompilerSet.findTool(5), ToolsPanel.this.tfMakePath) + "\n");
                if (ToolsPanel.this.gdbEnabled) {
                    progressHandle.progress(4);
                    stringBuilder.append(ToolsPanel.this.getToolVersion(ToolsPanel.this.currentCompilerSet.findTool(6), ToolsPanel.this.tfGdbPath) + "\n");
                }
                progressHandle.finish();
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)stringBuilder.toString());
                message.setTitle(ToolsPanel.getString("LBL_VersionInfo_Title"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    private void btBaseDirectoryActionPerformed(ActionEvent actionEvent) {
        String string = null;
        string = this.tfBaseDirectory.getText().length() > 0 ? this.tfBaseDirectory.getText() : (FileChooser.getCurrectChooserFile() != null ? FileChooser.getCurrectChooserFile().getPath() : System.getProperty("user.home"));
        FileChooser fileChooser = new FileChooser(ToolsPanel.getString("SELECT_BASE_DIRECTORY_TITLE"), null, 1, null, string, true);
        int n = fileChooser.showOpenDialog(this);
        if (n == 1) {
            return;
        }
        String string2 = fileChooser.getSelectedFile().getPath();
        this.tfBaseDirectory.setText(string2);
        CompilerSet compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        CompilerSet.CompilerFlavor compilerFlavor = (CompilerSet.CompilerFlavor)this.cbFamily.getSelectedItem();
        this.csm.reInitCompilerSet(compilerSet, string2);
        this.changed = true;
        this.update(false);
    }

    private boolean selectCompiler(JTextField jTextField, Tool tool) {
        String string = this.tfBaseDirectory.getText();
        FileChooser fileChooser = new FileChooser(ToolsPanel.getString("SELECT_TOOL_TITLE"), null, 0, null, string, false);
        int n = fileChooser.showOpenDialog(this);
        if (n == 1) {
            return false;
        }
        if (!new File(new File(this.tfBaseDirectory.getText()), fileChooser.getSelectedFile().getName()).exists()) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)ToolsPanel.getString("COMPILER_BASE_ERROR"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return false;
        }
        jTextField.setText(fileChooser.getSelectedFile().getPath());
        tool.setPath(jTextField.getText());
        this.fireCompilerSetChange();
        this.fireCompilerSetModified();
        return true;
    }

    private boolean selectTool(JTextField jTextField) {
        String string = jTextField.getText();
        FileChooser fileChooser = new FileChooser(ToolsPanel.getString("SELECT_TOOL_TITLE"), null, 0, null, string, false);
        int n = fileChooser.showOpenDialog(this);
        if (n == 1) {
            return false;
        }
        jTextField.setText(fileChooser.getSelectedFile().getPath());
        return true;
    }

    private int getDefaultDevHostIndex() {
        int n = 0;
        if (this.serverUpdateCache != null) {
            n = this.serverUpdateCache.getDefaultIndex();
        } else if (this.serverList != null) {
            n = this.serverList.getDefaultIndex();
        }
        return n;
    }

    private void btCBrowseActionPerformed(ActionEvent actionEvent) {
        this.selectCompiler(this.tfCPath, this.currentCompilerSet.getTool(0));
    }

    private void btCppBrowseActionPerformed(ActionEvent actionEvent) {
        this.selectCompiler(this.tfCppPath, this.currentCompilerSet.getTool(1));
    }

    private void btFortranBrowseActionPerformed(ActionEvent actionEvent) {
        this.selectCompiler(this.tfFortranPath, this.currentCompilerSet.getTool(2));
    }

    private void btMakeBrowseActionPerformed(ActionEvent actionEvent) {
        this.selectTool(this.tfMakePath);
    }

    private void btDebuggerBrowseActionPerformed(ActionEvent actionEvent) {
        this.selectTool(this.tfGdbPath);
    }

    private void btRestoreActionPerformed(ActionEvent actionEvent) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)ToolsPanel.getString("RESTORE_TXT"), ToolsPanel.getString("RESTORE_TITLE"), 2);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (object != NotifyDescriptor.OK_OPTION) {
            return;
        }
        final CompilerSet[] compilerSetArray = new CompilerSet[]{(CompilerSet)this.lstDirlist.getSelectedValue()};
        Runnable runnable = new Runnable(){

            public void run() {
                Object object;
                String string;
                CompilerSet compilerSet2;
                CompilerSetManager compilerSetManager = CompilerSetManager.create(ToolsPanel.this.hkey);
                compilerSetManager.initialize(false);
                ToolsPanel.this.copiedManagers.put(ToolsPanel.this.hkey, compilerSetManager);
                List<CompilerSet> list = ToolsPanel.this.csm.getCompilerSets();
                for (CompilerSet compilerSet2 : list) {
                    if (compilerSet2.isAutoGenerated()) continue;
                    string = compilerSet2.getName();
                    if (!string.equals(object = compilerSetManager.getUniqueCompilerSetName(string))) {
                        compilerSet2.setName((String)object);
                    }
                    compilerSetManager.add(compilerSet2);
                }
                Object object2 = null;
                compilerSet2 = ToolsPanel.this.csm.getDefaultCompilerSet();
                if (compilerSet2 != null) {
                    object2 = compilerSet2.getName();
                }
                string = null;
                if (compilerSetArray[0] != null) {
                    string = compilerSetArray[0].getName();
                }
                ToolsPanel.this.csm = compilerSetManager;
                object = ToolsPanel.this.csm.getCompilerSet((String)object2);
                if (object != null) {
                    ToolsPanel.this.csm.setDefault((CompilerSet)object);
                }
                if (string != null) {
                    compilerSetArray[0] = ToolsPanel.this.csm.getCompilerSet(string);
                }
            }
        };
        Runnable runnable2 = new Runnable(){

            public void run() {
                ToolsPanel.this.changed = true;
                if (compilerSetArray[0] != null) {
                    ToolsPanel.this.update(false, compilerSetArray[0]);
                } else {
                    ToolsPanel.this.update(false);
                }
            }
        };
        Frame frame = WindowManager.getDefault().getMainWindow();
        String string = ToolsPanel.getString("TITLE_Configure");
        String string2 = ToolsPanel.getString("MSG_Configure_Compiler_Sets", this.hkey);
        ModalMessageDlg.runLongTask((Frame)frame, (Runnable)runnable, (Runnable)runnable2, (String)string, (String)string2);
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ToolsPanel.class, (String)string);
    }

    private static String getString(String string, Object object) {
        return NbBundle.getMessage(ToolsPanel.class, (String)string, (Object)object);
    }

    class MyDevHostListCellRenderer
    extends DefaultListCellRenderer {
        MyDevHostListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (n == ToolsPanel.this.getDefaultDevHostIndex()) {
                JLabel jLabel = (JLabel)component;
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }
            return component;
        }
    }

    class MyCellRenderer
    extends DefaultListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            CompilerSet compilerSet = (CompilerSet)object;
            if (compilerSet.isDefault()) {
                component.setFont(component.getFont().deriveFont(1));
            }
            return component;
        }
    }
}

