/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import org.netbeans.modules.cnd.makewizard.EnterItemsPanel;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.TargetData;

public class MakefileSourcesPanel
extends EnterItemsPanel {
    private String srcFilter;
    static final long serialVersionUID = -6961895016031819992L;
    private boolean initialized;
    private int key;

    public MakefileSourcesPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = new String(this.getString("LBL_MakefileSourcesPanel"));
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.initialized = false;
    }

    private void create() {
        String string;
        int n;
        if (this.getMakefileData().getMakefileType() == 4) {
            n = 189;
            string = this.getString("LBL_SourceNamesComplex");
        } else {
            n = 45;
            string = this.getString("LBL_SourceNamesSimple");
        }
        this.create(string, this.getString("MNEM_SourceNames").charAt(0), n);
    }

    protected String getListLabel() {
        return this.getString("LBL_SourceList");
    }

    protected char getListMnemonic() {
        return this.getString("MNEM_SourceList").charAt(0);
    }

    protected EnterItemsPanel.ErrorInfo getErrorInfo() {
        return new EnterItemsPanel.ErrorInfo(this.getString("DLG_NoFilesError"), this.getString("MSG_NoFilesMatched"));
    }

    public void validateData(ArrayList arrayList, int n) {
        TargetData targetData = this.getMakefileData().getTarget(n);
        String[] stringArray = targetData.getSourcesList();
        if (stringArray == null) {
            this.warn(arrayList, WARN_NO_SRC_FILES, targetData.getName());
        } else {
            int n2;
            String string = this.getMakefileData().getBaseDirectory(true);
            ArrayList<StringBuffer> arrayList2 = new ArrayList<StringBuffer>();
            int n3 = 0;
            int n4 = 0;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                File file;
                String string2 = stringArray[n2].toString();
                if (string2.startsWith("/")) {
                    ++n3;
                }
                if (string2.endsWith(".h")) {
                    ++n4;
                }
                if ((file = string2.startsWith(File.separator) ? new File(string2) : new File(string, string2)).exists()) continue;
                arrayList2.add(new StringBuffer("\t").append(file.getPath()).append("\n"));
            }
            if (n3 > 0) {
                this.warn(arrayList, WARN_ABSPATH_SRC_COUNT, targetData.getName(), new Integer(n3).toString());
            }
            if (n4 > 0) {
                this.warn(arrayList, WARN_HDR_SRC_COUNT, targetData.getName(), new Integer(n4).toString());
            }
            if (arrayList2.size() > 0) {
                if (arrayList2.size() < 5) {
                    this.warn(arrayList, WARN_DNE_FILES, targetData.getName());
                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                        arrayList.add(arrayList2.get(n2));
                    }
                    arrayList.add(new String("\n"));
                } else {
                    this.warn(arrayList, WARN_DNE_COUNT, targetData.getName(), new Integer(arrayList2.size()).toString());
                }
            }
        }
    }

    public void addNotify() {
        TargetData targetData = this.getMakefileData().getCurrentTarget();
        this.key = targetData.getKey();
        if (!this.initialized) {
            this.create();
            this.srcFilter = this.getString("DFLT_SourceFilter");
            this.initialized = true;
        }
        this.getEntryText().setText(this.srcFilter);
        DefaultListModel defaultListModel = (DefaultListModel)this.getList().getModel();
        defaultListModel.removeAllElements();
        String[] stringArray = targetData.getSourcesList();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                defaultListModel.addElement(stringArray[i]);
            }
        }
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        TargetData targetData = this.getMakefileData().getTarget(this.key);
        String[] stringArray = this.getListItems();
        targetData.setSourcesList(stringArray);
    }
}

