/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.MIMEResolver;

public class CndSniffyMIMEResolver
extends MIMEResolver {
    public CndSniffyMIMEResolver() {
        super(new String[]{"text/x-c++", "text/sh"});
    }

    public String findMIMEType(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        if (fileObject.getExt().length() > 0) {
            return null;
        }
        String string = this.getFirstLine(fileObject);
        if (this.detectCPPByLine(string)) {
            return "text/x-c++";
        }
        if (this.detectShellByLine(string)) {
            return "text/sh";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFirstLine(FileObject fileObject) {
        String string = "";
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            if (fileObject.canRead()) {
                inputStreamReader = new InputStreamReader(fileObject.getInputStream());
                bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    string = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    string = "";
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    private boolean detectCPPByLine(String string) {
        if (string != null) {
            if (string.startsWith("//") && string.indexOf("-*- C++ -*-") > 0) {
                return true;
            }
            if ((string = string.replaceAll("\\s", "")).startsWith("#include")) {
                return true;
            }
        }
        return false;
    }

    private boolean detectShellByLine(String string) {
        return string != null && ((string = string.replaceAll("\\s", "")).startsWith("#!/bin/bash") || string.startsWith("#!/bin/sh") || string.startsWith("#!/bin/ksh") || string.startsWith("#!/bin/csh") || string.startsWith("#!/bin/csh") || string.startsWith("#!/usr/bin/perl"));
    }
}

