/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.parser;

import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.cnd.editor.parser.FoldingParser;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppFile {
    private static final Logger log = Logger.getLogger(CppFile.class.getName());
    public static final int FOLD_PARSING = 1;
    public static final int COMPLETION_PARSING = 2;
    public static final int PARSING_INITIALIZED = 0;
    public static final int PARSING_STARTED = 1;
    public static final int FOLD_PARSING_COMPLETE = 2;
    public static final int PARSING_COMPLETED = 3;
    public static final int PARSING_FAILED = 4;
    public static final int INITIAL_COMMENT_FOLD = 1;
    public static final int BLOCK_COMMENT_FOLD = 2;
    public static final int COMMENTS_FOLD = 3;
    public static final int INCLUDES_FOLD = 4;
    public static final int IFDEF_FOLD = 5;
    public static final int CLASS_FOLD = 6;
    public static final int FUNCTION_FOLD = 7;
    public static final int CONSTRUCTOR_FOLD = 8;
    public static final int DESTRUCTOR_FOLD = 9;
    public static final int NAMESPACE_FOLD = 10;
    private int state = 0;
    private CppFoldRecord initialCommentFoldRecord;
    private List<CppFoldRecord> includesFoldRecords = new ArrayList<CppFoldRecord>();
    private List blockFoldRecords = new ArrayList();
    private int parseCount = 0;

    public CppFile(String string) {
    }

    private synchronized int getCount() {
        return ++this.parseCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startParsing(Document document) {
        log.log(Level.FINE, "CppFile.startParsing: Parsing " + this.getShortName(document) + " [" + Thread.currentThread().getName() + "]");
        this.state = 1;
        try {
            if (this.startParsing(Integer.getInteger("CppFoldFlags", 0), document)) {
                this.state = 2;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            log.log(Level.FINE, "CppFile.startParsing: NoSuchMethodError: " + noSuchMethodError.getMessage());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            log.log(Level.FINE, "CppFile.startParsing: UnsatisfiedLinkError: " + unsatisfiedLinkError.getMessage());
        }
        finally {
            if (this.state != 2) {
                this.state = 4;
            }
        }
    }

    public boolean isParsingFailed() {
        return this.state == 4;
    }

    private boolean startParsing(int n, Document document) {
        FoldingParser foldingParser = (FoldingParser)Lookup.getDefault().lookup(FoldingParser.class);
        if (foldingParser != null) {
            this.blockFoldRecords.clear();
            this.initialCommentFoldRecord = null;
            this.includesFoldRecords.clear();
            List<CppFoldRecord> list = null;
            try {
                String string = (String)document.getProperty("title");
                list = foldingParser.parse(string, new StringReader(document.getText(0, document.getLength())));
                if (list == null) {
                    return false;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return false;
            }
            for (CppFoldRecord cppFoldRecord : list) {
                this.addNewFold((StyledDocument)document, cppFoldRecord);
            }
        }
        return true;
    }

    public void waitScanFinished(int n) {
        while (this.state == 1) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean needsUpdate() {
        return true;
    }

    private String getShortName(Document document) {
        String string = (String)document.getProperty("title");
        int n = string.lastIndexOf(File.separatorChar);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public CppFoldRecord getInitialCommentFold() {
        return this.initialCommentFoldRecord;
    }

    public List<CppFoldRecord> getIncludesFolds() {
        return this.includesFoldRecords;
    }

    public List<CppFoldRecord> getBlockFolds() {
        return this.blockFoldRecords;
    }

    private void addNewFold(StyledDocument styledDocument, CppFoldRecord cppFoldRecord) {
        log.log(Level.FINEST, "CppFile.addNewFold: " + cppFoldRecord.toString());
        int n = cppFoldRecord.getStartOffset();
        int n2 = cppFoldRecord.getEndOffset();
        try {
            int n3 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
            int n4 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n2);
            if (n3 != n4 || n > n2 + 5) {
                cppFoldRecord.setLines(n3, n4);
                switch (cppFoldRecord.getType()) {
                    case 1: {
                        if (this.initialCommentFoldRecord != null) break;
                        this.initialCommentFoldRecord = cppFoldRecord;
                        break;
                    }
                    case 4: {
                        this.includesFoldRecords.add(cppFoldRecord);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        this.blockFoldRecords.add(cppFoldRecord);
                    }
                }
            } else {
                log.log(Level.FINE, "CppFile.addNewFold: Skipping fold record on line " + n3);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            log.log(Level.FINE, "CppFile.addNewFold: fold was created for old size of document - ignored");
        }
    }
}

