/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.editor.filecreation.CndHandlableExtensions;
import org.netbeans.modules.cnd.editor.filecreation.ExtensionsSettings;
import org.netbeans.modules.cnd.editor.filecreation.NewCndFileChooserPanel;
import org.netbeans.modules.cnd.editor.filecreation.SrcFileWizardListener;
import org.netbeans.modules.cnd.loaders.HDataObject;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Lookup;

public class CCFSrcFileIterator
implements TemplateWizard.Iterator {
    private static Vector listenerList = null;
    protected WizardDescriptor.Panel targetChooserDescriptorPanel;
    private Set listeners = new HashSet(1);

    public WizardDescriptor.Panel current() {
        return this.targetChooserDescriptorPanel;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public synchronized void nextPanel() {
    }

    public synchronized void previousPanel() {
    }

    public void initialize(TemplateWizard templateWizard) {
        DataObject dataObject = templateWizard.getTemplate();
        Collection collection = Lookup.getDefault().lookupAll(CndHandlableExtensions.class);
        if (collection.contains(dataObject.getLoader())) {
            Project project = Templates.getProject((WizardDescriptor)templateWizard);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            ExtensionsSettings extensionsSettings = ExtensionsSettings.getInstance((CndHandlableExtensions)templateWizard.getTemplate().getLoader());
            if (dataObject instanceof HDataObject && dataObject.getPrimaryFile().getPath().indexOf("cpp") == -1) {
                extensionsSettings = extensionsSettings.getSpecializedInstance("c-header");
            }
            this.targetChooserDescriptorPanel = new NewCndFileChooserPanel(project, sourceGroupArray, null, extensionsSettings);
        } else {
            this.targetChooserDescriptorPanel = templateWizard.targetChooser();
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        String string;
        DataFolder dataFolder = templateWizard.getTargetFolder();
        DataObject dataObject = templateWizard.getTemplate();
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, string = templateWizard.getTargetName());
        if (dataObject2 != null) {
            CCFSrcFileIterator.fireWizardEvent(new EventObject(dataObject2));
            OpenCookie openCookie = (OpenCookie)dataObject2.getCookie(OpenCookie.class);
            if (openCookie != null) {
                openCookie.open();
            }
        }
        return Collections.singleton(dataObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }

    public String name() {
        return "";
    }

    protected static void fireWizardEvent(EventObject eventObject) {
        Vector vector = CCFSrcFileIterator.getListenerList();
        for (int i = vector.size() - 1; i >= 0; --i) {
            ((SrcFileWizardListener)vector.elementAt(i)).srcFileCreated(eventObject);
        }
    }

    private static Vector getListenerList() {
        if (listenerList == null) {
            listenerList = new Vector(0);
        }
        return listenerList;
    }

    public static void addSrcFileWizardListener(SrcFileWizardListener srcFileWizardListener) {
        CCFSrcFileIterator.getListenerList().add(srcFileWizardListener);
    }

    public static void removeSrcFileWizardListener(SrcFileWizardListener srcFileWizardListener) {
        CCFSrcFileIterator.getListenerList().remove(srcFileWizardListener);
    }
}

