/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.compilers.CompilerProvider;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManagerEvents;
import org.netbeans.modules.cnd.api.compilers.CompilerSetProvider;
import org.netbeans.modules.cnd.api.compilers.NoCompilersPanel;
import org.netbeans.modules.cnd.api.compilers.PlatformTypes;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.compilers.DefaultCompilerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerSetManager {
    public static final int SUN_COMPILER_SET = 0;
    public static final int GNU_COMPILER_SET = 1;
    public static final Object STATE_PENDING = "state_pending";
    public static final Object STATE_COMPLETE = "state_complete";
    public static final Object STATE_UNINITIALIZED = "state_uninitialized";
    public static final String LOCALHOST = "localhost";
    private static final double csm_version = 1.1;
    private static final String CSM = "csm.";
    private static final String VERSION = "version";
    private static final String NO_SETS = ".noOfSets";
    private static final String SET_NAME = ".setName.";
    private static final String SET_FLAVOR = ".setFlavor.";
    private static final String SET_DIRECTORY = ".setDirectory.";
    private static final String SET_AUTO = ".autoGenerated.";
    private static final String SET_DEFAULT = ".defaultSet";
    private static final String SET_PLATFORM = ".setPlatform.";
    private static final String NO_TOOLS = ".noOfTools.";
    private static final String TOOL_NAME = ".toolName.";
    private static final String TOOL_DISPLAYNAME = ".toolDisplayName.";
    private static final String TOOL_KIND = ".toolKind.";
    private static final String TOOL_PATH = ".toolPath.";
    private static final String TOOL_FLAVOR = ".toolFlavor.";
    private static HashMap<String, CompilerSetManager> managers = new HashMap();
    private static final Object MASTER_LOCK = new Object();
    private static CompilerProvider compilerProvider = null;
    public static final String SunExpress = "SunStudioExpress";
    public static final String Sun12 = "SunStudio_12";
    public static final String Sun11 = "SunStudio_11";
    public static final String Sun10 = "SunStudio_10";
    public static final String Sun = "SunStudio";
    public static final String GNU = "GNU";
    private List<CompilerSet> sets = new ArrayList<CompilerSet>();
    private final String hkey;
    private Object state;
    private int platform = -1;
    private RequestProcessor.Task remoteInitialization;
    private static final Logger log = Logger.getLogger("cnd.remote.logger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompilerSetManager getDefault(String string) {
        CompilerSetManager compilerSetManager = null;
        boolean bl = false;
        Object object = MASTER_LOCK;
        synchronized (object) {
            compilerSetManager = managers.get(string);
            if (compilerSetManager == null && (compilerSetManager = CompilerSetManager.restoreFromDisk(string)) != null && compilerSetManager.getDefaultCompilerSet() == null) {
                compilerSetManager.initDefaltCompilerSet();
                compilerSetManager.saveToDisk();
            }
            if (compilerSetManager == null) {
                compilerSetManager = new CompilerSetManager(string);
                if (compilerSetManager.isValid()) {
                    compilerSetManager.saveToDisk();
                } else if (!compilerSetManager.isPending() && !compilerSetManager.isUninitialized()) {
                    bl = true;
                }
            }
            if (compilerSetManager != null) {
                managers.put(string, compilerSetManager);
            }
        }
        if (bl) {
            object = new DialogDescriptor((Object)new NoCompilersPanel(), CompilerSetManager.getString("NO_COMPILERS_FOUND_TITLE"), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
        }
        return compilerSetManager;
    }

    public static CompilerSetManager getDefault() {
        return CompilerSetManager.getDefault(LOCALHOST);
    }

    public static CompilerSetManager create(String string) {
        CompilerSetManager compilerSetManager = new CompilerSetManager(string);
        if (compilerSetManager.getCompilerSets().size() == 1 && compilerSetManager.getCompilerSets().get(0).getName().equals("None")) {
            compilerSetManager.remove(compilerSetManager.getCompilerSets().get(0));
        }
        return compilerSetManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setDefaults(Collection<CompilerSetManager> collection) {
        Object object = MASTER_LOCK;
        synchronized (object) {
            for (CompilerSetManager compilerSetManager : collection) {
                if (compilerSetManager.getCompilerSets().size() == 0) {
                    compilerSetManager.add(CompilerSet.createEmptyCompilerSet(compilerSetManager.getPlatform()));
                }
                compilerSetManager.saveToDisk();
                managers.put(compilerSetManager.hkey, compilerSetManager);
            }
        }
    }

    private CompilerSetManager(String string) {
        this.hkey = string;
        this.state = STATE_PENDING;
        this.init();
    }

    private CompilerSetManager(String string, List<CompilerSet> list, int n) {
        this.hkey = string;
        this.sets = list;
        this.platform = n;
        if (!LOCALHOST.equals(string) && this.isEmpty()) {
            this.state = STATE_UNINITIALIZED;
            log.fine("CSM restoring from pref: Adding empty CS to host " + string);
            this.add(CompilerSet.createEmptyCompilerSet(n));
        } else {
            this.state = STATE_COMPLETE;
        }
    }

    private void init() {
        if (this.hkey.equals(LOCALHOST)) {
            this.platform = CompilerSetManager.computeLocalPlatform();
            this.initCompilerSets(Path.getPath());
            this.state = STATE_COMPLETE;
        } else {
            log.fine("CSM.init: initializing remote compiler set for: " + this.hkey);
            this.initRemoteCompilerSets(this.hkey, false);
        }
    }

    public boolean isValid() {
        return this.sets.size() > 0 && !this.sets.get(0).getName().equals("None");
    }

    public boolean isPending() {
        return this.state == STATE_PENDING;
    }

    public boolean isUninitialized() {
        return this.state == STATE_UNINITIALIZED;
    }

    public boolean isComplete() {
        return this.state == STATE_COMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize(boolean bl) {
        if (this.isUninitialized()) {
            log.fine("CSM.getDefault: Doing remote setup from EDT?" + SwingUtilities.isEventDispatchThread());
            this.sets.clear();
            this.initRemoteCompilerSets(this.hkey, true);
            if (this.remoteInitialization != null) {
                this.remoteInitialization.waitFinished();
                this.remoteInitialization = null;
            }
        }
        if (bl) {
            Object object = MASTER_LOCK;
            synchronized (object) {
                this.saveToDisk();
            }
        }
    }

    public int getPlatform() {
        if (this.platform < 0) {
            if (this.hkey.equals(LOCALHOST)) {
                this.platform = CompilerSetManager.computeLocalPlatform();
            } else {
                this.waitForCompletion();
            }
        }
        return this.platform == -1 ? 6 : this.platform;
    }

    private String getPlatformName(int n) {
        switch (n) {
            case 2: {
                return "linux";
            }
            case 0: {
                return "sun_sparc";
            }
            case 1: {
                return "sun_intel";
            }
            case 3: {
                return "windows";
            }
            case 4: {
                return "mac";
            }
        }
        return "none";
    }

    public void waitForCompletion() {
        while (this.isPending()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static int computeLocalPlatform() {
        String string = System.getProperty("os.name");
        if (string.equals("SunOS")) {
            return System.getProperty("os.arch").equals("x86") ? 1 : 0;
        }
        if (string.startsWith("Windows ")) {
            return 3;
        }
        if (string.toLowerCase().contains("linux")) {
            return 2;
        }
        if (string.toLowerCase().contains("mac")) {
            return 4;
        }
        return 5;
    }

    public CompilerSetManager deepCopy() {
        this.waitForCompletion();
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            arrayList.add(compilerSet.createCopy());
        }
        CompilerSetManager compilerSetManager = new CompilerSetManager(this.hkey, arrayList, this.platform);
        return compilerSetManager;
    }

    public String getUniqueCompilerSetName(String string) {
        int n = 0;
        String string2 = string;
        while (this.getCompilerSet(string2 = string + (n > 0 ? "_" + n : "")) != null) {
            ++n;
        }
        return string2;
    }

    private void initCompilerSets(ArrayList<String> arrayList) {
        HashSet<CompilerSet.CompilerFlavor> hashSet = new HashSet<CompilerSet.CompilerFlavor>();
        this.initKnownCompilers(this.getPlatform(), hashSet);
        arrayList = this.appendDefaultLocations(this.getPlatform(), arrayList);
        for (String string : arrayList) {
            File file;
            if (string.equals("/usr/ucb")) continue;
            if (!IpeUtils.isPathAbsolute(string)) {
                string = FileUtil.normalizeFile((File)new File(string)).getAbsolutePath();
            }
            if (!(file = new File(string)).isDirectory()) continue;
            for (CompilerSet.CompilerFlavor compilerFlavor : CompilerSet.getCompilerSetFlavor(file.getAbsolutePath(), this.getPlatform())) {
                if (hashSet.contains(compilerFlavor)) continue;
                hashSet.add(compilerFlavor);
                CompilerSet compilerSet = CompilerSet.getCustomCompilerSet(file.getAbsolutePath(), compilerFlavor, compilerFlavor.toString());
                compilerSet.setAutoGenerated(true);
                this.initCompilerSet(string, compilerSet);
                this.add(compilerSet);
            }
        }
        this.completeCompilerSets();
    }

    private ArrayList<String> appendDefaultLocations(int n, ArrayList<String> arrayList) {
        for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : ToolchainManager.getInstance().getToolchains(n)) {
            String string;
            String string2;
            Map<String, String> map = toolchainDescriptor.getDefaultLocations();
            if (map == null || (string2 = map.get(string = this.getPlatformName(n))) == null || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private void initDefaltCompilerSet() {
        if (!this.sets.isEmpty()) {
            this.setDefault(this.sets.get(0));
        } else {
            this.add(CompilerSet.createEmptyCompilerSet(this.getPlatform()));
        }
    }

    private void initKnownCompilers(int n, Set<CompilerSet.CompilerFlavor> set) {
        for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : ToolchainManager.getInstance().getToolchains(n)) {
            File file;
            String string = ToolchainManager.getInstance().getBaseFolder(toolchainDescriptor, n);
            if (string == null || !(file = new File(string)).exists() || !file.isDirectory()) continue;
            CompilerSet.CompilerFlavor compilerFlavor = CompilerSet.CompilerFlavor.toFlavor(toolchainDescriptor.getName(), n);
            set.add(compilerFlavor);
            CompilerSet compilerSet = CompilerSet.getCustomCompilerSet(file.getAbsolutePath(), compilerFlavor, compilerFlavor.toString());
            compilerSet.setAutoGenerated(true);
            this.initCompilerSet(string, compilerSet);
            this.add(compilerSet);
        }
    }

    public List<CompilerSet> findRemoteCompilerSets(String string) {
        CompilerSetProvider compilerSetProvider = (CompilerSetProvider)Lookup.getDefault().lookup(CompilerSetProvider.class);
        String[] stringArray = compilerSetProvider.getCompilerSetData(this.hkey, string);
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (string2 == null || string2.length() <= 0) continue;
                arrayList.add(CompilerSetManager.parseCompilerSetString(this.hkey, this.platform, string2));
            }
        }
        return arrayList;
    }

    private static CompilerSet parseCompilerSetString(String string, int n, String string2) {
        log.fine("CSM.initRemoteCompileSets: line = [" + string2 + "]");
        int n2 = string2.indexOf(59);
        int n3 = string2.indexOf(59, n2 + 1);
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2 + 1, n3);
        String string5 = string2.substring(n3 + 1);
        CompilerSet compilerSet = new CompilerSet(CompilerSet.CompilerFlavor.toFlavor(string3, n), string4, string3);
        StringTokenizer stringTokenizer = new StringTokenizer(string5, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            int n4 = -1;
            String string7 = string4 + '/' + string6;
            if (string3.startsWith("Sun")) {
                if (string6.equals("cc")) {
                    n4 = 0;
                } else if (string6.equals("CC")) {
                    n4 = 1;
                } else if (string6.equals("f95") || string6.equals("f90")) {
                    n4 = 2;
                } else if (string6.equals("dmake")) {
                    n4 = 5;
                } else if (string6.startsWith("gdb=")) {
                    n4 = 6;
                    n2 = string6.indexOf(61);
                    string7 = string6.substring(n2 + 1);
                }
            } else if (string6.equals("gcc")) {
                n4 = 0;
            } else if (string6.equals("g++")) {
                n4 = 1;
            } else if (string6.equals("g77") || string6.equals("gfortran")) {
                n4 = 2;
            } else if (string6.equals("make") || (n == 1 || n == 0) && string6.equals("gmake")) {
                n4 = 5;
            } else if (string6.equals("gdb")) {
                n4 = 6;
            } else if (string6.startsWith("gdb=")) {
                n4 = 6;
                n2 = string6.indexOf(61);
                string7 = string6.substring(n2 + 1);
            }
            if (n4 == -1) continue;
            compilerSet.addTool(string, string6, string7, n4);
        }
        return compilerSet;
    }

    private synchronized void initRemoteCompilerSets(final String string, boolean bl) {
        if (this.state == STATE_COMPLETE) {
            return;
        }
        if (this.remoteInitialization != null) {
            return;
        }
        final CompilerSetProvider compilerSetProvider = (CompilerSetProvider)Lookup.getDefault().lookup(CompilerSetProvider.class);
        ServerList serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class);
        assert (serverList != null);
        assert (compilerSetProvider != null);
        ServerRecord serverRecord = serverList.get(string);
        assert (serverRecord != null);
        log.fine("CSM.initRemoteCompilerSets for " + string + " [" + this.state + "]");
        serverRecord.validate(bl);
        if (serverRecord.isOnline()) {
            this.remoteInitialization = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Object object;
                    compilerSetProvider.init(string);
                    CompilerSetManager.this.platform = compilerSetProvider.getPlatform();
                    log.fine("CSM.initRemoteCompileSets: platform = " + CompilerSetManager.this.platform);
                    CompilerSetManager.getPreferences().putInt(CompilerSetManager.CSM + CompilerSetManager.this.hkey + CompilerSetManager.SET_PLATFORM, CompilerSetManager.this.platform);
                    while (compilerSetProvider.hasMoreCompilerSets()) {
                        object = compilerSetProvider.getNextCompilerSetData();
                        CompilerSetManager.this.add(CompilerSetManager.parseCompilerSetString(string, CompilerSetManager.this.platform, (String)object));
                    }
                    CompilerSetManager.this.completeCompilerSets(CompilerSetManager.this.platform);
                    if (CompilerSetManager.this.sets instanceof ArrayList) {
                        object = (List)((ArrayList)CompilerSetManager.this.sets).clone();
                    } else {
                        object = new ArrayList();
                        object.addAll(CompilerSetManager.this.sets);
                    }
                    log.fine("CSM.initRemoteCompilerSets: Found " + CompilerSetManager.this.sets.size() + " compiler sets");
                    CompilerSetManager.this.state = STATE_COMPLETE;
                    compilerSetProvider.loadCompilerSetData((List<CompilerSet>)object).addTaskListener(new TaskListener(){

                        public void taskFinished(Task task) {
                            log.fine("Code Model Ready for " + CompilerSetManager.this.toString());
                            CompilerSetManagerEvents.get(CompilerSetManager.this.hkey).runTasks();
                        }
                    });
                }
            });
        } else {
            log.fine("CSM.initRemoteCompilerSets: Adding empty CS to OFFLINE host " + string);
            this.add(CompilerSet.createEmptyCompilerSet(6));
            this.state = STATE_UNINITIALIZED;
        }
    }

    public void initCompilerSet(CompilerSet compilerSet) {
        this.initCompilerSet(compilerSet.getDirectory(), compilerSet);
        CompilerSetManager.completeCompilerSet(this.hkey, compilerSet, this.sets);
    }

    public void reInitCompilerSet(CompilerSet compilerSet, String string) {
        compilerSet.reparent(string);
        this.initCompilerSet(compilerSet);
    }

    private void initCompilerSet(String string, CompilerSet compilerSet) {
        CompilerSet.CompilerFlavor compilerFlavor = compilerSet.getCompilerFlavor();
        ToolchainManager.ToolchainDescriptor toolchainDescriptor = compilerFlavor.getToolchainDescriptor();
        if (toolchainDescriptor != null && ToolchainManager.getInstance().isMyFolder(string, toolchainDescriptor, this.getPlatform())) {
            ToolchainManager.CompilerDescriptor compilerDescriptor = toolchainDescriptor.getC();
            if (compilerDescriptor != null) {
                this.initCompiler(0, string, compilerSet, compilerDescriptor.getNames());
            }
            if ((compilerDescriptor = toolchainDescriptor.getCpp()) != null) {
                this.initCompiler(1, string, compilerSet, compilerDescriptor.getNames());
            }
            if ((compilerDescriptor = toolchainDescriptor.getFortran()) != null) {
                this.initCompiler(2, string, compilerSet, compilerDescriptor.getNames());
            }
            this.initCompiler(5, string, compilerSet, toolchainDescriptor.getMake().getNames());
            this.initCompiler(6, string, compilerSet, toolchainDescriptor.getDebugger().getNames());
        }
    }

    private void initCompiler(int n, String string, CompilerSet compilerSet, String[] stringArray) {
        File file = new File(string);
        if (compilerSet.findTool(n) != null) {
            return;
        }
        for (String string2 : stringArray) {
            File file2 = new File(file, string2);
            if (file2.exists() && !file2.isDirectory()) {
                compilerSet.addTool(this.hkey, string2, file2.getAbsolutePath(), n);
                return;
            }
            file2 = new File(file, string2 + ".exe");
            if (!file2.exists() || file2.isDirectory()) continue;
            compilerSet.addTool(this.hkey, string2, file2.getAbsolutePath(), n);
            return;
        }
    }

    private void completeCompilerSets() {
        for (CompilerSet compilerSet : this.sets) {
            CompilerSetManager.completeCompilerSet(this.hkey, compilerSet, this.sets);
        }
        if (this.sets.size() == 0) {
            this.add(CompilerSet.createEmptyCompilerSet(this.getPlatform()));
        } else {
            this.initDefaltCompilerSet();
        }
        this.completeCompilerSets(this.getPlatform());
    }

    private void completeCompilerSets(int n) {
        CompilerSet compilerSet = this.getCompilerSet(Sun);
        if (compilerSet == null) {
            compilerSet = this.getCompilerSet(SunExpress);
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet("SunStudio_13");
            }
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet(Sun12);
            }
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet(Sun11);
            }
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet(Sun10);
            }
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet("SunStudio_9");
            }
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet("SunStudio_8");
            }
            if (compilerSet != null) {
                compilerSet = compilerSet.createCopy();
                compilerSet.setName(Sun);
                compilerSet.setFlavor(CompilerSet.CompilerFlavor.toFlavor(Sun, n));
                compilerSet.setAutoGenerated(true);
                this.add(compilerSet);
            }
        }
    }

    private static void completeCompilerSet(String string, CompilerSet compilerSet, List<CompilerSet> list) {
        Object object;
        if (compilerSet.getTool(0) == null) {
            compilerSet.addTool(string, "", "", 0);
        }
        if (compilerSet.getTool(1) == null) {
            compilerSet.addTool(string, "", "", 1);
        }
        if (compilerSet.getTool(2) == null) {
            compilerSet.addTool(string, "", "", 2);
        }
        if (compilerSet.findTool(5) == null) {
            CompilerSet compilerSet2;
            object = null;
            Object object2 = list.iterator();
            while (object2.hasNext() && (object = (compilerSet2 = object2.next()).findTool(5)) == null) {
            }
            if (object != null) {
                compilerSet.addNewTool(string, ((Tool)object).getName(), ((Tool)object).getPath(), 5);
            } else {
                object2 = Path.findCommand("make");
                if (object2 != null) {
                    compilerSet.addNewTool(string, IpeUtils.getBaseName((String)object2), (String)object2, 5);
                } else {
                    object2 = Path.findCommand("gmake");
                    if (object2 != null) {
                        compilerSet.addNewTool(string, IpeUtils.getBaseName((String)object2), (String)object2, 5);
                    }
                }
            }
        }
        if (compilerSet.getTool(5) == null) {
            compilerSet.addTool(string, "", "", 5);
        }
        if (compilerSet.findTool(6) == null && (object = IpeUtils.isGdbEnabled() ? Path.findCommand("gdb") : Path.findCommand("dbx")) != null) {
            compilerSet.addNewTool(string, IpeUtils.getBaseName((String)object), (String)object, 6);
        }
        if (compilerSet.getTool(6) == null) {
            compilerSet.addTool(string, "", "", 6);
        }
    }

    public void add(CompilerSet compilerSet) {
        if (this.sets.size() == 1 && this.sets.get(0).getName().equals("None")) {
            this.sets.remove(0);
        }
        this.sets.add(compilerSet);
        if (this.sets.size() == 1) {
            this.setDefault(compilerSet);
        }
    }

    public final boolean isEmpty() {
        return this.sets.size() == 0 || this.sets.size() == 1 && this.sets.get(0).getName().equals("None");
    }

    public void remove(CompilerSet compilerSet) {
        int n = this.sets.indexOf(compilerSet);
        if (n >= 0) {
            this.sets.remove(n);
        }
    }

    public CompilerSet getCompilerSet(CompilerSet.CompilerFlavor compilerFlavor) {
        return this.getCompilerSet(compilerFlavor.toString());
    }

    public CompilerSet getCompilerSet(String string) {
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getName().equals(string)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSetByDisplayName(String string) {
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getDisplayName().equals(string)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSetByPath(String string) {
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getDirectory().equals(string)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSet(String string, String string2) {
        this.waitForCompletion();
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getName().equals(string) || !compilerSet.getDisplayName().equals(string2)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSet(int n) {
        this.waitForCompletion();
        if (n >= 0 && n < this.sets.size()) {
            return this.sets.get(n);
        }
        return null;
    }

    public List<CompilerSet> getCompilerSets() {
        return this.sets;
    }

    public List<String> getCompilerSetDisplayNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            arrayList.add(compilerSet.getDisplayName());
        }
        return arrayList;
    }

    public List<String> getCompilerSetNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            arrayList.add(compilerSet.getName());
        }
        return arrayList;
    }

    public void setDefault(CompilerSet compilerSet) {
        boolean bl = false;
        for (CompilerSet compilerSet2 : this.getCompilerSets()) {
            compilerSet2.setAsDefault(false);
            if (compilerSet2 != compilerSet) continue;
            compilerSet.setAsDefault(true);
            bl = true;
        }
        if (!bl && this.sets.size() > 0) {
            this.getCompilerSet(0).setAsDefault(true);
        }
    }

    public CompilerSet getDefaultCompilerSet() {
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            if (!compilerSet.isDefault()) continue;
            return compilerSet;
        }
        return null;
    }

    public static String getDefaultDevelopmentHost() {
        ServerList serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class);
        String string = serverList == null ? LOCALHOST : serverList.getDefaultRecord().getName();
        return string;
    }

    protected boolean isGdbEnabled() {
        for (ModuleInfo moduleInfo : Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class)).allInstances()) {
            if (!moduleInfo.getCodeNameBase().equals("org.netbeans.modules.cnd.debugger.gdb") || !moduleInfo.isEnabled()) continue;
            return true;
        }
        return false;
    }

    private static CompilerProvider getCompilerProvider() {
        if (compilerProvider == null) {
            compilerProvider = (CompilerProvider)Lookup.getDefault().lookup(CompilerProvider.class);
        }
        if (compilerProvider == null) {
            compilerProvider = new DefaultCompilerProvider();
        }
        return compilerProvider;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(CompilerSetManager.class);
    }

    public void saveToDisk() {
        if (!this.sets.isEmpty() && this.getPlatform() != 5) {
            CompilerSetManager.getPreferences().putDouble("csm.version", 1.1);
            CompilerSetManager.getPreferences().putInt(CSM + this.hkey + NO_SETS, this.sets.size());
            CompilerSetManager.getPreferences().putInt(CSM + this.hkey + SET_PLATFORM, this.getPlatform());
            int n = 0;
            for (CompilerSet compilerSet : this.getCompilerSets()) {
                CompilerSetManager.getPreferences().put(CSM + this.hkey + SET_NAME + n, compilerSet.getName());
                CompilerSetManager.getPreferences().put(CSM + this.hkey + SET_FLAVOR + n, compilerSet.getCompilerFlavor().toString());
                CompilerSetManager.getPreferences().put(CSM + this.hkey + SET_DIRECTORY + n, compilerSet.getDirectory());
                CompilerSetManager.getPreferences().putBoolean(CSM + this.hkey + SET_AUTO + n, compilerSet.isAutoGenerated());
                CompilerSetManager.getPreferences().putBoolean(CSM + this.hkey + SET_DEFAULT + n, compilerSet.isDefault());
                List<Tool> list = compilerSet.getTools();
                CompilerSetManager.getPreferences().putInt(CSM + this.hkey + NO_TOOLS + n, list.size());
                int n2 = 0;
                for (Tool tool : list) {
                    CompilerSetManager.getPreferences().put(CSM + this.hkey + TOOL_NAME + n + '.' + n2, tool.getName());
                    CompilerSetManager.getPreferences().put(CSM + this.hkey + TOOL_DISPLAYNAME + '-' + n + '.' + n2, tool.getDisplayName());
                    CompilerSetManager.getPreferences().putInt(CSM + this.hkey + TOOL_KIND + n + '.' + n2, tool.getKind());
                    CompilerSetManager.getPreferences().put(CSM + this.hkey + TOOL_PATH + n + '.' + n2, tool.getPath());
                    CompilerSetManager.getPreferences().put(CSM + this.hkey + TOOL_FLAVOR + n + '.' + n2, tool.getFlavor().toString());
                    ++n2;
                }
                ++n;
            }
        }
    }

    public static CompilerSetManager restoreFromDisk(String string) {
        double d = CompilerSetManager.getPreferences().getDouble("csm.version", 1.0);
        if (d == 1.0 && string.equals(LOCALHOST)) {
            return CompilerSetManager.restoreFromDisk10();
        }
        int n = CompilerSetManager.getPreferences().getInt(CSM + string + NO_SETS, -1);
        if (n < 0) {
            return null;
        }
        int n2 = CompilerSetManager.getPreferences().getInt(CSM + string + SET_PLATFORM, -1);
        if (n2 < 0 && string.equals(LOCALHOST)) {
            n2 = CompilerSetManager.computeLocalPlatform();
        }
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        for (int i = 0; i < n; ++i) {
            String string2 = CompilerSetManager.getPreferences().get(CSM + string + SET_NAME + i, null);
            String string3 = CompilerSetManager.getPreferences().get(CSM + string + SET_FLAVOR + i, null);
            CompilerSet.CompilerFlavor compilerFlavor = null;
            if (string3 != null) {
                compilerFlavor = CompilerSet.CompilerFlavor.toFlavor(string3, n2);
            }
            String string4 = CompilerSetManager.getPreferences().get(CSM + string + SET_DIRECTORY + i, null);
            if (string2 == null || string3 == null || compilerFlavor == null) continue;
            Boolean bl = CompilerSetManager.getPreferences().getBoolean(CSM + string + SET_AUTO + i, false);
            Boolean bl2 = CompilerSetManager.getPreferences().getBoolean(CSM + string + SET_DEFAULT + i, false);
            CompilerSet compilerSet = new CompilerSet(compilerFlavor, string4, string2);
            compilerSet.setAutoGenerated(bl);
            compilerSet.setAsDefault(bl2);
            int n3 = CompilerSetManager.getPreferences().getInt(CSM + string + NO_TOOLS + i, -1);
            for (int j = 0; j < n3; ++j) {
                String string5 = CompilerSetManager.getPreferences().get(CSM + string + TOOL_NAME + i + '.' + j, null);
                String string6 = CompilerSetManager.getPreferences().get(CSM + string + TOOL_DISPLAYNAME + '-' + i + '.' + j, null);
                int n4 = CompilerSetManager.getPreferences().getInt(CSM + string + TOOL_KIND + i + '.' + j, -1);
                String string7 = CompilerSetManager.getPreferences().get(CSM + string + TOOL_PATH + i + '.' + j, null);
                String string8 = CompilerSetManager.getPreferences().get(CSM + string + TOOL_FLAVOR + i + '.' + j, null);
                CompilerSet.CompilerFlavor compilerFlavor2 = null;
                if (string8 != null) {
                    compilerFlavor2 = CompilerSet.CompilerFlavor.toFlavor(string8, n2);
                }
                Tool tool = CompilerSetManager.getCompilerProvider().createCompiler(string, compilerFlavor2, n4, "", string6, string7);
                tool.setName(string5);
                compilerSet.addTool(tool);
            }
            CompilerSetManager.completeCompilerSet(string, compilerSet, arrayList);
            arrayList.add(compilerSet);
        }
        CompilerSetManager compilerSetManager = new CompilerSetManager(string, arrayList, n2);
        return compilerSetManager;
    }

    public static CompilerSetManager restoreFromDisk10() {
        int n = CompilerSetManager.getPreferences().getInt("csm..noOfSets", -1);
        if (n < 0) {
            return null;
        }
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        CompilerSetManager.getPreferences().remove("csm..noOfSets");
        for (int i = 0; i < n; ++i) {
            String string = CompilerSetManager.getPreferences().get("csm..setName." + i, null);
            CompilerSetManager.getPreferences().remove("csm..setName." + i);
            String string2 = CompilerSetManager.getPreferences().get("csm..setFlavor." + i, null);
            CompilerSetManager.getPreferences().remove("csm..setFlavor." + i);
            CompilerSet.CompilerFlavor compilerFlavor = null;
            if (string2 != null) {
                compilerFlavor = CompilerSet.CompilerFlavor.toFlavor(string2, PlatformTypes.getDefaultPlatform());
            }
            String string3 = CompilerSetManager.getPreferences().get("csm..setDirectory." + i, null);
            CompilerSetManager.getPreferences().remove("csm..setDirectory." + i);
            if (string == null || string2 == null || compilerFlavor == null) continue;
            Boolean bl = CompilerSetManager.getPreferences().getBoolean("csm..autoGenerated." + i, false);
            CompilerSetManager.getPreferences().remove("csm..autoGenerated." + i);
            CompilerSet compilerSet = new CompilerSet(compilerFlavor, string3, string);
            compilerSet.setAutoGenerated(bl);
            int n2 = CompilerSetManager.getPreferences().getInt("csm..noOfTools." + i, -1);
            CompilerSetManager.getPreferences().remove("csm..noOfTools." + i);
            for (int j = 0; j < n2; ++j) {
                String string4 = CompilerSetManager.getPreferences().get("csm..toolName." + i + '.' + j, null);
                String string5 = CompilerSetManager.getPreferences().get("csm..toolDisplayName.-" + i + '.' + j, null);
                int n3 = CompilerSetManager.getPreferences().getInt("csm..toolKind." + i + '.' + j, -1);
                String string6 = CompilerSetManager.getPreferences().get("csm..toolPath." + i + '.' + j, null);
                String string7 = CompilerSetManager.getPreferences().get("csm..toolFlavor." + i + '.' + j, null);
                CompilerSetManager.getPreferences().remove("csm..toolName." + i + '.' + j);
                CompilerSetManager.getPreferences().remove("csm..toolDisplayName.-" + i + '.' + j);
                CompilerSetManager.getPreferences().remove("csm..toolKind." + i + '.' + j);
                CompilerSetManager.getPreferences().remove("csm..toolPath." + i + '.' + j);
                CompilerSetManager.getPreferences().remove("csm..toolFlavor." + i + '.' + j);
                CompilerSet.CompilerFlavor compilerFlavor2 = null;
                if (string7 != null) {
                    compilerFlavor2 = CompilerSet.CompilerFlavor.toFlavor(string7, PlatformTypes.getDefaultPlatform());
                }
                Tool tool = CompilerSetManager.getCompilerProvider().createCompiler(LOCALHOST, compilerFlavor2, n3, "", string5, string6);
                tool.setName(string4);
                compilerSet.addTool(tool);
            }
            CompilerSetManager.completeCompilerSet(LOCALHOST, compilerSet, arrayList);
            arrayList.add(compilerSet);
        }
        CompilerSetManager compilerSetManager = new CompilerSetManager(LOCALHOST, arrayList, CompilerSetManager.computeLocalPlatform());
        return compilerSetManager;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(CompilerSetManager.class, (String)string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CSM for ").append(this.hkey);
        stringBuilder.append(" with toolchains:[");
        for (CompilerSet compilerSet : this.sets) {
            stringBuilder.append(compilerSet.getName()).append(" ");
        }
        stringBuilder.append("]");
        stringBuilder.append(" platform:").append(PlatformTypes.toString(this.platform));
        stringBuilder.append(" in state ").append(this.state.toString());
        return stringBuilder.toString();
    }

    public String getHost() {
        return this.hkey;
    }

    private class CompilerFilenameFilter
    implements FilenameFilter {
        Pattern pc = null;

        public CompilerFilenameFilter(String string) {
            try {
                this.pc = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }

        public boolean accept(File file, String string) {
            return this.pc != null && this.pc.matcher(string).matches();
        }
    }
}

