/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.api.restricted;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.sun.api.ServerInterface;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.AdminObjectResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.MailResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;

public class RegistrationUtils {
    private static String POOL_EXTENSION = "_Base";
    private static String DELETE_POOL = "deleteJdbcConnectionPool";
    private static String DELETE_JDBC = "deleteJdbcResource";
    private static String DELETE_MAIL = "deleteMailResource";
    private static String DELETE_CONNECTOR = "deleteConnectorResource";
    private static String DELETE_CONNECTORPOOL = "deleteConnectorConnectionPool";
    private static String DELETE_ADMINOBJECT = "deleteAdminObjectResource";
    private static String DAS_SERVER_NAME = "server";

    public static void checkUpdateServerResources(ServerInterface serverInterface, File file) {
        Resources resources = ResourceUtils.getResourcesGraph(file);
        RegistrationUtils.updateJDBCResourcesAndPools(resources, serverInterface);
        RegistrationUtils.updateMailResources(resources, serverInterface);
        RegistrationUtils.updateJMSResources(resources, serverInterface);
    }

    private static void updateJDBCResourcesAndPools(Resources resources, ServerInterface serverInterface) {
        HashMap hashMap = RegistrationUtils.getServerConnectionPools(serverInterface, "getJdbcConnectionPool");
        HashMap hashMap2 = RegistrationUtils.getServerResources(serverInterface, "getJdbcResource");
        JdbcConnectionPool[] jdbcConnectionPoolArray = resources.getJdbcConnectionPool();
        JdbcResource[] jdbcResourceArray = resources.getJdbcResource();
        HashMap hashMap3 = RegistrationUtils.getProjectDatasources(hashMap2, jdbcResourceArray);
        RegistrationUtils.deleteServerResources(hashMap3, serverInterface, DELETE_JDBC);
        for (int i = 0; i < jdbcConnectionPoolArray.length; ++i) {
            JdbcConnectionPool jdbcConnectionPool = jdbcConnectionPoolArray[i];
            String string = jdbcConnectionPool.getName();
            if (hashMap.containsKey(string)) {
                HashMap hashMap4 = RegistrationUtils.getReferringResources(string, hashMap2, serverInterface);
                if (hashMap4.size() > 0) {
                    RegistrationUtils.copyServerPool(hashMap, string, "createJdbcConnectionPool", serverInterface);
                    RegistrationUtils.updateExternalResource(hashMap4, string, serverInterface);
                }
                RegistrationUtils.deleteOldServerPool(string, DELETE_POOL, serverInterface);
                continue;
            }
            RegistrationUtils.deleteOldServerPool(string, DELETE_POOL, serverInterface);
        }
    }

    private static void updateMailResources(Resources resources, ServerInterface serverInterface) {
        HashMap hashMap = RegistrationUtils.getServerResources(serverInterface, "getMailResource");
        MailResource[] mailResourceArray = resources.getMailResource();
        HashMap hashMap2 = RegistrationUtils.getProjectMailResources(hashMap, mailResourceArray);
        RegistrationUtils.deleteServerResources(hashMap2, serverInterface, DELETE_MAIL);
    }

    private static void updateJMSResources(Resources resources, ServerInterface serverInterface) {
        RegistrationUtils.updateAdminObjects(resources, serverInterface);
        RegistrationUtils.updateConnectorsAndPools(resources, serverInterface);
    }

    private static void updateAdminObjects(Resources resources, ServerInterface serverInterface) {
        HashMap hashMap = RegistrationUtils.getServerResources(serverInterface, "getAdminObjectResource");
        AdminObjectResource[] adminObjectResourceArray = resources.getAdminObjectResource();
        HashMap hashMap2 = RegistrationUtils.getProjectAdminObjects(hashMap, adminObjectResourceArray);
        RegistrationUtils.deleteServerResources(hashMap2, serverInterface, DELETE_ADMINOBJECT);
    }

    private static void updateConnectorsAndPools(Resources resources, ServerInterface serverInterface) {
        HashMap hashMap = RegistrationUtils.getServerConnectionPools(serverInterface, "getConnectorConnectionPool");
        HashMap hashMap2 = RegistrationUtils.getServerResources(serverInterface, "getConnectorResource");
        ConnectorConnectionPool[] connectorConnectionPoolArray = resources.getConnectorConnectionPool();
        ConnectorResource[] connectorResourceArray = resources.getConnectorResource();
        HashMap hashMap3 = RegistrationUtils.getProjectConnectors(hashMap2, connectorResourceArray);
        RegistrationUtils.deleteServerResources(hashMap3, serverInterface, DELETE_CONNECTOR);
        for (int i = 0; i < connectorConnectionPoolArray.length; ++i) {
            ConnectorConnectionPool connectorConnectionPool = connectorConnectionPoolArray[i];
            String string = connectorConnectionPool.getName();
            if (hashMap.containsKey(string)) {
                HashMap hashMap4 = RegistrationUtils.getReferringResources(string, hashMap2, serverInterface);
                if (hashMap4.size() > 0) {
                    RegistrationUtils.copyServerPool(hashMap, string, "createConnectorConnectionPool", serverInterface);
                    RegistrationUtils.updateExternalResource(hashMap4, string, serverInterface);
                }
                RegistrationUtils.deleteOldServerPool(string, DELETE_CONNECTORPOOL, serverInterface);
                continue;
            }
            RegistrationUtils.deleteOldServerPool(string, DELETE_CONNECTORPOOL, serverInterface);
        }
    }

    public static HashMap getServerConnectionPools(ServerInterface serverInterface, String string) {
        HashMap<String, ObjectName> hashMap = new HashMap<String, ObjectName>();
        try {
            ObjectName objectName = new ObjectName("com.sun.appserv:type=resources,category=config");
            ObjectName[] objectNameArray = (ObjectName[])serverInterface.invoke(objectName, string, null, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                ObjectName objectName2 = objectNameArray[i];
                String string2 = (String)serverInterface.getAttribute(objectName2, "name");
                hashMap.put(string2, objectName2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    public static HashMap getServerJdbcResources(ServerInterface serverInterface) {
        HashMap<String, ObjectName> hashMap = new HashMap<String, ObjectName>();
        try {
            ObjectName objectName = new ObjectName("com.sun.appserv:type=resources,category=config");
            ObjectName[] objectNameArray = (ObjectName[])serverInterface.invoke(objectName, "getJdbcResource", null, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                ObjectName objectName2 = objectNameArray[i];
                String string = (String)serverInterface.getAttribute(objectName2, "jndi-name");
                hashMap.put(string, objectName2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    public static HashMap getReferringResources(String string, HashMap hashMap, ServerInterface serverInterface) {
        HashMap<String, ObjectName> hashMap2 = new HashMap<String, ObjectName>();
        try {
            for (String string2 : hashMap.keySet()) {
                ObjectName objectName = (ObjectName)hashMap.get(string2);
                String string3 = (String)serverInterface.getAttribute(objectName, "pool-name");
                if (!string3.equals(string)) continue;
                hashMap2.put(string2, objectName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap2;
    }

    public static HashMap getProjectDatasources(HashMap hashMap, JdbcResource[] jdbcResourceArray) {
        HashMap<String, ObjectName> hashMap2 = new HashMap<String, ObjectName>();
        for (int i = 0; i < jdbcResourceArray.length; ++i) {
            JdbcResource jdbcResource = jdbcResourceArray[i];
            String string = jdbcResource.getJndiName();
            if (!hashMap.containsKey(string)) continue;
            hashMap2.put(string, (ObjectName)hashMap.get(string));
        }
        return hashMap2;
    }

    public static HashMap getProjectMailResources(HashMap hashMap, MailResource[] mailResourceArray) {
        HashMap<String, ObjectName> hashMap2 = new HashMap<String, ObjectName>();
        for (int i = 0; i < mailResourceArray.length; ++i) {
            MailResource mailResource = mailResourceArray[i];
            String string = mailResource.getJndiName();
            if (!hashMap.containsKey(string)) continue;
            hashMap2.put(string, (ObjectName)hashMap.get(string));
        }
        return hashMap2;
    }

    public static HashMap getProjectAdminObjects(HashMap hashMap, AdminObjectResource[] adminObjectResourceArray) {
        HashMap<String, ObjectName> hashMap2 = new HashMap<String, ObjectName>();
        for (int i = 0; i < adminObjectResourceArray.length; ++i) {
            AdminObjectResource adminObjectResource = adminObjectResourceArray[i];
            String string = adminObjectResource.getJndiName();
            if (!hashMap.containsKey(string)) continue;
            hashMap2.put(string, (ObjectName)hashMap.get(string));
        }
        return hashMap2;
    }

    public static HashMap getProjectConnectors(HashMap hashMap, ConnectorResource[] connectorResourceArray) {
        HashMap<String, ObjectName> hashMap2 = new HashMap<String, ObjectName>();
        for (int i = 0; i < connectorResourceArray.length; ++i) {
            ConnectorResource connectorResource = connectorResourceArray[i];
            String string = connectorResource.getJndiName();
            if (!hashMap.containsKey(string)) continue;
            hashMap2.put(string, (ObjectName)hashMap.get(string));
        }
        return hashMap2;
    }

    public static void updateExternalResource(HashMap hashMap, String string, ServerInterface serverInterface) {
        try {
            String string2 = string + POOL_EXTENSION;
            for (ObjectName objectName : hashMap.values()) {
                Attribute attribute = new Attribute("pool-name", string2);
                serverInterface.setAttribute(objectName, attribute);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
        }
    }

    public static void copyServerPool(HashMap hashMap, String string, String string2, ServerInterface serverInterface) {
        try {
            String string3 = string + POOL_EXTENSION;
            if (!hashMap.containsKey(string3)) {
                ObjectName objectName = (ObjectName)hashMap.get(string);
                Map map = ResourceUtils.getResourceAttributeNames(objectName, serverInterface);
                map.remove("name");
                String[] stringArray = map.keySet().toArray(new String[map.size()]);
                AttributeList attributeList = serverInterface.getAttributes(objectName, stringArray);
                Attribute attribute = new Attribute("name", string3);
                attributeList.add(attribute);
                Properties properties = new Properties();
                AttributeList attributeList2 = (AttributeList)serverInterface.invoke(objectName, "getProperties", null, null);
                for (int i = 0; i < attributeList.size(); ++i) {
                    Attribute attribute2 = (Attribute)attributeList.get(i);
                    String string4 = attribute2.getName();
                    Object object = attribute2.getValue();
                    if (object == null) continue;
                    properties.put(string4, object);
                }
                Object[] objectArray = new Object[]{attributeList, properties, null};
                ResourceUtils.createResource(string2, objectArray, serverInterface);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
        }
    }

    public static void deleteOldServerPool(String string, String string2, ServerInterface serverInterface) {
        try {
            ObjectName objectName = new ObjectName("com.sun.appserv:type=resources,category=config");
            serverInterface.invoke(objectName, string2, new Object[]{string, DAS_SERVER_NAME}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteServerResources(HashMap hashMap, ServerInterface serverInterface, String string) {
        try {
            ObjectName objectName = new ObjectName("com.sun.appserv:type=resources,category=config");
            for (String string2 : hashMap.keySet()) {
                serverInterface.invoke(objectName, string, new Object[]{string2, DAS_SERVER_NAME}, new String[]{"java.lang.String", "java.lang.String"});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static HashMap getServerResources(ServerInterface serverInterface, String string) {
        HashMap<String, ObjectName> hashMap = new HashMap<String, ObjectName>();
        try {
            ObjectName objectName = new ObjectName("com.sun.appserv:type=resources,category=config");
            ObjectName[] objectNameArray = (ObjectName[])serverInterface.invoke(objectName, string, null, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                ObjectName objectName2 = objectNameArray[i];
                String string2 = (String)serverInterface.getAttribute(objectName2, "jndi-name");
                hashMap.put(string2, objectName2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }
}

