/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scope {
    private int shared;
    public Scope next;
    public Symbol owner;
    public Entry[] table;
    int hashMask;
    public Entry elems;
    public int nelems = 0;
    private static final Entry sentinel = new Entry(null, null, null, null);
    private static final int INITIAL_SIZE = 16;
    public static final Scope emptyScope = new Scope(null, null, new Entry[0]);

    Scope(Scope next, Symbol owner, Entry[] table) {
        this.next = next;
        assert (emptyScope == null || owner != null);
        this.owner = owner;
        this.table = table;
        this.hashMask = table.length - 1;
        this.elems = null;
        this.nelems = 0;
        this.shared = 0;
    }

    public Scope(Symbol owner) {
        this(null, owner, new Entry[16]);
        for (int i = 0; i < 16; ++i) {
            this.table[i] = sentinel;
        }
    }

    public Scope dup() {
        Scope result = new Scope(this, this.owner, this.table);
        ++this.shared;
        return result;
    }

    public Scope dup(Symbol newOwner) {
        Scope result = new Scope(this, newOwner, this.table);
        ++this.shared;
        return result;
    }

    public Scope dupUnshared() {
        return new Scope(this, this.owner, (Entry[])this.table.clone());
    }

    public Scope leave() {
        assert (this.shared == 0);
        if (this.table != this.next.table) {
            return this.next;
        }
        while (this.elems != null) {
            int hash = this.elems.sym.name.index & this.hashMask;
            Entry e = this.table[hash];
            assert (e == this.elems) : this.elems.sym;
            this.table[hash] = this.elems.shadowed;
            this.elems = this.elems.sibling;
        }
        assert (this.next.shared > 0);
        --this.next.shared;
        return this.next;
    }

    private void dble() {
        int i;
        assert (this.shared == 0);
        Entry[] oldtable = this.table;
        Entry[] newtable = new Entry[oldtable.length * 2];
        Scope s = this;
        while (s != null) {
            if (s.table == oldtable) {
                assert (s == this || s.shared != 0);
                s.table = newtable;
                s.hashMask = newtable.length - 1;
            }
            s = s.next;
        }
        for (i = 0; i < newtable.length; ++i) {
            newtable[i] = sentinel;
        }
        for (i = 0; i < oldtable.length; ++i) {
            this.copy(oldtable[i]);
        }
    }

    private void copy(Entry e) {
        if (e.sym != null) {
            this.copy(e.shadowed);
            int hash = e.sym.name.index & this.hashMask;
            e.shadowed = this.table[hash];
            this.table[hash] = e;
        }
    }

    public void enter(Symbol sym) {
        assert (this.shared == 0);
        this.enter(sym, this);
    }

    public void enter(Symbol sym, Scope s) {
        this.enter(sym, s, s);
    }

    public void enter(Symbol sym, Scope s, Scope origin) {
        Entry e;
        assert (this.shared == 0);
        int hash = sym.name.index & this.hashMask;
        this.table[hash] = e = this.makeEntry(sym, this.table[hash], this.elems, s, origin);
        this.elems = e;
        ++this.nelems;
    }

    Entry makeEntry(Symbol sym, Entry shadowed, Entry sibling, Scope scope, Scope origin) {
        return new Entry(sym, shadowed, sibling, scope);
    }

    public void remove(Symbol sym) {
        assert (this.shared == 0);
        Entry e = this.lookup(sym.name);
        while (e.scope == this && e.sym != sym) {
            e = e.next();
        }
        if (e.scope == null) {
            return;
        }
        Entry te = this.table[sym.name.index & this.hashMask];
        if (te == e) {
            this.table[sym.name.index & this.hashMask] = e.shadowed;
        } else {
            while (true) {
                if (te.shadowed == e) {
                    te.shadowed = e.shadowed;
                    break;
                }
                te = te.shadowed;
            }
        }
        te = this.elems;
        if (te == e) {
            this.elems = e.sibling;
        } else {
            while (true) {
                if (te.sibling == e) {
                    te.sibling = e.sibling;
                    break;
                }
                te = te.sibling;
            }
        }
    }

    public void enterIfAbsent(Symbol sym) {
        assert (this.shared == 0);
        Entry e = this.lookup(sym.name);
        while (e.scope == this && e.sym.kind != sym.kind) {
            e = e.next();
        }
        if (e.scope != this) {
            this.enter(sym);
        }
    }

    public boolean includes(Symbol c) {
        Entry e = this.lookup(c.name);
        while (e.scope == this) {
            if (e.sym == c) {
                return true;
            }
            e = e.next();
        }
        return false;
    }

    public Entry lookup(Name name) {
        Entry e = this.table[name.index & this.hashMask];
        while (e.scope != null && e.sym.name != name) {
            e = e.shadowed;
        }
        return e;
    }

    public Iterable<Symbol> getElements() {
        return new Iterable<Symbol>(){

            @Override
            public Iterator<Symbol> iterator() {
                return new Iterator<Symbol>(){
                    private Scope currScope;
                    private Entry currEntry;
                    {
                        this.currScope = Scope.this;
                        this.currEntry = Scope.this.elems;
                        this.update();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currEntry != null;
                    }

                    @Override
                    public Symbol next() {
                        Symbol sym = this.currEntry == null ? null : this.currEntry.sym;
                        this.currEntry = this.currEntry.sibling;
                        this.update();
                        return sym;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private void update() {
                        while (this.currEntry == null && this.currScope.next != null) {
                            this.currScope = this.currScope.next;
                            this.currEntry = this.currScope.elems;
                        }
                    }
                };
            }
        };
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Scope[");
        Scope s = this;
        while (s != null) {
            if (s != this) {
                result.append(" | ");
            }
            Entry e = s.elems;
            while (e != null) {
                if (e != s.elems) {
                    result.append(", ");
                }
                result.append(e.sym);
                e = e.sibling;
            }
            s = s.next;
        }
        result.append("]");
        return result.toString();
    }

    public static class ErrorScope
    extends Scope {
        ErrorScope(Scope next, Symbol errSymbol, Entry[] table) {
            super(next, errSymbol, table);
        }

        public ErrorScope(Symbol errSymbol) {
            super(errSymbol);
        }

        public Scope dup() {
            return new ErrorScope(this, this.owner, this.table);
        }

        public Scope dupUnshared() {
            return new ErrorScope(this, this.owner, (Entry[])this.table.clone());
        }

        public Entry lookup(Name name) {
            Entry e = super.lookup(name);
            if (e.scope == null) {
                return new Entry(this.owner, sentinel, null, null);
            }
            return e;
        }
    }

    public static class DelegatedScope
    extends Scope {
        Scope delegatee;
        public static final Entry[] emptyTable = new Entry[0];

        public DelegatedScope(Scope outer) {
            super(outer, outer.owner, emptyTable);
            this.delegatee = outer;
        }

        public Scope dup() {
            return new DelegatedScope(this.next);
        }

        public Scope dupUnshared() {
            return new DelegatedScope(this.next);
        }

        public Scope leave() {
            return this.next;
        }

        public void enter(Symbol sym) {
        }

        public void enter(Symbol sym, Scope s) {
        }

        public void remove(Symbol sym) {
            throw new AssertionError(sym);
        }

        public Entry lookup(Name name) {
            return this.delegatee.lookup(name);
        }
    }

    public static class ImportScope
    extends Scope {
        public ImportScope(Symbol owner) {
            super(owner);
        }

        Entry makeEntry(Symbol sym, Entry shadowed, Entry sibling, Scope scope, Scope origin) {
            return new ImportEntry(sym, shadowed, sibling, scope, origin);
        }

        public Entry lookup(Name name) {
            Entry e = this.table[name.index & this.hashMask];
            while (e.scope != null && (e.sym.name != name || e.sym.owner != e.scope.owner)) {
                e = e.shadowed;
            }
            return e;
        }

        static class ImportEntry
        extends Entry {
            private Scope origin;

            ImportEntry(Symbol sym, Entry shadowed, Entry sibling, Scope scope, Scope origin) {
                super(sym, shadowed, sibling, scope);
                this.origin = origin;
            }

            public Entry next() {
                Entry e = ((Entry)this).shadowed;
                while (e.scope != null && (e.sym.name != this.sym.name || e.sym.owner != e.scope.owner)) {
                    e = e.shadowed;
                }
                return e;
            }

            public Scope getOrigin() {
                return this.origin;
            }
        }
    }

    public static class Entry {
        public Symbol sym;
        private Entry shadowed;
        public Entry sibling;
        public Scope scope;

        public Entry(Symbol sym, Entry shadowed, Entry sibling, Scope scope) {
            this.sym = sym;
            this.shadowed = shadowed;
            this.sibling = sibling;
            this.scope = scope;
        }

        public Entry next() {
            Entry e = this.shadowed;
            while (e.scope != null && e.sym.name != this.sym.name) {
                e = e.shadowed;
            }
            return e;
        }

        public Scope getOrigin() {
            return this.scope;
        }
    }
}

