/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.palette.codeclips;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.netbeans.modules.visualweb.palette.codeclips.CodeClipViewerPanel;
import org.netbeans.modules.visualweb.palette.codeclips.CodeClipsParametersDialog;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;

public class CodeClipUtilities {
    private static final String LOC_MARKER = "~";
    private static final String PARAM_MARKER = "@";

    public static void createCodeClip(DataFolder dataFolder) {
        FileObject fileObject = dataFolder.getPrimaryFile();
        String string = NbBundle.getMessage(CodeClipUtilities.class, (String)"CLIP");
        CodeClipViewerPanel codeClipViewerPanel = new CodeClipViewerPanel(string, string, "");
        codeClipViewerPanel.setVisible(true);
        if (!codeClipViewerPanel.isCancelled()) {
            try {
                CodeClipUtilities.createCodeClipFile(fileObject, codeClipViewerPanel.getContentText(), codeClipViewerPanel.getClipName(), null, codeClipViewerPanel.getToolTip());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            catch (MissingResourceException missingResourceException) {
                ErrorManager.getDefault().notify((Throwable)missingResourceException);
            }
        }
    }

    public static String parseClipForParams(String string, String string2) {
        String string3 = string2;
        Vector vector = new Vector();
        int n = string3.indexOf(PARAM_MARKER);
        if (n != -1) {
            int n2;
            Vector<String> vector2 = new Vector<String>();
            String string4 = string3;
            int n3 = 0;
            while (n != -1) {
                n2 = string4.indexOf(PARAM_MARKER, n + 1);
                if (n2 < 0) {
                    n = -1;
                } else if (string4.substring(n + 1, n2).contains(" ")) {
                    string4 = string4.substring(n2);
                    n = n2;
                } else {
                    if (!vector2.contains(string4.substring(n + 1, n2))) {
                        vector2.add(string4.substring(n + 1, n2));
                    }
                    string4 = string4.substring(n2 + 1);
                    n = string4.indexOf(PARAM_MARKER);
                }
                ++n3;
            }
            if (vector2.size() == 0) {
                return string3;
            }
            CodeClipsParametersDialog codeClipsParametersDialog = new CodeClipsParametersDialog(string, vector2);
            codeClipsParametersDialog.setVisible(true);
            if (codeClipsParametersDialog.isCancelled()) {
                return "";
            }
            if (!codeClipsParametersDialog.isCancelled()) {
                vector = codeClipsParametersDialog.getNewParam();
            }
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                if (vector2.elementAt(n2) == null) continue;
                String string5 = vector2.elementAt(n2);
                String string6 = vector.elementAt(n2).toString();
                string3 = string3.replaceAll(PARAM_MARKER + string5 + PARAM_MARKER, string6);
            }
        }
        return string3;
    }

    public static String fillFromBundle(String string, String string2) {
        String string3 = string;
        int n = string3.indexOf(LOC_MARKER);
        if (n != -1) {
            Object object;
            int n2;
            Vector<String> vector = new Vector<String>();
            String string4 = string3;
            int n3 = 0;
            while (n != -1) {
                n2 = string4.indexOf(LOC_MARKER, n + 1);
                if (!vector.contains(string4.substring(n + 1, n2))) {
                    vector.add(string4.substring(n + 1, n2));
                }
                string4 = string4.substring(n2 + 1);
                n = string4.indexOf(LOC_MARKER);
                ++n3;
            }
            Vector<String> vector2 = new Vector<String>();
            for (n2 = 0; n2 < vector.size(); ++n2) {
                try {
                    object = NbBundle.getBundle((String)string2);
                    vector2.add(((ResourceBundle)object).getString((String)vector.elementAt(n2)));
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    vector2.add(LOC_MARKER + (String)vector.elementAt(n2) + LOC_MARKER);
                }
            }
            for (n2 = 0; n2 < vector.size(); ++n2) {
                if (vector.elementAt(n2) == null) continue;
                object = (String)vector.elementAt(n2);
                String string5 = (String)vector2.elementAt(n2);
                string3 = string3.replaceAll(LOC_MARKER + (String)object + LOC_MARKER, string5);
            }
        }
        return string3;
    }

    public static void createCodeClipFile(FileObject fileObject, String string, String string2, String string3) throws IOException {
        String string4 = "org.netbeans.modules.visualweb.palette.codeclips.Bundle";
        CodeClipUtilities.createCodeClipFile(fileObject, string, string2, string4, string3);
    }

    public static void createCodeClipFile(FileObject fileObject, String string, String string2, String string3, String string4) throws IOException {
        String string5 = "xml";
        String string6 = "org/netbeans/modules/visualweb/spi/palette/resources/Codesnippet_C16.png";
        String string7 = "org/netbeans/modules/visualweb/spi/palette/resources/Codesnippet_C32.png";
        String string8 = CodeClipUtilities.getFreeFileName(fileObject, "CLIP", string5);
        FileObject fileObject2 = fileObject.createData(string8, "xml");
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuffer.append("<!DOCTYPE codeclip_palette_item PUBLIC \"-//NetBeans//CodeClip Palette Item 1.0//EN\"\n");
        stringBuffer.append("\"http://www.netbeans.org/dtds/codeclip-palette-item-1_0.dtd\">\n\n");
        stringBuffer.append("  <codeclip_palette_item version=\"1.0\">\n");
        stringBuffer.append("    <body>\n");
        stringBuffer.append("        <![CDATA[\n");
        stringBuffer.append(string + "\n");
        stringBuffer.append("        ]]>\n");
        stringBuffer.append("    </body>\n");
        stringBuffer.append("<icon16 urlvalue=\"" + string6 + "\"/>\n");
        stringBuffer.append("<icon32 urlvalue=\"" + string7 + "\"/>\n");
        stringBuffer.append("<description display-name-key=\"" + string2 + "\" \n");
        if (string3 != null) {
            stringBuffer.append("              localizing-bundle=\"" + string3 + "\" \n");
        }
        if (string4 != null) {
            stringBuffer.append("              tooltip-key=\"" + string4 + "\" \n");
        }
        stringBuffer.append("/>\n");
        stringBuffer.append("</codeclip_palette_item>");
        FileLock fileLock = fileObject2.lock();
        OutputStream outputStream = fileObject2.getOutputStream(fileLock);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
        outputStreamWriter.write(stringBuffer.toString());
        outputStreamWriter.close();
        outputStream.close();
        fileLock.releaseLock();
    }

    public static String getFreeFileName(FileObject fileObject, String string, String string2) {
        String string3 = string.replaceAll("\\W", "");
        return FileUtil.findFreeFileName((FileObject)fileObject, (String)string3, (String)string2);
    }
}

