/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.xml.multiview.Refreshable;

public class ItemEditorHelper
implements Refreshable {
    protected ItemDocument doc;
    private final JTextComponent editorComponent;
    private ItemEditorModel model;

    private JTextComponent getEditorComponent() {
        return this.editorComponent;
    }

    public ItemEditorHelper(JTextComponent jTextComponent) {
        this(jTextComponent, null);
    }

    public ItemEditorHelper(JTextComponent jTextComponent, ItemEditorModel itemEditorModel) {
        this.editorComponent = jTextComponent;
        this.doc = new ItemDocument();
        this.setModel(itemEditorModel);
        this.editorComponent.setDocument(this.doc);
        this.refresh();
    }

    public ItemEditorModel getModel() {
        return this.model;
    }

    private void setModel(ItemEditorModel itemEditorModel) {
        this.model = itemEditorModel != null ? itemEditorModel : ItemEditorHelper.createDefaultModel();
        this.model.itemEditorHelper = this;
    }

    private static ItemEditorModel createDefaultModel() {
        return new ItemEditorModel(){
            private String value;

            public String getItemValue() {
                return this.value;
            }

            public boolean setItemValue(String string) {
                this.value = string;
                return true;
            }

            public void documentUpdated() {
            }
        };
    }

    public void refresh() {
        this.doc.refresh();
    }

    public String getEditorText() {
        return this.editorComponent.getText();
    }

    private class ItemDocument
    extends PlainDocument {
        boolean refreshing = false;

        private ItemDocument() {
        }

        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            this.updateModel();
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            this.updateModel();
        }

        private void updateModel() {
            if (!this.refreshing) {
                ItemEditorHelper.this.model.documentUpdated();
                this.refresh();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() {
            block9: {
                this.refreshing = true;
                try {
                    String string;
                    String string2 = ItemEditorHelper.this.model.getItemValue();
                    try {
                        string = this.getText(0, this.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        string = "";
                        badLocationException.printStackTrace();
                    }
                    if (string.equals(string2)) break block9;
                    try {
                        super.remove(0, this.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    try {
                        super.insertString(0, string2, null);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                finally {
                    this.refreshing = false;
                }
            }
        }
    }

    public static abstract class ItemEditorModel {
        private ItemEditorHelper itemEditorHelper;

        public final String getEditorText() {
            return this.itemEditorHelper == null ? null : this.itemEditorHelper.getEditorText();
        }

        public final JTextComponent getEditorComponent() {
            return this.itemEditorHelper == null ? null : this.itemEditorHelper.getEditorComponent();
        }

        public abstract String getItemValue();

        public abstract boolean setItemValue(String var1);

        public abstract void documentUpdated();
    }
}

