/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.nb.ast.ArgsNode;
import org.jruby.nb.ast.ListNode;
import org.jruby.nb.ast.MultipleAsgnNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.netbeans.modules.ruby.ParseTreeVisitor;
import org.netbeans.modules.ruby.ParseTreeWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InputOutputVarFinder
implements ParseTreeVisitor {
    private static final int WHEN_BEFORE = 0;
    private static final int WHEN_DURING = 1;
    private static final int WHEN_AFTER = 2;
    private final Node startNode;
    private final Node endNode;
    private final List<Node> applicableBlocks;
    private int when = 0;
    private int ifs;
    private Node currentBlock;
    private final List<Node> blockStack = new ArrayList<Node>();
    private Map<Node, UsageScope> blockScopes = new HashMap<Node, UsageScope>();
    private UsageScope methodScope = new UsageScope(null);
    private UsageScope blockScope;

    InputOutputVarFinder(Node node, Node node2, List<Node> list) {
        this.startNode = node;
        this.endNode = node2;
        this.applicableBlocks = list;
    }

    public Set<String> getInputVars() {
        UsageScope usageScope = this.methodScope;
        for (UsageScope object2 : this.blockScopes.values()) {
            if (object2.block != null && !this.applicableBlocks.contains(object2.block)) continue;
            usageScope.merge(object2);
        }
        HashSet hashSet = new HashSet(usageScope.readDuring);
        hashSet.removeAll(usageScope.writtenBeforeReadDuring);
        HashSet hashSet2 = new HashSet(usageScope.writtenDuring);
        hashSet2.retainAll(usageScope.readAfter);
        HashSet hashSet3 = new HashSet(usageScope.writtenBefore);
        hashSet3.retainAll(hashSet2);
        hashSet3.removeAll(usageScope.writtenBeforeReadDuring);
        hashSet.addAll(hashSet3);
        return hashSet;
    }

    public Set<String> getOutputVars() {
        UsageScope usageScope = this.methodScope;
        for (UsageScope usageScope2 : this.blockScopes.values()) {
            if (usageScope2.block != null && !this.applicableBlocks.contains(usageScope2.block)) continue;
            usageScope.merge(usageScope2);
        }
        HashSet hashSet = new HashSet(usageScope.writtenDuring);
        hashSet.retainAll(usageScope.readAfter);
        return hashSet;
    }

    public boolean visit(Node node) {
        if (node == this.startNode) {
            this.when = 1;
        }
        switch (node.nodeId) {
            case ARGSNODE: {
                Object object;
                assert (this.when == 0);
                ArgsNode argsNode = (ArgsNode)node;
                if (argsNode.getRequiredArgsCount() > 0) {
                    object = argsNode.childNodes();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Node node2 = (Node)iterator.next();
                        if (!(node2 instanceof ListNode)) continue;
                        List list = node2.childNodes();
                        for (Node node3 : list) {
                            if (node3.nodeId == NodeType.ARGUMENTNODE) {
                                this.methodScope.write(((INameNode)node3).getName());
                                continue;
                            }
                            if (node3.nodeId != NodeType.LOCALASGNNODE) continue;
                            this.methodScope.write(((INameNode)node3).getName());
                        }
                    }
                }
                if (argsNode.getRestArgNode() != null) {
                    object = argsNode.getRestArgNode().getName();
                    this.methodScope.write((String)object);
                }
                if (argsNode.getBlockArgNode() != null) {
                    object = argsNode.getBlockArgNode().getName();
                    this.methodScope.write((String)object);
                }
                return true;
            }
            case ITERNODE: {
                this.blockStack.add(node);
                this.currentBlock = node;
                this.blockScope = new UsageScope(this.currentBlock);
                this.blockScopes.put(this.currentBlock, this.blockScope);
                if (this.when != 1) break;
                this.applicableBlocks.add(node);
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: 
            case CLASSNODE: 
            case SCLASSNODE: 
            case MODULENODE: {
                return this.when != 0;
            }
            case DVARNODE: {
                String string = ((INameNode)node).getName();
                this.blockScope.read(string);
                break;
            }
            case LOCALVARNODE: {
                String string = ((INameNode)node).getName();
                this.methodScope.read(string);
                break;
            }
            case MULTIPLEASGNNODE: {
                MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
                if (multipleAsgnNode.getValueNode() == null) break;
                new ParseTreeWalker((ParseTreeVisitor)this).walk(multipleAsgnNode.getValueNode());
                break;
            }
            case WHENNODE: 
            case IFNODE: {
                ++this.ifs;
            }
        }
        return false;
    }

    public boolean unvisit(Node node) {
        switch (node.nodeId) {
            case ITERNODE: {
                this.blockStack.remove(this.blockStack.size() - 1);
                Node node2 = this.currentBlock = this.blockStack.size() > 0 ? this.blockStack.get(this.blockStack.size() - 1) : null;
                if (this.currentBlock == null) break;
                this.blockScope = this.blockScopes.get(this.currentBlock);
                assert (this.blockScope != null);
                break;
            }
            case LOCALASGNNODE: {
                String string = ((INameNode)node).getName();
                this.methodScope.write(string);
                break;
            }
            case DASGNNODE: {
                String string = ((INameNode)node).getName();
                this.blockScope.write(string);
                break;
            }
            case WHENNODE: 
            case IFNODE: {
                --this.ifs;
            }
        }
        if (node == this.endNode) {
            this.when = 2;
        }
        return false;
    }

    private class UsageScope {
        private Node block;
        private final Set<String> writtenBefore = new HashSet<String>();
        private final Set<String> readDuring = new HashSet<String>();
        private final Set<String> writtenDuring = new HashSet<String>();
        private final Set<String> writtenBeforeReadDuring = new HashSet<String>();
        private final Set<String> writtenAfter = new HashSet<String>();
        private final Set<String> readAfter = new HashSet<String>();

        UsageScope(Node node) {
            this.block = node;
        }

        private void read(String string) {
            if (InputOutputVarFinder.this.when == 1) {
                if (!this.writtenBeforeReadDuring.contains(string)) {
                    this.readDuring.add(string);
                }
            } else if (InputOutputVarFinder.this.when == 2 && !this.writtenAfter.contains(string)) {
                this.readAfter.add(string);
            }
        }

        private void write(String string) {
            if (InputOutputVarFinder.this.when == 0) {
                this.writtenBefore.add(string);
            } else if (InputOutputVarFinder.this.when == 1) {
                this.writtenDuring.add(string);
                if (InputOutputVarFinder.this.ifs == 0 && !this.readDuring.contains(string)) {
                    this.writtenBeforeReadDuring.add(string);
                }
            } else if (InputOutputVarFinder.this.when == 2 && InputOutputVarFinder.this.ifs == 0 && !this.readAfter.contains(string)) {
                this.writtenAfter.add(string);
            }
        }

        private void merge(UsageScope usageScope) {
            this.writtenBefore.addAll(usageScope.writtenBefore);
            this.readDuring.addAll(usageScope.readDuring);
            this.writtenDuring.addAll(usageScope.writtenDuring);
            this.writtenBeforeReadDuring.addAll(usageScope.writtenBeforeReadDuring);
            this.writtenAfter.addAll(usageScope.writtenAfter);
            this.readAfter.addAll(usageScope.readAfter);
        }
    }
}

