/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintFix;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.hints.NestedLocal;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsViews
extends RubyAstRule {
    public boolean appliesTo(RuleContext ruleContext) {
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        return compilationInfo.getFileObject().getName().endsWith("_controller");
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.DEFNNODE);
    }

    @Override
    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        Node node = rubyRuleContext.node;
        CompilationInfo compilationInfo = rubyRuleContext.compilationInfo;
        FileObject fileObject = compilationInfo.getFileObject();
        assert (fileObject.getName().endsWith("_controller"));
        Arity arity = Arity.getDefArity((Node)node);
        if (arity.getMinArgs() != 0 || arity.getMaxArgs() != 0) {
            return;
        }
        String string = ((INameNode)node).getName();
        FileObject fileObject2 = RubyUtils.getRailsViewFor((FileObject)fileObject, (String)string, (boolean)false, (boolean)true);
        if (fileObject2 == null && this.shouldHaveView(compilationInfo, node) && this.isPublic(rubyRuleContext.parserResult, node)) {
            String string2 = NbBundle.getMessage(RailsViews.class, (String)"MissingView");
            OffsetRange offsetRange = AstUtilities.getNameRange((Node)node);
            List<CreateViewFix> list2 = Collections.singletonList(new CreateViewFix(fileObject, string));
            Hint hint = new Hint((Rule)this, string2, fileObject, offsetRange, list2, 400);
            list.add(hint);
        }
    }

    private boolean isPublic(ParserResult parserResult, Node node) {
        Set set;
        RubyParseResult rubyParseResult = (RubyParseResult)parserResult;
        AstElement astElement = rubyParseResult.getStructure().getElementFor(node);
        if (astElement != null && (set = astElement.getModifiers()) != null) {
            return !set.contains(Modifier.PRIVATE) && !set.contains(Modifier.PROTECTED);
        }
        return true;
    }

    private boolean shouldHaveView(CompilationInfo compilationInfo, Node node) {
        Object object;
        if (node.nodeId == NodeType.FCALLNODE && ((String)(object = ((INameNode)node).getName())).startsWith("redirect_")) {
            return false;
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Node node2 = (Node)iterator.next();
            if (node2.isInvisible() || (bl = this.shouldHaveView(compilationInfo, node2))) continue;
            return bl;
        }
        return true;
    }

    public String getId() {
        return "Rails_Views";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RailsViews.class, (String)"FindActionViews");
    }

    public String getDescription() {
        return NbBundle.getMessage(RailsViews.class, (String)"FindActionViewsDesc");
    }

    public boolean getDefaultEnabled() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return false;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private static class CreateViewFix
    implements HintFix {
        private FileObject controller;
        private String action;

        CreateViewFix(FileObject fileObject, String string) {
            this.controller = fileObject;
            this.action = string;
        }

        public String getDescription() {
            return NbBundle.getMessage(NestedLocal.class, (String)"CreateView");
        }

        public void implement() throws Exception {
            String string = RubyUtils.getControllerName((FileObject)this.controller);
            Project project = FileOwnerQuery.getOwner((FileObject)this.controller);
            if (project == null) {
                return;
            }
            try {
                Class<?> clazz = Class.forName("org.netbeans.modules.ruby.railsprojects.GenerateAction", true, Thread.currentThread().getContextClassLoader());
                if (clazz != null) {
                    SystemAction systemAction = SystemAction.get(clazz);
                    Method method = clazz.getMethod("generate", Project.class, String.class, String.class, String.class);
                    method.invoke((Object)systemAction, project, "controller", string, this.action);
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }
    }
}

